/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.log;

import android.content.Context;
import android.util.Log;
import com.mob.tools.log.LogCollector;
import com.mob.tools.log.LogPrinter;
import com.mob.tools.log.MobUncaughtExceptionHandler;
import com.mob.tools.log.NativeErrorHandler;
import java.util.HashMap;

public abstract class NLog {
    private static HashMap<String, NLog> loggers = new HashMap();
    private static LogPrinter printer = new LogPrinter();

    static {
        MobUncaughtExceptionHandler.register();
    }

    public NLog() {
        loggers.put(this.getSDKTag(), this);
        if (loggers.size() == 1) {
            loggers.put("__FIRST__", this);
        }
    }

    protected static final NLog getInstanceForSDK(final String string2, boolean bl) {
        NLog nLog;
        NLog nLog2 = nLog = loggers.get(string2);
        if (nLog == null) {
            nLog2 = loggers.get("__FIRST__");
        }
        nLog = nLog2;
        if (nLog2 == null) {
            nLog = nLog2;
            if (bl) {
                nLog = new NLog(){

                    @Override
                    protected String getSDKTag() {
                        return string2;
                    }
                };
            }
        }
        return nLog;
    }

    public static void setCollector(String string2, LogCollector logCollector) {
        printer.setCollector(string2, logCollector);
    }

    public static void setContext(Context context) {
        if (context != null) {
            printer.setContext(context);
            NativeErrorHandler.prepare(context);
        }
    }

    public final int crash(Throwable throwable) {
        return printer.println(this.getSDKTag(), 6, 1, Log.getStackTraceString((Throwable)throwable));
    }

    public final int d(Object object, Object ... objectArray) {
        object = object.toString();
        if (objectArray.length > 0) {
            object = String.format((String)object, objectArray);
        }
        return printer.println(this.getSDKTag(), 3, 0, (String)object);
    }

    public final int d(Throwable throwable) {
        return printer.println(this.getSDKTag(), 3, 0, Log.getStackTraceString((Throwable)throwable));
    }

    public final int d(Throwable object, Object object2, Object ... objectArray) {
        String string2 = object2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        object2 = string2;
        if (objectArray.length > 0) {
            object2 = String.format(string2, objectArray);
        }
        object = stringBuilder.append((String)object2).append('\n').append(Log.getStackTraceString((Throwable)object)).toString();
        return printer.println(this.getSDKTag(), 3, 0, (String)object);
    }

    public final int e(Object object, Object ... objectArray) {
        object = object.toString();
        if (objectArray.length > 0) {
            object = String.format((String)object, objectArray);
        }
        return printer.println(this.getSDKTag(), 6, 0, (String)object);
    }

    public final int e(Throwable throwable) {
        return printer.println(this.getSDKTag(), 6, 0, Log.getStackTraceString((Throwable)throwable));
    }

    public final int e(Throwable object, Object object2, Object ... objectArray) {
        String string2 = object2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        object2 = string2;
        if (objectArray.length > 0) {
            object2 = String.format(string2, objectArray);
        }
        object = stringBuilder.append((String)object2).append('\n').append(Log.getStackTraceString((Throwable)object)).toString();
        return printer.println(this.getSDKTag(), 6, 0, (String)object);
    }

    protected abstract String getSDKTag();

    public final int i(Object object, Object ... objectArray) {
        object = object.toString();
        if (objectArray.length > 0) {
            object = String.format((String)object, objectArray);
        }
        return printer.println(this.getSDKTag(), 4, 0, (String)object);
    }

    public final int i(Throwable throwable) {
        return printer.println(this.getSDKTag(), 4, 0, Log.getStackTraceString((Throwable)throwable));
    }

    public final int i(Throwable object, Object object2, Object ... objectArray) {
        String string2 = object2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        object2 = string2;
        if (objectArray.length > 0) {
            object2 = String.format(string2, objectArray);
        }
        object = stringBuilder.append((String)object2).append('\n').append(Log.getStackTraceString((Throwable)object)).toString();
        return printer.println(this.getSDKTag(), 4, 0, (String)object);
    }

    public final void nativeCrashLog(String string2) {
        printer.nativeCrashLog(this.getSDKTag(), string2);
    }

    public final int v(Object object, Object ... objectArray) {
        object = object.toString();
        if (objectArray.length > 0) {
            object = String.format((String)object, objectArray);
        }
        return printer.println(this.getSDKTag(), 2, 0, (String)object);
    }

    public final int v(Throwable throwable) {
        return printer.println(this.getSDKTag(), 2, 0, Log.getStackTraceString((Throwable)throwable));
    }

    public final int v(Throwable object, Object object2, Object ... objectArray) {
        String string2 = object2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        object2 = string2;
        if (objectArray.length > 0) {
            object2 = String.format(string2, objectArray);
        }
        object = stringBuilder.append((String)object2).append('\n').append(Log.getStackTraceString((Throwable)object)).toString();
        return printer.println(this.getSDKTag(), 2, 0, (String)object);
    }

    public final int w(Object object, Object ... objectArray) {
        object = object.toString();
        if (objectArray.length > 0) {
            object = String.format((String)object, objectArray);
        }
        return printer.println(this.getSDKTag(), 5, 0, (String)object);
    }

    public final int w(Throwable throwable) {
        return printer.println(this.getSDKTag(), 5, 0, Log.getStackTraceString((Throwable)throwable));
    }

    public final int w(Throwable object, Object object2, Object ... objectArray) {
        String string2 = object2.toString();
        StringBuilder stringBuilder = new StringBuilder();
        object2 = string2;
        if (objectArray.length > 0) {
            object2 = String.format(string2, objectArray);
        }
        object = stringBuilder.append((String)object2).append('\n').append(Log.getStackTraceString((Throwable)object)).toString();
        return printer.println(this.getSDKTag(), 5, 0, (String)object);
    }
}

