/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.log;

import android.util.Log;
import com.mob.tools.MobLog;

public class MobUncaughtExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static boolean disable;
    private static boolean isDebug;
    private static Thread.UncaughtExceptionHandler oriHandler;

    static {
        isDebug = true;
    }

    public static void closeLog() {
        isDebug = false;
    }

    public static void disable() {
        disable = true;
    }

    public static void openLog() {
        isDebug = true;
    }

    public static void register() {
        if (!disable) {
            oriHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(new MobUncaughtExceptionHandler());
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        if (isDebug) {
            Log.wtf((String)"MobUncaughtExceptionHandler", (Throwable)throwable);
        }
        MobLog.getInstance().crash(throwable);
        if (oriHandler != null) {
            oriHandler.uncaughtException(thread, throwable);
        }
    }
}

