/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.mob.tools.gui.ViewPagerAdapter;
import com.mob.tools.utils.R;

public class ViewPagerClassic
extends ViewGroup {
    private static final int SNAP_VELOCITY = 500;
    private static final int TOUCH_STATE_REST = 0;
    private static final int TOUCH_STATE_SCROLLING = 1;
    private ViewPagerAdapter adapter;
    private int currentScreen;
    private float lastMotionX;
    private float lastMotionY;
    private int mMaximumVelocity;
    private VelocityTracker mVelocityTracker;
    private Scroller scroller;
    private int touchSlop;
    private int touchState = 0;

    public ViewPagerClassic(Context context) {
        this(context, null);
    }

    public ViewPagerClassic(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ViewPagerClassic(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleInterceptMove(MotionEvent motionEvent) {
        float f2 = motionEvent.getX();
        float f3 = motionEvent.getY();
        int n2 = (int)Math.abs(f2 - this.lastMotionX);
        int n3 = (int)Math.abs(f3 - this.lastMotionY);
        n2 = n2 > this.touchSlop ? 1 : 0;
        n3 = n3 > this.touchSlop ? 1 : 0;
        if ((n2 != 0 || n3 != 0) && n2 != 0) {
            this.touchState = 1;
            this.lastMotionX = f2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void handleScrollMove(MotionEvent motionEvent) {
        int n2;
        if (this.adapter == null) return;
        float f2 = motionEvent.getX();
        int n3 = (int)(this.lastMotionX - f2);
        this.lastMotionX = f2;
        if (n3 < 0) {
            if (this.getScrollX() <= 0) return;
            this.scrollBy(Math.max(-this.getScrollX(), n3), 0);
            return;
        }
        if (n3 <= 0 || this.getChildCount() == 0 || (n2 = this.getChildAt(this.getChildCount() - 1).getRight() - this.getScrollX() - this.getWidth()) <= 0) {
            return;
        }
        this.scrollBy(Math.min(n2, n3), 0);
    }

    private void init(Context context) {
        this.scroller = new Scroller(this.getContext(), new Interpolator(){
            float[] values = new float[]{0.0f, 0.0157073f, 0.0314108f, 0.0471065f, 0.0627905f, 0.0784591f, 0.0941083f, 0.109734f, 0.125333f, 0.140901f, 0.156434f, 0.171929f, 0.187381f, 0.202787f, 0.218143f, 0.233445f, 0.24869f, 0.263873f, 0.278991f, 0.29404f, 0.309017f, 0.323917f, 0.338738f, 0.353475f, 0.368125f, 0.382683f, 0.397148f, 0.411514f, 0.425779f, 0.439939f, 0.45399f, 0.46793f, 0.481754f, 0.495459f, 0.509041f, 0.522499f, 0.535827f, 0.549023f, 0.562083f, 0.575005f, 0.587785f, 0.60042f, 0.612907f, 0.625243f, 0.637424f, 0.649448f, 0.661312f, 0.673013f, 0.684547f, 0.695913f, 0.707107f, 0.718126f, 0.728969f, 0.739631f, 0.750111f, 0.760406f, 0.770513f, 0.78043f, 0.790155f, 0.799685f, 0.809017f, 0.81815f, 0.827081f, 0.835807f, 0.844328f, 0.85264f, 0.860742f, 0.868632f, 0.876307f, 0.883766f, 0.891007f, 0.898028f, 0.904827f, 0.911403f, 0.917755f, 0.92388f, 0.929776f, 0.935444f, 0.940881f, 0.946085f, 0.951057f, 0.955793f, 0.960294f, 0.964557f, 0.968583f, 0.97237f, 0.975917f, 0.979223f, 0.982287f, 0.985109f, 0.987688f, 0.990024f, 0.992115f, 0.993961f, 0.995562f, 0.996917f, 0.998027f, 0.99889f, 0.999507f, 0.999877f, 1.0f};

            public float getInterpolation(float f2) {
                int n2 = (int)(100.0f * f2);
                return this.values[n2];
            }
        });
        context = ViewConfiguration.get((Context)context);
        this.touchSlop = context.getScaledTouchSlop();
        this.mMaximumVelocity = context.getScaledMaximumFlingVelocity();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void scrollToScreen(int n2, boolean bl) {
        int n3 = n2 != this.currentScreen ? 1 : 0;
        View view = this.getFocusedChild();
        if (view != null && n3 != 0 && view == this.getChildAt(this.currentScreen)) {
            view.clearFocus();
        }
        n3 = n2 * this.getWidth() - this.getScrollX();
        view = this.scroller;
        int n4 = this.getScrollX();
        n2 = bl ? 0 : Math.abs(n3) / 2;
        view.startScroll(n4, 0, n3, 0, n2);
        this.invalidate();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void computeScroll() {
        int n2;
        block6: {
            block5: {
                int n3;
                if (this.adapter == null) break block5;
                if (this.scroller.computeScrollOffset()) {
                    this.scrollTo(this.scroller.getCurrX(), this.scroller.getCurrY());
                    this.postInvalidate();
                    return;
                }
                n2 = this.currentScreen;
                int n4 = this.scroller.getCurrX();
                int n5 = this.getWidth();
                int n6 = n3 = n4 / n5;
                if (n4 % n5 > n5 / 2) {
                    n6 = n3 + 1;
                }
                this.currentScreen = Math.max(0, Math.min(n6, this.getChildCount() - 1));
                if (n2 != this.currentScreen && this.adapter != null) break block6;
            }
            return;
        }
        this.adapter.onScreenChange(this.currentScreen, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void dispatchDraw(Canvas canvas) {
        long l2;
        block5: {
            block4: {
                if (this.adapter == null || this.getChildCount() <= 0) break block4;
                l2 = this.getDrawingTime();
                if (this.currentScreen > 0) {
                    this.drawChild(canvas, this.getChildAt(this.currentScreen - 1), l2);
                }
                this.drawChild(canvas, this.getChildAt(this.currentScreen), l2);
                if (this.currentScreen < this.getChildCount() - 1) break block5;
            }
            return;
        }
        this.drawChild(canvas, this.getChildAt(this.currentScreen + 1), l2);
    }

    public boolean dispatchUnhandledMove(View view, int n2) {
        if (this.adapter == null) {
            return super.dispatchUnhandledMove(view, n2);
        }
        if (n2 == 17) {
            if (this.currentScreen > 0) {
                this.scrollToScreen(this.currentScreen - 1);
                return true;
            }
        } else if (n2 == 66 && this.currentScreen < this.getChildCount() - 1) {
            this.scrollToScreen(this.currentScreen + 1);
            return true;
        }
        return super.dispatchUnhandledMove(view, n2);
    }

    public int getCurrentScreen() {
        return this.currentScreen;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        block11: {
            block10: {
                int n2 = motionEvent.getAction();
                if (n2 == 2 && this.touchState != 0) break block10;
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                }
                this.mVelocityTracker.addMovement(motionEvent);
                switch (n2) {
                    case 2: {
                        this.handleInterceptMove(motionEvent);
                        break;
                    }
                    case 0: {
                        float f2 = motionEvent.getX();
                        float f3 = motionEvent.getY();
                        this.lastMotionX = f2;
                        this.lastMotionY = f3;
                        n2 = this.scroller.isFinished() ? 0 : 1;
                        this.touchState = n2;
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.mVelocityTracker != null) {
                            this.mVelocityTracker.recycle();
                            this.mVelocityTracker = null;
                        }
                        this.touchState = 0;
                        break;
                    }
                }
                if (this.touchState == 0) break block11;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        if (this.adapter != null) {
            int n6 = 0;
            int n7 = n4 - n2;
            int n8 = this.getChildCount();
            n4 = n6;
            for (n2 = 0; n2 < n8; ++n2) {
                View view = this.getChildAt(n2);
                n6 = n4;
                if (view.getVisibility() != 8) {
                    view.layout(n4, 0, n4 + n7, n5 - n3);
                    n6 = n4 + n7;
                }
                n4 = n6;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void onMeasure(int n2, int n3) {
        if (this.adapter == null) {
            super.onMeasure(n2, n3);
            return;
        } else {
            int n4 = this.getChildCount();
            n3 = 0;
            int n5 = View.MeasureSpec.makeMeasureSpec((int)R.getScreenWidth(this.getContext()), (int)0x40000000);
            for (n2 = 0; n2 < n4; ++n2) {
                View view = this.getChildAt(n2);
                view.measure(n5, 0);
                int n6 = view.getMeasuredHeight();
                int n7 = n3;
                if (n6 > n3) {
                    n7 = n6;
                }
                n3 = n7;
            }
            n3 = View.MeasureSpec.makeMeasureSpec((int)n3, (int)0x40000000);
            super.onMeasure(n5, n3);
            for (n2 = 0; n2 < n4; ++n2) {
                this.getChildAt(n2).measure(n5, n3);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (this.adapter == null) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(motionEvent);
        int n2 = motionEvent.getAction();
        float f2 = motionEvent.getX();
        switch (n2) {
            case 0: {
                if (this.touchState == 0) return true;
                if (!this.scroller.isFinished()) {
                    this.scroller.abortAnimation();
                }
                this.lastMotionX = f2;
                return true;
            }
            case 2: {
                if (this.touchState == 1) {
                    this.handleScrollMove(motionEvent);
                    return true;
                }
                if (!this.onInterceptTouchEvent(motionEvent)) return true;
                if (this.touchState != 1) return true;
                this.handleScrollMove(motionEvent);
                return true;
            }
            case 1: {
                if (this.touchState == 1) {
                    motionEvent = this.mVelocityTracker;
                    motionEvent.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                    n2 = (int)motionEvent.getXVelocity();
                    if (n2 > 500 && this.currentScreen > 0) {
                        this.scrollToScreen(this.currentScreen - 1);
                    } else if (n2 < -500 && this.currentScreen < this.getChildCount() - 1) {
                        this.scrollToScreen(this.currentScreen + 1);
                    } else {
                        n2 = this.getWidth();
                        this.scrollToScreen((this.getScrollX() + n2 / 2) / n2);
                    }
                    if (this.mVelocityTracker != null) {
                        this.mVelocityTracker.recycle();
                        this.mVelocityTracker = null;
                    }
                }
                this.touchState = 0;
                return true;
            }
            case 3: {
                this.touchState = 0;
                return true;
            }
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void scrollLeft() {
        if (this.adapter == null || this.currentScreen <= 0 || !this.scroller.isFinished()) {
            return;
        }
        this.scrollToScreen(this.currentScreen - 1);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void scrollRight() {
        if (this.adapter == null || this.currentScreen >= this.getChildCount() - 1 || !this.scroller.isFinished()) {
            return;
        }
        this.scrollToScreen(this.currentScreen + 1);
    }

    public void scrollToScreen(int n2) {
        this.scrollToScreen(n2, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setAdapter(ViewPagerAdapter viewPagerAdapter) {
        this.adapter = viewPagerAdapter;
        this.removeAllViews();
        this.currentScreen = 0;
        if (this.adapter != null) {
            int n2 = viewPagerAdapter.getCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.addView(viewPagerAdapter.getView(i2, null, this));
            }
        }
    }

    public void setCurrentScreen(int n2) {
        if (this.adapter == null) {
            return;
        }
        if (!this.scroller.isFinished()) {
            this.scroller.abortAnimation();
        }
        int n3 = this.currentScreen;
        this.currentScreen = Math.max(0, Math.min(n2, this.getChildCount()));
        this.adapter.onScreenChange(this.currentScreen, n3);
        n2 = R.getScreenWidth(this.getContext());
        n2 = this.currentScreen * n2;
        this.scroller.startScroll(0, 0, n2, 0);
        this.scrollTo(n2, 0);
    }
}

