/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

public class CachePool<K, V> {
    private int capacity;
    private Node<K, V> head;
    private int size;
    private Node<K, V> tail;

    public CachePool(int n2) {
        this.capacity = n2;
    }

    public void clear() {
        synchronized (this) {
            this.tail = null;
            this.head = null;
            this.size = 0;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public V get(K object) {
        Object var3_2 = null;
        synchronized (this) {
            Node<K, V> node = this.head;
            while (true) {
                if (node == null || node.key.equals(object)) {
                    object = var3_2;
                    if (node != null) {
                        if (node.previous != null) {
                            if (node.next == null) {
                                node.previous.next = null;
                                this.tail = this.tail.previous;
                            } else {
                                node.previous.next = node.next;
                                node.next.previous = node.previous;
                            }
                            node.previous = null;
                            node.next = this.head;
                            this.head.previous = node;
                            this.head = node;
                        }
                        object = node.value;
                    }
                    return (V)object;
                }
                node = node.next;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean put(K k2, V v2) {
        synchronized (this) {
            if (k2 == null) return false;
            int n2 = this.capacity;
            if (n2 <= 0) {
                return false;
            }
            Node<K, V> node = null;
            while (this.size >= this.capacity) {
                node = this.tail;
                this.tail = this.tail.previous;
                this.tail.next = null;
                --this.size;
            }
            Node<K, V> node2 = node;
            if (node == null) {
                node2 = new Node();
            }
            Node.access$102(node2, System.currentTimeMillis());
            node2.key = k2;
            node2.value = v2;
            node2.previous = null;
            node2.next = this.head;
            if (this.size == 0) {
                this.tail = node2;
            } else {
                this.head.previous = node2;
            }
            this.head = node2;
            ++this.size;
            return true;
        }
    }

    public int size() {
        return this.size;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void trimBeforeTime(long l2) {
        synchronized (this) {
            int n2 = this.capacity;
            if (n2 > 0) {
                Node<K, V> node = this.head;
                while (node != null) {
                    if (((Node)node).cacheTime < l2) {
                        if (node.previous != null) {
                            node.previous.next = node.next;
                        }
                        if (node.next != null) {
                            node.next.previous = node.previous;
                        }
                        if (node.equals(this.head)) {
                            this.head = this.head.next;
                        }
                        --this.size;
                    }
                    node = node.next;
                }
            }
            return;
        }
    }

    private static class Node<K, V> {
        private long cacheTime;
        public K key;
        public Node<K, V> next;
        public Node<K, V> previous;
        public V value;

        private Node() {
        }

        static /* synthetic */ long access$102(Node node, long l2) {
            node.cacheTime = l2;
            return l2;
        }
    }
}

