/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Bitmap;
import com.mob.tools.MobLog;
import com.mob.tools.gui.CachePool;
import com.mob.tools.network.NetworkHelper;
import com.mob.tools.network.RawNetworkCallback;
import com.mob.tools.utils.BitmapHelper;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.R;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;

public class BitmapProcessor {
    private static final int CAPACITY = 3;
    private static final int MAX_CACHE_SIZE = 50;
    private static final int MAX_CACHE_TIME = 60000;
    private static final int MAX_REQ_TIME = 200;
    private static final int MAX_SIZE = 100;
    private static final int OVERFLOW_SIZE = 120;
    private static BitmapProcessor instance;
    private File cacheDir;
    private CachePool<String, Bitmap> cachePool;
    private ManagerThread manager;
    private int maxReqCount;
    private Vector<ImageReq> netReqTPS;
    private int overflowReqCount;
    private Vector<ImageReq> reqList;
    private int reqTimeout;
    private boolean work;
    private WorkerThread[] workerList;

    /*
     * Enabled aggressive block sorting
     */
    private BitmapProcessor(Context context, int n2, int n3, int n4, float f2, int n5) {
        if (n3 <= 0) {
            n3 = 200;
        }
        this.reqTimeout = n3;
        n3 = n4 > 0 ? n4 : 100;
        this.maxReqCount = n3;
        n3 = f2 > 1.0f ? (int)((float)n4 * f2) : 120;
        this.overflowReqCount = n3;
        this.reqList = new Vector();
        this.netReqTPS = new Vector();
        if (n2 <= 0) {
            n2 = 3;
        }
        this.workerList = new WorkerThread[n2];
        if (n5 <= 0) {
            n5 = 50;
        }
        this.cachePool = new CachePool(n5);
        this.cacheDir = new File(R.getImageCachePath(context));
        this.manager = new ManagerThread(this);
    }

    public static Bitmap getBitmapFromCache(String string2) {
        if (instance == null) {
            return null;
        }
        return BitmapProcessor.instance.cachePool.get(string2);
    }

    public static void prepare(Context context) {
        synchronized (BitmapProcessor.class) {
            BitmapProcessor.prepare(context, 0, 0, 0, 0.0f, 0);
            return;
        }
    }

    public static void prepare(Context context, int n2, int n3, int n4, float f2, int n5) {
        synchronized (BitmapProcessor.class) {
            if (instance == null) {
                instance = new BitmapProcessor(context.getApplicationContext(), n2, n3, n4, f2, n5);
            }
            return;
        }
    }

    public static void process(String string2, BitmapCallback bitmapCallback) {
        if (instance == null || string2 == null) {
            return;
        }
        ImageReq imageReq = new ImageReq();
        ImageReq.access$002(imageReq, string2);
        ImageReq.access$102(imageReq, bitmapCallback);
        BitmapProcessor.instance.reqList.add(imageReq);
        if (BitmapProcessor.instance.reqList.size() > BitmapProcessor.instance.overflowReqCount) {
            while (BitmapProcessor.instance.reqList.size() > BitmapProcessor.instance.maxReqCount) {
                BitmapProcessor.instance.reqList.remove(0);
            }
        }
        BitmapProcessor.start();
    }

    public static void start() {
        if (instance == null) {
            throw new RuntimeException("Call BitmapProcessor.prepare(String) before start");
        }
        BitmapProcessor.instance.work = true;
    }

    public static void stop() {
        if (instance != null) {
            BitmapProcessor.instance.work = false;
            BitmapProcessor.instance.reqList.clear();
            BitmapProcessor.instance.manager.cancel();
            for (int i2 = 0; i2 < BitmapProcessor.instance.workerList.length; ++i2) {
                if (BitmapProcessor.instance.workerList[i2] == null) continue;
                BitmapProcessor.instance.workerList[i2].interrupt();
            }
            instance = null;
        }
    }

    public static interface BitmapCallback {
        public void onImageGot(String var1, Bitmap var2);
    }

    public static class ImageReq {
        private BitmapCallback callback;
        private Bitmap image;
        private long reqTime = System.currentTimeMillis();
        private String url;
        private WorkerThread worker;

        static /* synthetic */ String access$002(ImageReq imageReq, String string2) {
            imageReq.url = string2;
            return string2;
        }

        static /* synthetic */ BitmapCallback access$102(ImageReq imageReq, BitmapCallback bitmapCallback) {
            imageReq.callback = bitmapCallback;
            return bitmapCallback;
        }

        static /* synthetic */ WorkerThread access$1102(ImageReq imageReq, WorkerThread workerThread) {
            imageReq.worker = workerThread;
            return workerThread;
        }

        private void throwComplete(Bitmap bitmap) {
            this.image = bitmap;
            if (this.callback != null) {
                this.callback.onImageGot(this.url, this.image);
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("url=").append(this.url);
            stringBuilder.append("time=").append(this.reqTime);
            stringBuilder.append("worker=").append(this.worker.getName()).append(" (").append(this.worker.getId()).append("");
            return stringBuilder.toString();
        }
    }

    private static class ManagerThread
    extends Timer {
        private BitmapProcessor processor;

        public ManagerThread(BitmapProcessor bitmapProcessor) {
            this.processor = bitmapProcessor;
            this.schedule(new TimerTask(){
                private int counter;

                @Override
                public void run() {
                    if (ManagerThread.this.processor.work) {
                        --this.counter;
                        if (this.counter <= 0) {
                            this.counter = 100;
                            ManagerThread.this.scan();
                        }
                    }
                }
            }, 0L, (long)this.processor.reqTimeout);
        }

        /*
         * Enabled aggressive block sorting
         */
        private void scan() {
            if (this.processor.cachePool != null) {
                this.processor.cachePool.trimBeforeTime(System.currentTimeMillis() - 60000L);
            }
            int n2 = this.processor.cachePool == null ? 0 : this.processor.cachePool.size();
            MobLog.getInstance().d(">>>> BitmapProcessor.cachePool: " + n2, new Object[0]);
            n2 = this.processor.reqList == null ? 0 : this.processor.reqList.size();
            MobLog.getInstance().d(">>>> BitmapProcessor.reqList: " + n2, new Object[0]);
            if (this.processor.work) {
                long l2 = System.currentTimeMillis();
                for (n2 = 0; n2 < this.processor.workerList.length; ++n2) {
                    boolean bl;
                    if (this.processor.workerList[n2] == null) {
                        ((BitmapProcessor)this.processor).workerList[n2] = new WorkerThread(this.processor);
                        this.processor.workerList[n2].setName("worker " + n2);
                        WorkerThread workerThread = this.processor.workerList[n2];
                        bl = n2 == 0;
                        WorkerThread.access$902(workerThread, bl);
                        this.processor.workerList[n2].start();
                        continue;
                    }
                    if (l2 - this.processor.workerList[n2].lastReport <= (long)(this.processor.reqTimeout * 100)) continue;
                    this.processor.workerList[n2].interrupt();
                    bl = this.processor.workerList[n2].localType;
                    ((BitmapProcessor)this.processor).workerList[n2] = new WorkerThread(this.processor);
                    this.processor.workerList[n2].setName("worker " + n2);
                    WorkerThread.access$902(this.processor.workerList[n2], bl);
                    this.processor.workerList[n2].start();
                }
            }
        }
    }

    private static class PatchInputStream
    extends FilterInputStream {
        InputStream in;

        protected PatchInputStream(InputStream inputStream) {
            super(inputStream);
            this.in = inputStream;
        }

        @Override
        public long skip(long l2) throws IOException {
            long l3 = 0L;
            long l4;
            while (l3 < l2 && (l4 = this.in.skip(l2 - l3)) != 0L) {
                l3 += l4;
            }
            return l3;
        }
    }

    private static class WorkerThread
    extends Thread {
        private ImageReq curReq;
        private long lastReport;
        private boolean localType;
        private BitmapProcessor processor;

        public WorkerThread(BitmapProcessor bitmapProcessor) {
            this.processor = bitmapProcessor;
            this.lastReport = System.currentTimeMillis();
        }

        static /* synthetic */ ImageReq access$1602(WorkerThread workerThread, ImageReq imageReq) {
            workerThread.curReq = imageReq;
            return imageReq;
        }

        static /* synthetic */ boolean access$902(WorkerThread workerThread, boolean bl) {
            workerThread.localType = bl;
            return bl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void doLocalTask() throws Throwable {
            ImageReq imageReq = null;
            if (this.processor.reqList.size() > 0) {
                imageReq = (ImageReq)this.processor.reqList.remove(0);
            }
            if (imageReq != null) {
                Bitmap bitmap = (Bitmap)this.processor.cachePool.get(imageReq.url);
                if (bitmap != null) {
                    this.curReq = imageReq;
                    ImageReq.access$1102(this.curReq, this);
                    imageReq.throwComplete(bitmap);
                } else {
                    if (new File(this.processor.cacheDir, Data.MD5(imageReq.url)).exists()) {
                        this.doTask(imageReq);
                        this.lastReport = System.currentTimeMillis();
                        return;
                    }
                    if (this.processor.netReqTPS.size() > this.processor.maxReqCount) {
                        while (this.processor.reqList.size() > 0) {
                            this.processor.reqList.remove(0);
                        }
                        this.processor.netReqTPS.remove(0);
                    }
                    this.processor.netReqTPS.add(imageReq);
                }
                this.lastReport = System.currentTimeMillis();
                return;
            }
            this.lastReport = System.currentTimeMillis();
            try {
                Thread.sleep(30L);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void doNetworkTask() throws Throwable {
            ImageReq imageReq = null;
            if (this.processor.netReqTPS.size() > 0) {
                imageReq = (ImageReq)this.processor.netReqTPS.remove(0);
            }
            ImageReq imageReq2 = imageReq;
            if (imageReq == null) {
                imageReq2 = imageReq;
                if (this.processor.reqList.size() > 0) {
                    imageReq2 = (ImageReq)this.processor.reqList.remove(0);
                }
            }
            if (imageReq2 != null) {
                imageReq = (Bitmap)this.processor.cachePool.get(imageReq2.url);
                if (imageReq != null) {
                    this.curReq = imageReq2;
                    ImageReq.access$1102(this.curReq, this);
                    imageReq2.throwComplete((Bitmap)imageReq);
                } else {
                    this.doTask(imageReq2);
                }
                this.lastReport = System.currentTimeMillis();
                return;
            }
            this.lastReport = System.currentTimeMillis();
            try {
                Thread.sleep(30L);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void doTask(final ImageReq imageReq) throws Throwable {
            this.curReq = imageReq;
            ImageReq.access$1102(this.curReq, this);
            Bitmap bitmap = null;
            final boolean bl = imageReq.url.toLowerCase().endsWith("png") || imageReq.url.toLowerCase().endsWith("gif");
            final File file = new File(this.processor.cacheDir, Data.MD5(imageReq.url));
            if (file.exists()) {
                bitmap = BitmapHelper.getBitmap(file.getAbsolutePath());
                if (bitmap != null) {
                    this.processor.cachePool.put(imageReq.url, bitmap);
                    imageReq.throwComplete(bitmap);
                }
                this.curReq = null;
            } else {
                new NetworkHelper().rawGet(imageReq.url, new RawNetworkCallback(){

                    @Override
                    public void onResponse(InputStream inputStream) throws Throwable {
                        if ((inputStream = BitmapHelper.getBitmap(new PatchInputStream(inputStream), 1)) == null || inputStream.isRecycled()) {
                            WorkerThread.access$1602(WorkerThread.this, null);
                            return;
                        }
                        WorkerThread.this.saveFile((Bitmap)inputStream, file, bl);
                        if (inputStream != null) {
                            WorkerThread.this.processor.cachePool.put(imageReq.url, inputStream);
                            imageReq.throwComplete((Bitmap)inputStream);
                        }
                        WorkerThread.access$1602(WorkerThread.this, null);
                    }
                }, null);
            }
            if (bitmap != null) {
                this.processor.cachePool.put(imageReq.url, bitmap);
                imageReq.throwComplete(bitmap);
            }
            this.curReq = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void saveFile(Bitmap bitmap, File file, boolean bl) {
            try {
                if (file.exists()) {
                    file.delete();
                }
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                file.createNewFile();
                Bitmap.CompressFormat compressFormat = bl ? Bitmap.CompressFormat.PNG : Bitmap.CompressFormat.JPEG;
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                bitmap.compress(compressFormat, 100, (OutputStream)fileOutputStream);
                fileOutputStream.flush();
                fileOutputStream.close();
                return;
            }
            catch (Throwable throwable) {
                if (file.exists()) {
                    file.delete();
                }
                return;
            }
        }

        @Override
        public void interrupt() {
            try {
                super.interrupt();
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (this.processor.work) {
                try {
                    if (this.localType) {
                        this.doLocalTask();
                    }
                    this.doNetworkTask();
                    continue;
                }
                catch (Throwable throwable) {
                    MobLog.getInstance().w(throwable);
                    continue;
                }
                break;
            }
            return;
        }
    }
}

