/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.mob.tools.MobLog;
import com.mob.tools.gui.BitmapProcessor;
import com.mob.tools.utils.BitmapHelper;
import com.mob.tools.utils.UIHandler;
import java.util.Random;

public class AsyncImageView
extends ImageView
implements BitmapProcessor.BitmapCallback,
Handler.Callback {
    private static final int MSG_IMG_GOT = 1;
    private static final Random rnd = new Random();
    private Bitmap defaultBm;
    private int defaultRes;
    private float[] rect;
    private boolean scaleToCrop;
    private String url;

    public AsyncImageView(Context context) {
        super(context);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init(context);
    }

    public AsyncImageView(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
        this.init(context);
    }

    private int[] getSize() {
        int n2;
        int n3;
        block10: {
            block9: {
                int n4;
                block8: {
                    int n5;
                    block7: {
                        n3 = this.getWidth();
                        n5 = this.getHeight();
                        if (n3 == 0) break block7;
                        n4 = n5;
                        n2 = n3;
                        if (n5 != 0) break block8;
                    }
                    ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
                    n4 = n5;
                    n2 = n3;
                    if (layoutParams != null) {
                        n2 = layoutParams.width;
                        n4 = layoutParams.height;
                    }
                }
                if (n2 == 0) break block9;
                n3 = n4;
                if (n4 != 0) break block10;
            }
            this.measure(0, 0);
            n2 = this.getMeasuredWidth();
            n3 = this.getMeasuredHeight();
        }
        return new int[]{n2, n3};
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap goCrop(Bitmap object) {
        void var1_3;
        float f2 = object.getWidth();
        float f3 = object.getHeight();
        if (f2 == 0.0f) return object;
        if (f3 == 0.0f) {
            return object;
        }
        int[] nArray = this.getSize();
        if (nArray[0] == 0) return object;
        if (nArray[1] == 0) {
            return object;
        }
        float f4 = (float)nArray[1] * f2 / (float)nArray[0];
        if (f4 == f3) {
            return object;
        }
        int[] nArray2 = new int[4];
        if (f4 < f3) {
            nArray2[1] = (int)((f3 - f4) / 2.0f);
            nArray2[3] = nArray2[1];
        } else {
            nArray2[0] = (int)((f2 - (float)nArray[0] * f3 / (float)nArray[1]) / 2.0f);
            nArray2[2] = nArray2[0];
        }
        try {
            Bitmap bitmap;
            Bitmap bitmap2 = bitmap = BitmapHelper.cropBitmap(object, nArray2[0], nArray2[1], nArray2[2], nArray2[3]);
            return var1_3;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return var1_3;
        }
    }

    private Bitmap goRound(Bitmap bitmap) {
        try {
            Object object = this.getSize();
            object = BitmapHelper.roundBitmap(bitmap, object[0], object[1], this.rect[0], this.rect[1], this.rect[2], this.rect[3]);
            return object;
        }
        catch (Throwable throwable) {
            MobLog.getInstance().w(throwable);
            return bitmap;
        }
    }

    private void init(Context context) {
        if (this.isInEditMode()) {
            this.setBackgroundColor(-16777216);
            return;
        }
        BitmapProcessor.prepare(context);
    }

    public void execute(String string2, int n2) {
        this.url = string2;
        this.defaultRes = n2;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.setImageResource(n2);
            return;
        }
        Bitmap bitmap = BitmapProcessor.getBitmapFromCache(string2);
        if (bitmap != null && !bitmap.isRecycled()) {
            this.setBitmap(bitmap);
            return;
        }
        if (n2 > 0) {
            this.setImageResource(n2);
        }
        BitmapProcessor.process(string2, this);
    }

    public void execute(String string2, Bitmap bitmap) {
        this.url = string2;
        this.defaultBm = bitmap;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            this.setImageBitmap(bitmap);
            return;
        }
        Bitmap bitmap2 = BitmapProcessor.getBitmapFromCache(string2);
        if (bitmap2 != null && !bitmap2.isRecycled()) {
            this.setBitmap(bitmap2);
            return;
        }
        if (bitmap != null && !bitmap.isRecycled()) {
            this.setImageBitmap(bitmap);
        }
        BitmapProcessor.process(string2, this);
    }

    public boolean handleMessage(Message object) {
        block5: {
            block4: {
                if (object.what != 1) break block4;
                Object object2 = ((Object[])object.obj)[0];
                object = ((Object[])object.obj)[1];
                if (object == null || object2 == null || !object2.equals(this.url)) break block5;
                this.setImageBitmap((Bitmap)object);
            }
            return false;
        }
        if (this.defaultBm != null && !this.defaultBm.isRecycled()) {
            this.setImageBitmap(this.defaultBm);
            return false;
        }
        this.setImageResource(this.defaultRes);
        return false;
    }

    @Override
    public void onImageGot(String string2, Bitmap bitmap) {
        Message message;
        Message message2 = message = null;
        if (string2 != null) {
            message2 = message;
            if (string2.trim().length() > 0) {
                message2 = message;
                if (string2.equals(this.url)) {
                    message2 = bitmap;
                }
            }
        }
        bitmap = message2;
        if (message2 != null) {
            message = message2;
            if (this.scaleToCrop) {
                message = this.goCrop((Bitmap)message2);
            }
            bitmap = message;
            if (this.rect != null) {
                bitmap = this.goRound((Bitmap)message);
            }
        }
        message2 = new Message();
        message2.what = 1;
        message2.obj = new Object[]{string2, bitmap};
        UIHandler.sendMessageDelayed(message2, rnd.nextInt(300), this);
    }

    public void setBitmap(Bitmap bitmap) {
        Bitmap bitmap2 = bitmap;
        if (this.scaleToCrop) {
            bitmap2 = this.goCrop(bitmap);
        }
        bitmap = bitmap2;
        if (this.rect != null) {
            bitmap = this.goRound(bitmap2);
        }
        this.setImageBitmap(bitmap);
    }

    public void setRound(float f2) {
        this.setRound(f2, f2, f2, f2);
    }

    public void setRound(float f2, float f3, float f4, float f5) {
        this.rect = new float[]{f2, f3, f4, f5};
    }

    public void setScaleToCropCenter(boolean bl) {
        this.scaleToCrop = bl;
    }
}

