/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.text.TextUtils;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.ResponseHandlerInterface;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;

class SimpleMultipartEntity
implements HttpEntity {
    private static final byte[] CR_LF = "\r\n".getBytes();
    private static final String LOG_TAG = "SimpleMultipartEntity";
    private static final char[] MULTIPART_CHARS;
    private static final String STR_CR_LF = "\r\n";
    private static final byte[] TRANSFER_ENCODING_BINARY;
    private final String boundary;
    private final byte[] boundaryEnd;
    private final byte[] boundaryLine;
    private long bytesWritten;
    private final List<FilePart> fileParts = new ArrayList<FilePart>();
    private boolean isRepeatable;
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();
    private final ResponseHandlerInterface progressHandler;
    private long totalSize;

    static {
        TRANSFER_ENCODING_BINARY = "Content-Transfer-Encoding: binary\r\n".getBytes();
        MULTIPART_CHARS = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    }

    public SimpleMultipartEntity(ResponseHandlerInterface responseHandlerInterface) {
        StringBuilder stringBuilder = new StringBuilder();
        Random random = new Random();
        for (int i2 = 0; i2 < 30; ++i2) {
            stringBuilder.append(MULTIPART_CHARS[random.nextInt(MULTIPART_CHARS.length)]);
        }
        this.boundary = stringBuilder.toString();
        this.boundaryLine = ("--" + this.boundary + STR_CR_LF).getBytes();
        this.boundaryEnd = ("--" + this.boundary + "--" + STR_CR_LF).getBytes();
        this.progressHandler = responseHandlerInterface;
    }

    private byte[] createContentDisposition(String string2) {
        return ("Content-Disposition: form-data; name=\"" + string2 + "\"" + STR_CR_LF).getBytes();
    }

    private byte[] createContentDisposition(String string2, String string3) {
        return ("Content-Disposition: form-data; name=\"" + string2 + "\"" + "; filename=\"" + string3 + "\"" + STR_CR_LF).getBytes();
    }

    private byte[] createContentType(String string2) {
        return ("Content-Type: " + this.normalizeContentType(string2) + STR_CR_LF).getBytes();
    }

    private String normalizeContentType(String string2) {
        String string3 = string2;
        if (string2 == null) {
            string3 = "application/octet-stream";
        }
        return string3;
    }

    private void updateProgress(long l2) {
        this.bytesWritten += l2;
        this.progressHandler.sendProgressMessage(this.bytesWritten, this.totalSize);
    }

    public void addPart(String string2, File file) {
        this.addPart(string2, file, null);
    }

    public void addPart(String string2, File file, String string3) {
        this.fileParts.add(new FilePart(string2, file, this.normalizeContentType(string3)));
    }

    public void addPart(String string2, File file, String string3, String string4) {
        this.fileParts.add(new FilePart(string2, file, this.normalizeContentType(string3), string4));
    }

    public void addPart(String string2, String string3) {
        this.addPartWithCharset(string2, string3, null);
    }

    public void addPart(String object, String string2, InputStream inputStream, String string3) throws IOException {
        int n2;
        this.out.write(this.boundaryLine);
        this.out.write(this.createContentDisposition((String)object, string2));
        this.out.write(this.createContentType(string3));
        this.out.write(TRANSFER_ENCODING_BINARY);
        this.out.write(CR_LF);
        object = new byte[4096];
        while ((n2 = inputStream.read((byte[])object)) != -1) {
            this.out.write((byte[])object, 0, n2);
        }
        this.out.write(CR_LF);
        this.out.flush();
    }

    public void addPart(String string2, String string3, String string4) {
        try {
            this.out.write(this.boundaryLine);
            this.out.write(this.createContentDisposition(string2));
            this.out.write(this.createContentType(string4));
            this.out.write(CR_LF);
            this.out.write(string3.getBytes());
            this.out.write(CR_LF);
            return;
        }
        catch (IOException iOException) {
            AsyncHttpClient.log.e(LOG_TAG, "addPart ByteArrayOutputStream exception", iOException);
            return;
        }
    }

    public void addPartWithCharset(String string2, String string3, String string4) {
        String string5 = string4;
        if (string4 == null) {
            string5 = "UTF-8";
        }
        this.addPart(string2, string3, "text/plain; charset=" + string5);
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("Streaming entity does not implement #consumeContent()");
        }
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw new UnsupportedOperationException("getContent() is not supported. Use writeTo() instead.");
    }

    public Header getContentEncoding() {
        return null;
    }

    public long getContentLength() {
        long l2 = this.out.size();
        Iterator<FilePart> iterator = this.fileParts.iterator();
        while (iterator.hasNext()) {
            long l3 = iterator.next().getTotalLength();
            if (l3 < 0L) {
                return -1L;
            }
            l2 += l3;
        }
        return l2 + (long)this.boundaryEnd.length;
    }

    public Header getContentType() {
        return new BasicHeader("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return this.isRepeatable;
    }

    public boolean isStreaming() {
        return false;
    }

    public void setIsRepeatable(boolean bl) {
        this.isRepeatable = bl;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        this.bytesWritten = 0L;
        this.totalSize = (int)this.getContentLength();
        this.out.writeTo(outputStream);
        this.updateProgress(this.out.size());
        Iterator<FilePart> iterator = this.fileParts.iterator();
        while (iterator.hasNext()) {
            iterator.next().writeTo(outputStream);
        }
        outputStream.write(this.boundaryEnd);
        this.updateProgress(this.boundaryEnd.length);
    }

    private class FilePart {
        public File file;
        public byte[] header;

        public FilePart(String string2, File file, String string3) {
            this.header = this.createHeader(string2, file.getName(), string3);
            this.file = file;
        }

        public FilePart(String string2, File file, String string3, String string4) {
            SimpleMultipartEntity.this = string4;
            if (TextUtils.isEmpty((CharSequence)string4)) {
                SimpleMultipartEntity.this = file.getName();
            }
            this.header = this.createHeader(string2, (String)SimpleMultipartEntity.this, string3);
            this.file = file;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private byte[] createHeader(String string2, String string3, String string4) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                byteArrayOutputStream.write(SimpleMultipartEntity.this.boundaryLine);
                byteArrayOutputStream.write(SimpleMultipartEntity.this.createContentDisposition(string2, string3));
                byteArrayOutputStream.write(SimpleMultipartEntity.this.createContentType(string4));
                byteArrayOutputStream.write(TRANSFER_ENCODING_BINARY);
                byteArrayOutputStream.write(CR_LF);
                return byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                AsyncHttpClient.log.e(SimpleMultipartEntity.LOG_TAG, "createHeader ByteArrayOutputStream exception", iOException);
                return byteArrayOutputStream.toByteArray();
            }
        }

        public long getTotalLength() {
            long l2 = this.file.length();
            long l3 = CR_LF.length;
            return (long)this.header.length + (l2 + l3);
        }

        public void writeTo(OutputStream outputStream) throws IOException {
            int n2;
            outputStream.write(this.header);
            SimpleMultipartEntity.this.updateProgress(this.header.length);
            FileInputStream fileInputStream = new FileInputStream(this.file);
            byte[] byArray = new byte[4096];
            while ((n2 = fileInputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n2);
                SimpleMultipartEntity.this.updateProgress(n2);
            }
            outputStream.write(CR_LF);
            SimpleMultipartEntity.this.updateProgress(CR_LF.length);
            outputStream.flush();
            AsyncHttpClient.silentCloseInputStream(fileInputStream);
        }
    }
}

