/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.SystemClock;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.HashSet;
import javax.net.ssl.SSLException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.HttpContext;

class RetryHandler
implements HttpRequestRetryHandler {
    private static final HashSet<Class<?>> exceptionBlacklist;
    private static final HashSet<Class<?>> exceptionWhitelist;
    private final int maxRetries;
    private final int retrySleepTimeMS;

    static {
        exceptionWhitelist = new HashSet();
        exceptionBlacklist = new HashSet();
        exceptionWhitelist.add(NoHttpResponseException.class);
        exceptionWhitelist.add(UnknownHostException.class);
        exceptionWhitelist.add(SocketException.class);
        exceptionBlacklist.add(InterruptedIOException.class);
        exceptionBlacklist.add(SSLException.class);
    }

    public RetryHandler(int n2, int n3) {
        this.maxRetries = n2;
        this.retrySleepTimeMS = n3;
    }

    static void addClassToBlacklist(Class<?> clazz) {
        exceptionBlacklist.add(clazz);
    }

    static void addClassToWhitelist(Class<?> clazz) {
        exceptionWhitelist.add(clazz);
    }

    protected boolean isInList(HashSet<Class<?>> object, Throwable throwable) {
        object = ((HashSet)object).iterator();
        while (object.hasNext()) {
            if (!((Class)object.next()).isInstance(throwable)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean retryRequest(IOException iOException, int n2, HttpContext httpContext) {
        boolean bl = true;
        Boolean bl2 = (Boolean)httpContext.getAttribute("http.request_sent");
        boolean bl3 = bl2 != null && bl2 != false;
        if (n2 > this.maxRetries) {
            bl = false;
        } else if (this.isInList(exceptionWhitelist, iOException)) {
            bl = true;
        } else if (this.isInList(exceptionBlacklist, iOException)) {
            bl = false;
        } else if (!bl3) {
            bl = true;
        }
        if (bl && (HttpUriRequest)httpContext.getAttribute("http.request") == null) {
            return false;
        }
        if (bl) {
            SystemClock.sleep((long)this.retrySleepTimeMS);
            return bl;
        }
        iOException.printStackTrace();
        return bl;
    }
}

