/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.JsonStreamerEntity;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.SimpleMultipartEntity;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.message.BasicNameValuePair;

public class RequestParams
implements Serializable {
    public static final String APPLICATION_JSON = "application/json";
    public static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    protected static final String LOG_TAG = "RequestParams";
    protected boolean autoCloseInputStreams;
    protected String contentEncoding = "UTF-8";
    protected String elapsedFieldInJsonStreamer = "_elapsed";
    protected final ConcurrentHashMap<String, List<FileWrapper>> fileArrayParams;
    protected final ConcurrentHashMap<String, FileWrapper> fileParams;
    protected boolean forceMultipartEntity = false;
    protected boolean isRepeatable;
    protected final ConcurrentHashMap<String, StreamWrapper> streamParams;
    protected final ConcurrentHashMap<String, String> urlParams = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, Object> urlParamsWithObjects;
    protected boolean useJsonStreamer;

    public RequestParams() {
        this(null);
    }

    public RequestParams(final String string2, final String string3) {
        this((Map<String, String>)new HashMap<String, String>(){
            {
                this.put(string2, string3);
            }
        });
    }

    public RequestParams(Map<String, String> object) {
        this.streamParams = new ConcurrentHashMap();
        this.fileParams = new ConcurrentHashMap();
        this.fileArrayParams = new ConcurrentHashMap();
        this.urlParamsWithObjects = new ConcurrentHashMap();
        if (object != null) {
            for (Map.Entry entry : object.entrySet()) {
                this.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    public RequestParams(Object ... objectArray) {
        this.streamParams = new ConcurrentHashMap();
        this.fileParams = new ConcurrentHashMap();
        this.fileArrayParams = new ConcurrentHashMap();
        this.urlParamsWithObjects = new ConcurrentHashMap();
        int n2 = objectArray.length;
        if (n2 % 2 != 0) {
            throw new IllegalArgumentException("Supplied arguments must be even");
        }
        for (int i2 = 0; i2 < n2; i2 += 2) {
            this.put(String.valueOf(objectArray[i2]), String.valueOf(objectArray[i2 + 1]));
        }
    }

    private HttpEntity createFormEntity() {
        try {
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(this.getParamsList(), this.contentEncoding);
            return urlEncodedFormEntity;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            AsyncHttpClient.log.e(LOG_TAG, "createFormEntity failed", unsupportedEncodingException);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private HttpEntity createJsonStreamerEntity(ResponseHandlerInterface object) throws IOException {
        boolean bl = !this.fileParams.isEmpty() || !this.streamParams.isEmpty();
        object = new JsonStreamerEntity((ResponseHandlerInterface)object, bl, this.elapsedFieldInJsonStreamer);
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            ((JsonStreamerEntity)object).addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.urlParamsWithObjects.entrySet()) {
            ((JsonStreamerEntity)object).addPart(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            ((JsonStreamerEntity)object).addPart(entry.getKey(), entry.getValue());
        }
        Iterator<Map.Entry<String, Object>> iterator = this.streamParams.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            StreamWrapper streamWrapper = (StreamWrapper)entry.getValue();
            if (streamWrapper.inputStream == null) continue;
            ((JsonStreamerEntity)object).addPart(entry.getKey(), StreamWrapper.newInstance(streamWrapper.inputStream, streamWrapper.name, streamWrapper.contentType, streamWrapper.autoClose));
        }
        return object;
    }

    private HttpEntity createMultipartEntity(ResponseHandlerInterface object) throws IOException {
        Iterator iterator;
        object = new SimpleMultipartEntity((ResponseHandlerInterface)object);
        ((SimpleMultipartEntity)object).setIsRepeatable(this.isRepeatable);
        for (Map.Entry<String, String> object2 : this.urlParams.entrySet()) {
            ((SimpleMultipartEntity)object).addPartWithCharset(object2.getKey(), object2.getValue(), this.contentEncoding);
        }
        for (BasicNameValuePair basicNameValuePair : this.getParamsList(null, this.urlParamsWithObjects)) {
            ((SimpleMultipartEntity)object).addPartWithCharset(basicNameValuePair.getName(), basicNameValuePair.getValue(), this.contentEncoding);
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            iterator = (StreamWrapper)entry.getValue();
            if (((StreamWrapper)((Object)iterator)).inputStream == null) continue;
            ((SimpleMultipartEntity)object).addPart(entry.getKey(), ((StreamWrapper)((Object)iterator)).name, ((StreamWrapper)((Object)iterator)).inputStream, ((StreamWrapper)((Object)iterator)).contentType);
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            iterator = (FileWrapper)entry.getValue();
            ((SimpleMultipartEntity)object).addPart(entry.getKey(), ((FileWrapper)((Object)iterator)).file, ((FileWrapper)((Object)iterator)).contentType, ((FileWrapper)((Object)iterator)).customFileName);
        }
        for (Map.Entry<String, Object> entry : this.fileArrayParams.entrySet()) {
            for (FileWrapper fileWrapper : (List)entry.getValue()) {
                ((SimpleMultipartEntity)object).addPart(entry.getKey(), fileWrapper.file, fileWrapper.contentType, fileWrapper.customFileName);
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private List<BasicNameValuePair> getParamsList(String string2, Object object) {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        if (!(object instanceof Map)) {
            if (object instanceof List) {
                List list = (List)object;
                int n2 = list.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    linkedList.addAll(this.getParamsList(String.format(Locale.US, "%s[%d]", string2, i2), list.get(i2)));
                }
                return linkedList;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n3 = objectArray.length;
                for (int i3 = 0; i3 < n3; ++i3) {
                    linkedList.addAll(this.getParamsList(String.format(Locale.US, "%s[%d]", string2, i3), objectArray[i3]));
                }
                return linkedList;
            }
            if (object instanceof Set) {
                Iterator iterator = ((Set)object).iterator();
                while (iterator.hasNext()) {
                    linkedList.addAll(this.getParamsList(string2, iterator.next()));
                }
                return linkedList;
            } else {
                linkedList.add(new BasicNameValuePair(string2, object.toString()));
            }
            return linkedList;
        }
        Map map = (Map)object;
        ArrayList arrayList = new ArrayList(map.keySet());
        if (arrayList.size() > 0 && arrayList.get(0) instanceof Comparable) {
            Collections.sort(arrayList);
        }
        for (Object e2 : arrayList) {
            void var2_7;
            Object v2;
            if (!(e2 instanceof String) || (v2 = map.get(e2)) == null) continue;
            if (string2 == null) {
                String string3 = (String)e2;
            } else {
                String string4 = String.format(Locale.US, "%s[%s]", string2, e2);
            }
            linkedList.addAll(this.getParamsList((String)var2_7, v2));
        }
        return linkedList;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(String string2, String string3) {
        HashSet hashSet;
        if (string2 == null || string3 == null) return;
        HashSet hashSet2 = hashSet = this.urlParamsWithObjects.get(string2);
        if (hashSet == null) {
            hashSet2 = new HashSet();
            this.put(string2, hashSet2);
        }
        if (hashSet2 instanceof List) {
            ((List)((Object)hashSet2)).add(string3);
            return;
        } else {
            if (!(hashSet2 instanceof Set)) return;
            ((Set)hashSet2).add(string3);
            return;
        }
    }

    public HttpEntity getEntity(ResponseHandlerInterface responseHandlerInterface) throws IOException {
        if (this.useJsonStreamer) {
            return this.createJsonStreamerEntity(responseHandlerInterface);
        }
        if (!this.forceMultipartEntity && this.streamParams.isEmpty() && this.fileParams.isEmpty() && this.fileArrayParams.isEmpty()) {
            return this.createFormEntity();
        }
        return this.createMultipartEntity(responseHandlerInterface);
    }

    protected String getParamString() {
        return URLEncodedUtils.format(this.getParamsList(), (String)this.contentEncoding);
    }

    protected List<BasicNameValuePair> getParamsList() {
        LinkedList<BasicNameValuePair> linkedList = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            linkedList.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        linkedList.addAll(this.getParamsList(null, this.urlParamsWithObjects));
        return linkedList;
    }

    public boolean has(String string2) {
        return this.urlParams.get(string2) != null || this.streamParams.get(string2) != null || this.fileParams.get(string2) != null || this.urlParamsWithObjects.get(string2) != null || this.fileArrayParams.get(string2) != null;
    }

    public void put(String string2, int n2) {
        if (string2 != null) {
            this.urlParams.put(string2, String.valueOf(n2));
        }
    }

    public void put(String string2, long l2) {
        if (string2 != null) {
            this.urlParams.put(string2, String.valueOf(l2));
        }
    }

    public void put(String string2, File file) throws FileNotFoundException {
        this.put(string2, file, null, null);
    }

    public void put(String string2, File file, String string3) throws FileNotFoundException {
        this.put(string2, file, string3, null);
    }

    public void put(String string2, File file, String string3, String string4) throws FileNotFoundException {
        if (file == null || !file.exists()) {
            throw new FileNotFoundException();
        }
        if (string2 != null) {
            this.fileParams.put(string2, new FileWrapper(file, string3, string4));
        }
    }

    public void put(String string2, InputStream inputStream) {
        this.put(string2, inputStream, null);
    }

    public void put(String string2, InputStream inputStream, String string3) {
        this.put(string2, inputStream, string3, null);
    }

    public void put(String string2, InputStream inputStream, String string3, String string4) {
        this.put(string2, inputStream, string3, string4, this.autoCloseInputStreams);
    }

    public void put(String string2, InputStream inputStream, String string3, String string4, boolean bl) {
        if (string2 != null && inputStream != null) {
            this.streamParams.put(string2, StreamWrapper.newInstance(inputStream, string3, string4, bl));
        }
    }

    public void put(String string2, Object object) {
        if (string2 != null && object != null) {
            this.urlParamsWithObjects.put(string2, object);
        }
    }

    public void put(String string2, String string3) {
        if (string2 != null && string3 != null) {
            this.urlParams.put(string2, string3);
        }
    }

    public void put(String string2, String string3, File file) throws FileNotFoundException {
        this.put(string2, file, null, string3);
    }

    public void put(String string2, File[] fileArray) throws FileNotFoundException {
        this.put(string2, fileArray, null, null);
    }

    public void put(String string2, File[] fileArray, String string3, String string4) throws FileNotFoundException {
        if (string2 != null) {
            ArrayList<FileWrapper> arrayList = new ArrayList<FileWrapper>();
            for (File file : fileArray) {
                if (file == null || !file.exists()) {
                    throw new FileNotFoundException();
                }
                arrayList.add(new FileWrapper(file, string3, string4));
            }
            this.fileArrayParams.put(string2, arrayList);
        }
    }

    public void remove(String string2) {
        this.urlParams.remove(string2);
        this.streamParams.remove(string2);
        this.fileParams.remove(string2);
        this.urlParamsWithObjects.remove(string2);
        this.fileArrayParams.remove(string2);
    }

    public void setAutoCloseInputStreams(boolean bl) {
        this.autoCloseInputStreams = bl;
    }

    public void setContentEncoding(String string2) {
        if (string2 != null) {
            this.contentEncoding = string2;
            return;
        }
        AsyncHttpClient.log.d(LOG_TAG, "setContentEncoding called with null attribute");
    }

    public void setElapsedFieldInJsonStreamer(String string2) {
        this.elapsedFieldInJsonStreamer = string2;
    }

    public void setForceMultipartEntityContentType(boolean bl) {
        this.forceMultipartEntity = bl;
    }

    public void setHttpEntityIsRepeatable(boolean bl) {
        this.isRepeatable = bl;
    }

    public void setUseJsonStreamer(boolean bl) {
        this.useJsonStreamer = bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.urlParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.streamParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append("STREAM");
        }
        for (Map.Entry<String, Object> entry : this.fileParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append("FILE");
        }
        for (Map.Entry<String, Object> entry : this.fileArrayParams.entrySet()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(entry.getKey());
            stringBuilder.append("=");
            stringBuilder.append("FILES(SIZE=").append(((List)entry.getValue()).size()).append(")");
        }
        for (BasicNameValuePair basicNameValuePair : this.getParamsList(null, this.urlParamsWithObjects)) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(basicNameValuePair.getName());
            stringBuilder.append("=");
            stringBuilder.append(basicNameValuePair.getValue());
        }
        return stringBuilder.toString();
    }

    public static class FileWrapper
    implements Serializable {
        public final String contentType;
        public final String customFileName;
        public final File file;

        public FileWrapper(File file, String string2, String string3) {
            this.file = file;
            this.contentType = string2;
            this.customFileName = string3;
        }
    }

    public static class StreamWrapper {
        public final boolean autoClose;
        public final String contentType;
        public final InputStream inputStream;
        public final String name;

        public StreamWrapper(InputStream inputStream, String string2, String string3, boolean bl) {
            this.inputStream = inputStream;
            this.name = string2;
            this.contentType = string3;
            this.autoClose = bl;
        }

        static StreamWrapper newInstance(InputStream inputStream, String string2, String string3, boolean bl) {
            String string4 = string3;
            if (string3 == null) {
                string4 = RequestParams.APPLICATION_OCTET_STREAM;
            }
            return new StreamWrapper(inputStream, string2, string4, bl);
        }
    }
}

