/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Looper;
import com.loopj.android.http.AsyncHttpRequest;
import java.lang.ref.WeakReference;

public class RequestHandle {
    private final WeakReference<AsyncHttpRequest> request;

    public RequestHandle(AsyncHttpRequest asyncHttpRequest) {
        this.request = new WeakReference<AsyncHttpRequest>(asyncHttpRequest);
    }

    public boolean cancel(final boolean bl) {
        final AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        if (asyncHttpRequest != null) {
            if (Looper.myLooper() == Looper.getMainLooper()) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        asyncHttpRequest.cancel(bl);
                    }
                }).start();
                return true;
            }
            return asyncHttpRequest.cancel(bl);
        }
        return false;
    }

    public Object getTag() {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        if (asyncHttpRequest == null) {
            return null;
        }
        return asyncHttpRequest.getTag();
    }

    public boolean isCancelled() {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        return asyncHttpRequest == null || asyncHttpRequest.isCancelled();
    }

    public boolean isFinished() {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        return asyncHttpRequest == null || asyncHttpRequest.isDone();
    }

    public RequestHandle setTag(Object object) {
        AsyncHttpRequest asyncHttpRequest = (AsyncHttpRequest)this.request.get();
        if (asyncHttpRequest != null) {
            asyncHttpRequest.setRequestTag(object);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldBeGarbageCollected() {
        if (!this.isCancelled()) {
            if (!this.isFinished()) return false;
        }
        boolean bl = true;
        if (!bl) return bl;
        this.request.clear();
        return bl;
    }
}

