/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.FileAsyncHttpResponseHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.HttpUriRequest;

public abstract class RangeFileAsyncHttpResponseHandler
extends FileAsyncHttpResponseHandler {
    private static final String LOG_TAG = "RangeFileAsyncHttpRH";
    private boolean append = false;
    private long current = 0L;

    public RangeFileAsyncHttpResponseHandler(File file) {
        super(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected byte[] getResponseData(HttpEntity object) throws IOException {
        if (object == null) return null;
        InputStream inputStream = object.getContent();
        long l2 = object.getContentLength() + this.current;
        object = new FileOutputStream(this.getTargetFile(), this.append);
        if (inputStream == null) return null;
        try {
            int n2;
            byte[] byArray = new byte[4096];
            while (this.current < l2 && (n2 = inputStream.read(byArray)) != -1 && !Thread.currentThread().isInterrupted()) {
                this.current += (long)n2;
                ((FileOutputStream)object).write(byArray, 0, n2);
                this.sendProgressMessage(this.current, l2);
            }
            return null;
        }
        finally {
            inputStream.close();
            ((OutputStream)object).flush();
            ((FileOutputStream)object).close();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void sendResponseMessage(HttpResponse httpResponse) throws IOException {
        if (Thread.currentThread().isInterrupted()) return;
        StatusLine statusLine = httpResponse.getStatusLine();
        if (statusLine.getStatusCode() == 416) {
            if (Thread.currentThread().isInterrupted()) return;
            this.sendSuccessMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null);
            return;
        }
        if (statusLine.getStatusCode() >= 300) {
            if (Thread.currentThread().isInterrupted()) return;
            this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null, (Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()));
            return;
        }
        if (Thread.currentThread().isInterrupted()) return;
        Header header = httpResponse.getFirstHeader("Content-Range");
        if (header == null) {
            this.append = false;
            this.current = 0L;
        } else {
            AsyncHttpClient.log.v(LOG_TAG, "Content-Range: " + header.getValue());
        }
        this.sendSuccessMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), this.getResponseData(httpResponse.getEntity()));
    }

    public void updateRequestHeaders(HttpUriRequest httpUriRequest) {
        if (this.file.exists() && this.file.canWrite()) {
            this.current = this.file.length();
        }
        if (this.current > 0L) {
            this.append = true;
            httpUriRequest.setHeader("Range", "bytes=" + this.current + "-");
        }
    }
}

