/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.SerializableCookie;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.client.CookieStore;
import org.apache.http.cookie.Cookie;

public class PersistentCookieStore
implements CookieStore {
    private static final String COOKIE_NAME_PREFIX = "cookie_";
    private static final String COOKIE_NAME_STORE = "names";
    private static final String COOKIE_PREFS = "CookiePrefsFile";
    private static final String LOG_TAG = "PersistentCookieStore";
    private final SharedPreferences cookiePrefs;
    private final ConcurrentHashMap<String, Cookie> cookies;
    private boolean omitNonPersistentCookies = false;

    public PersistentCookieStore(Context stringArray) {
        this.cookiePrefs = stringArray.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new ConcurrentHashMap();
        stringArray = this.cookiePrefs.getString(COOKIE_NAME_STORE, null);
        if (stringArray != null) {
            for (String string2 : TextUtils.split((String)stringArray, (String)",")) {
                String string3 = this.cookiePrefs.getString(COOKIE_NAME_PREFIX + string2, null);
                if (string3 == null || (string3 = this.decodeCookie(string3)) == null) continue;
                this.cookies.put(string2, (Cookie)string3);
            }
            this.clearExpired(new Date());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void addCookie(Cookie cookie) {
        if (this.omitNonPersistentCookies && !cookie.isPersistent()) {
            return;
        }
        String string2 = cookie.getName() + cookie.getDomain();
        if (!cookie.isExpired(new Date())) {
            this.cookies.put(string2, cookie);
        } else {
            this.cookies.remove(string2);
        }
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        editor.putString(COOKIE_NAME_PREFIX + string2, this.encodeCookie(new SerializableCookie(cookie)));
        editor.commit();
    }

    protected String byteArrayToHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        int n2 = byArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = byArray[i2] & 0xFF;
            if (n3 < 16) {
                stringBuilder.append('0');
            }
            stringBuilder.append(Integer.toHexString(n3));
        }
        return stringBuilder.toString().toUpperCase(Locale.US);
    }

    public void clear() {
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (String string2 : this.cookies.keySet()) {
            editor.remove(COOKIE_NAME_PREFIX + string2);
        }
        editor.remove(COOKIE_NAME_STORE);
        editor.commit();
        this.cookies.clear();
    }

    public boolean clearExpired(Date date) {
        boolean bl = false;
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        for (Map.Entry<String, Cookie> entry : this.cookies.entrySet()) {
            String string2 = entry.getKey();
            if (!entry.getValue().isExpired(date)) continue;
            this.cookies.remove(string2);
            editor.remove(COOKIE_NAME_PREFIX + string2);
            bl = true;
        }
        if (bl) {
            editor.putString(COOKIE_NAME_STORE, TextUtils.join((CharSequence)",", (Iterable)this.cookies.keySet()));
        }
        editor.commit();
        return bl;
    }

    protected Cookie decodeCookie(String object) {
        object = new ByteArrayInputStream(this.hexStringToByteArray((String)object));
        try {
            object = ((SerializableCookie)new ObjectInputStream((InputStream)object).readObject()).getCookie();
            return object;
        }
        catch (IOException iOException) {
            AsyncHttpClient.log.d(LOG_TAG, "IOException in decodeCookie", iOException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            AsyncHttpClient.log.d(LOG_TAG, "ClassNotFoundException in decodeCookie", classNotFoundException);
            return null;
        }
    }

    public void deleteCookie(Cookie object) {
        object = object.getName() + object.getDomain();
        this.cookies.remove(object);
        SharedPreferences.Editor editor = this.cookiePrefs.edit();
        editor.remove(COOKIE_NAME_PREFIX + (String)object);
        editor.commit();
    }

    protected String encodeCookie(SerializableCookie serializableCookie) {
        if (serializableCookie == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            new ObjectOutputStream(byteArrayOutputStream).writeObject(serializableCookie);
            return this.byteArrayToHexString(byteArrayOutputStream.toByteArray());
        }
        catch (IOException iOException) {
            AsyncHttpClient.log.d(LOG_TAG, "IOException in encodeCookie", iOException);
            return null;
        }
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>(this.cookies.values());
    }

    protected byte[] hexStringToByteArray(String string2) {
        int n2 = string2.length();
        byte[] byArray = new byte[n2 / 2];
        for (int i2 = 0; i2 < n2; i2 += 2) {
            byArray[i2 / 2] = (byte)((Character.digit(string2.charAt(i2), 16) << 4) + Character.digit(string2.charAt(i2 + 1), 16));
        }
        return byArray;
    }

    public void setOmitNonPersistentCookies(boolean bl) {
        this.omitNonPersistentCookies = bl;
    }
}

