/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.protocol.HttpContext;

class MyRedirectHandler
extends DefaultRedirectHandler {
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";
    private final boolean enableRedirects;

    public MyRedirectHandler(boolean bl) {
        this.enableRedirects = bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI getLocationURI(HttpResponse object, HttpContext object2) throws ProtocolException {
        void var1_6;
        block13: {
            void var2_11;
            Object object3;
            block14: {
                void var2_9;
                String string2;
                block12: {
                    if (object == null) {
                        throw new IllegalArgumentException("HTTP response may not be null");
                    }
                    object3 = object.getFirstHeader("location");
                    if (object3 == null) {
                        throw new ProtocolException("Received redirect response " + object.getStatusLine() + " but no location header");
                    }
                    string2 = object3.getValue().replaceAll(" ", "%20");
                    try {
                        object3 = new URI(string2);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ProtocolException("Invalid redirect URI: " + string2, (Throwable)uRISyntaxException);
                    }
                    string2 = object.getParams();
                    Object object4 = object3;
                    if (((URI)object3).isAbsolute()) break block12;
                    if (string2.isParameterTrue("http.protocol.reject-relative-redirect")) {
                        throw new ProtocolException("Relative redirect location '" + object3 + "' not allowed");
                    }
                    HttpHost httpHost = (HttpHost)var2_9.getAttribute("http.target_host");
                    if (httpHost == null) {
                        throw new IllegalStateException("Target host not available in the HTTP context");
                    }
                    HttpRequest httpRequest = (HttpRequest)var2_9.getAttribute("http.request");
                    try {
                        URI uRI = URIUtils.resolve((URI)URIUtils.rewriteURI((URI)new URI(httpRequest.getRequestLine().getUri()), (HttpHost)httpHost, (boolean)true), (URI)object3);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                    }
                }
                if (!string2.isParameterFalse("http.protocol.allow-circular-redirects")) break block13;
                string2 = (RedirectLocations)var2_9.getAttribute(REDIRECT_LOCATIONS);
                object3 = string2;
                if (string2 == null) {
                    object3 = new RedirectLocations();
                    var2_9.setAttribute(REDIRECT_LOCATIONS, object3);
                }
                if (var1_6.getFragment() == null) break block14;
                try {
                    URI uRI = URIUtils.rewriteURI((URI)var1_6, (HttpHost)new HttpHost(var1_6.getHost(), var1_6.getPort(), var1_6.getScheme()), (boolean)true);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new ProtocolException(uRISyntaxException.getMessage(), (Throwable)uRISyntaxException);
                }
            }
            void var2_12 = var1_6;
            if (object3.contains((URI)var2_11)) {
                throw new CircularRedirectException("Circular redirect to '" + var2_11 + "'");
            }
            object3.add((URI)var2_11);
        }
        return var1_6;
    }

    public boolean isRedirectRequested(HttpResponse httpResponse, HttpContext httpContext) {
        if (!this.enableRedirects) {
            return false;
        }
        if (httpResponse == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        switch (httpResponse.getStatusLine().getStatusCode()) {
            default: {
                return false;
            }
            case 301: 
            case 302: 
            case 303: 
            case 307: 
        }
        return true;
    }
}

