/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.annotation.TargetApi;
import android.os.Build;
import android.util.Log;
import com.loopj.android.http.LogInterface;

public class LogHandler
implements LogInterface {
    boolean mLoggingEnabled = true;
    int mLoggingLevel = 2;

    @TargetApi(value=8)
    private void checkedWtf(String string2, String string3, Throwable throwable) {
        Log.wtf((String)string2, (String)string3, (Throwable)throwable);
    }

    @Override
    public void d(String string2, String string3) {
        this.log(2, string2, string3);
    }

    @Override
    public void d(String string2, String string3, Throwable throwable) {
        this.logWithThrowable(3, string2, string3, throwable);
    }

    @Override
    public void e(String string2, String string3) {
        this.log(6, string2, string3);
    }

    @Override
    public void e(String string2, String string3, Throwable throwable) {
        this.logWithThrowable(6, string2, string3, throwable);
    }

    @Override
    public int getLoggingLevel() {
        return this.mLoggingLevel;
    }

    @Override
    public void i(String string2, String string3) {
        this.log(4, string2, string3);
    }

    @Override
    public void i(String string2, String string3, Throwable throwable) {
        this.logWithThrowable(4, string2, string3, throwable);
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.mLoggingEnabled;
    }

    public void log(int n2, String string2, String string3) {
        this.logWithThrowable(n2, string2, string3, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logWithThrowable(int n2, String string2, String string3, Throwable throwable) {
        if (!this.isLoggingEnabled() || !this.shouldLog(n2)) return;
        switch (n2) {
            default: {
                return;
            }
            case 2: {
                Log.v((String)string2, (String)string3, (Throwable)throwable);
                return;
            }
            case 5: {
                Log.w((String)string2, (String)string3, (Throwable)throwable);
                return;
            }
            case 6: {
                Log.e((String)string2, (String)string3, (Throwable)throwable);
                return;
            }
            case 3: {
                Log.d((String)string2, (String)string3, (Throwable)throwable);
                return;
            }
            case 8: {
                if (Integer.valueOf(Build.VERSION.SDK) > 8) {
                    this.checkedWtf(string2, string3, throwable);
                    return;
                }
                Log.e((String)string2, (String)string3, (Throwable)throwable);
                return;
            }
            case 4: 
        }
        Log.i((String)string2, (String)string3, (Throwable)throwable);
    }

    @Override
    public void setLoggingEnabled(boolean bl) {
        this.mLoggingEnabled = bl;
    }

    @Override
    public void setLoggingLevel(int n2) {
        this.mLoggingLevel = n2;
    }

    @Override
    public boolean shouldLog(int n2) {
        return n2 >= this.mLoggingLevel;
    }

    @Override
    public void v(String string2, String string3) {
        this.log(2, string2, string3);
    }

    @Override
    public void v(String string2, String string3, Throwable throwable) {
        this.logWithThrowable(2, string2, string3, throwable);
    }

    @Override
    public void w(String string2, String string3) {
        this.log(5, string2, string3);
    }

    @Override
    public void w(String string2, String string3, Throwable throwable) {
        this.logWithThrowable(5, string2, string3, throwable);
    }

    @Override
    public void wtf(String string2, String string3) {
        this.log(8, string2, string3);
    }

    @Override
    public void wtf(String string2, String string3, Throwable throwable) {
        this.logWithThrowable(8, string2, string3, throwable);
    }
}

