/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.text.TextUtils;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.Base64OutputStream;
import com.loopj.android.http.JsonValueInterface;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.message.BasicHeader;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStreamerEntity
implements HttpEntity {
    private static final int BUFFER_SIZE = 4096;
    private static final UnsupportedOperationException ERR_UNSUPPORTED = new UnsupportedOperationException("Unsupported operation in this implementation.");
    private static final Header HEADER_GZIP_ENCODING;
    private static final Header HEADER_JSON_CONTENT;
    private static final byte[] JSON_FALSE;
    private static final byte[] JSON_NULL;
    private static final byte[] JSON_TRUE;
    private static final String LOG_TAG = "JsonStreamerEntity";
    private static final byte[] STREAM_CONTENTS;
    private static final byte[] STREAM_NAME;
    private static final byte[] STREAM_TYPE;
    private final byte[] buffer;
    private final Header contentEncoding;
    private final byte[] elapsedField;
    private final Map<String, Object> jsonParams;
    private final ResponseHandlerInterface progressHandler;

    static {
        JSON_TRUE = "true".getBytes();
        JSON_FALSE = "false".getBytes();
        JSON_NULL = "null".getBytes();
        STREAM_NAME = JsonStreamerEntity.escape("name");
        STREAM_TYPE = JsonStreamerEntity.escape("type");
        STREAM_CONTENTS = JsonStreamerEntity.escape("contents");
        HEADER_JSON_CONTENT = new BasicHeader("Content-Type", "application/json");
        HEADER_GZIP_ENCODING = new BasicHeader("Content-Encoding", "gzip");
    }

    /*
     * Enabled aggressive block sorting
     */
    public JsonStreamerEntity(ResponseHandlerInterface object, boolean bl, String string2) {
        Object var4_4 = null;
        this.buffer = new byte[4096];
        this.jsonParams = new HashMap<String, Object>();
        this.progressHandler = object;
        object = bl ? HEADER_GZIP_ENCODING : null;
        this.contentEncoding = object;
        object = TextUtils.isEmpty((CharSequence)string2) ? var4_4 : (Object)JsonStreamerEntity.escape(string2);
        this.elapsedField = (byte[])object;
    }

    private void endMetaData(OutputStream outputStream) throws IOException {
        outputStream.write(34);
    }

    static byte[] escape(String string2) {
        int n2;
        if (string2 == null) {
            return JSON_NULL;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('\"');
        int n3 = string2.length();
        int n4 = -1;
        block9: while ((n2 = n4 + 1) < n3) {
            char c2;
            block13: {
                String string3;
                c2 = string2.charAt(n2);
                switch (c2) {
                    default: {
                        if (c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\u009f' || c2 >= '\u2000' && c2 <= '\u20ff') {
                            string3 = Integer.toHexString(c2);
                            stringBuilder.append("\\u");
                            int n5 = string3.length();
                            for (n4 = 0; n4 < 4 - n5; ++n4) {
                                stringBuilder.append('0');
                            }
                            break;
                        }
                        break block13;
                    }
                    case '\"': {
                        stringBuilder.append("\\\"");
                        n4 = n2;
                        continue block9;
                    }
                    case '\\': {
                        stringBuilder.append("\\\\");
                        n4 = n2;
                        continue block9;
                    }
                    case '\b': {
                        stringBuilder.append("\\b");
                        n4 = n2;
                        continue block9;
                    }
                    case '\f': {
                        stringBuilder.append("\\f");
                        n4 = n2;
                        continue block9;
                    }
                    case '\n': {
                        stringBuilder.append("\\n");
                        n4 = n2;
                        continue block9;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        n4 = n2;
                        continue block9;
                    }
                    case '\t': {
                        stringBuilder.append("\\t");
                        n4 = n2;
                        continue block9;
                    }
                }
                stringBuilder.append(string3.toUpperCase(Locale.US));
                n4 = n2;
                continue;
            }
            stringBuilder.append(c2);
            n4 = n2;
        }
        stringBuilder.append('\"');
        return stringBuilder.toString().getBytes();
    }

    private void writeMetaData(OutputStream outputStream, String string2, String string3) throws IOException {
        outputStream.write(STREAM_NAME);
        outputStream.write(58);
        outputStream.write(JsonStreamerEntity.escape(string2));
        outputStream.write(44);
        outputStream.write(STREAM_TYPE);
        outputStream.write(58);
        outputStream.write(JsonStreamerEntity.escape(string3));
        outputStream.write(44);
        outputStream.write(STREAM_CONTENTS);
        outputStream.write(58);
        outputStream.write(34);
    }

    private void writeToFromFile(OutputStream outputStream, RequestParams.FileWrapper object) throws IOException {
        int n2;
        this.writeMetaData(outputStream, ((RequestParams.FileWrapper)object).file.getName(), ((RequestParams.FileWrapper)object).contentType);
        long l2 = 0L;
        long l3 = ((RequestParams.FileWrapper)object).file.length();
        object = new FileInputStream(((RequestParams.FileWrapper)object).file);
        Base64OutputStream base64OutputStream = new Base64OutputStream(outputStream, 18);
        while ((n2 = ((FileInputStream)object).read(this.buffer)) != -1) {
            base64OutputStream.write(this.buffer, 0, n2);
            this.progressHandler.sendProgressMessage(l2 += (long)n2, l3);
        }
        AsyncHttpClient.silentCloseOutputStream(base64OutputStream);
        this.endMetaData(outputStream);
        AsyncHttpClient.silentCloseInputStream((InputStream)object);
    }

    private void writeToFromStream(OutputStream outputStream, RequestParams.StreamWrapper streamWrapper) throws IOException {
        int n2;
        this.writeMetaData(outputStream, streamWrapper.name, streamWrapper.contentType);
        Base64OutputStream base64OutputStream = new Base64OutputStream(outputStream, 18);
        while ((n2 = streamWrapper.inputStream.read(this.buffer)) != -1) {
            base64OutputStream.write(this.buffer, 0, n2);
        }
        AsyncHttpClient.silentCloseOutputStream(base64OutputStream);
        this.endMetaData(outputStream);
        if (streamWrapper.autoClose) {
            AsyncHttpClient.silentCloseInputStream(streamWrapper.inputStream);
        }
    }

    public void addPart(String string2, Object object) {
        this.jsonParams.put(string2, object);
    }

    public void consumeContent() throws IOException, UnsupportedOperationException {
    }

    public InputStream getContent() throws IOException, UnsupportedOperationException {
        throw ERR_UNSUPPORTED;
    }

    public Header getContentEncoding() {
        return this.contentEncoding;
    }

    public long getContentLength() {
        return -1L;
    }

    public Header getContentType() {
        return HEADER_JSON_CONTENT;
    }

    public boolean isChunked() {
        return false;
    }

    public boolean isRepeatable() {
        return false;
    }

    public boolean isStreaming() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(OutputStream outputStream) throws IOException {
        if (outputStream == null) {
            throw new IllegalStateException("Output stream cannot be null.");
        }
        long l2 = System.currentTimeMillis();
        if (this.contentEncoding != null) {
            outputStream = new GZIPOutputStream(outputStream, 4096);
        }
        outputStream.write(123);
        Object object = this.jsonParams.keySet();
        int n2 = object.size();
        if (n2 > 0) {
            int n3 = 0;
            Iterator<String> iterator = object.iterator();
            while (iterator.hasNext()) {
                int n4;
                block30: {
                    Object object2;
                    block31: {
                        object = iterator.next();
                        n4 = n3 + 1;
                        try {
                            object2 = this.jsonParams.get(object);
                            outputStream.write(JsonStreamerEntity.escape((String)object));
                            outputStream.write(58);
                            if (object2 == null) {
                                outputStream.write(JSON_NULL);
                                break block30;
                            }
                            boolean bl = object2 instanceof RequestParams.FileWrapper;
                            if (!bl && !(object2 instanceof RequestParams.StreamWrapper)) break block31;
                            outputStream.write(123);
                            if (bl) {
                                this.writeToFromFile(outputStream, (RequestParams.FileWrapper)object2);
                            } else {
                                this.writeToFromStream(outputStream, (RequestParams.StreamWrapper)object2);
                            }
                            outputStream.write(125);
                            break block30;
                        }
                        catch (Throwable throwable) {
                            if (this.elapsedField != null || n4 < n2) {
                                outputStream.write(44);
                            }
                            throw throwable;
                        }
                    }
                    if (object2 instanceof JsonValueInterface) {
                        outputStream.write(((JsonValueInterface)object2).getEscapedJsonValue());
                    } else if (object2 instanceof JSONObject) {
                        outputStream.write(object2.toString().getBytes());
                    } else if (object2 instanceof JSONArray) {
                        outputStream.write(object2.toString().getBytes());
                    } else if (object2 instanceof Boolean) {
                        object = (Boolean)object2 != false ? (Object)JSON_TRUE : (Object)JSON_FALSE;
                        outputStream.write((byte[])object);
                    } else if (object2 instanceof Long) {
                        outputStream.write((((Number)object2).longValue() + "").getBytes());
                    } else if (object2 instanceof Double) {
                        outputStream.write((((Number)object2).doubleValue() + "").getBytes());
                    } else if (object2 instanceof Float) {
                        outputStream.write((((Number)object2).floatValue() + "").getBytes());
                    } else if (object2 instanceof Integer) {
                        outputStream.write((((Number)object2).intValue() + "").getBytes());
                    } else {
                        outputStream.write(JsonStreamerEntity.escape(object2.toString()));
                    }
                }
                if (this.elapsedField == null) {
                    n3 = n4;
                    if (n4 >= n2) continue;
                }
                outputStream.write(44);
                n3 = n4;
            }
            l2 = System.currentTimeMillis() - l2;
            if (this.elapsedField != null) {
                outputStream.write(this.elapsedField);
                outputStream.write(58);
                outputStream.write((l2 + "").getBytes());
            }
            AsyncHttpClient.log.i(LOG_TAG, "Uploaded JSON in " + Math.floor(l2 / 1000L) + " seconds");
        }
        outputStream.write(125);
        outputStream.flush();
        AsyncHttpClient.silentCloseOutputStream(outputStream);
    }
}

