/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.TextHttpResponseHandler;
import org.apache.http.Header;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class JsonHttpResponseHandler
extends TextHttpResponseHandler {
    private static final String LOG_TAG = "JsonHttpRH";
    private boolean useRFC5179CompatibilityMode = true;

    public JsonHttpResponseHandler() {
        super("UTF-8");
    }

    public JsonHttpResponseHandler(String string2) {
        super(string2);
    }

    public JsonHttpResponseHandler(String string2, boolean bl) {
        super(string2);
        this.useRFC5179CompatibilityMode = bl;
    }

    public JsonHttpResponseHandler(boolean bl) {
        super("UTF-8");
        this.useRFC5179CompatibilityMode = bl;
    }

    public boolean isUseRFC5179CompatibilityMode() {
        return this.useRFC5179CompatibilityMode;
    }

    @Override
    public void onFailure(int n2, Header[] headerArray, String string2, Throwable throwable) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], String, Throwable) was not overriden, but callback was received", throwable);
    }

    public void onFailure(int n2, Header[] headerArray, Throwable throwable, JSONArray jSONArray) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], Throwable, JSONArray) was not overriden, but callback was received", throwable);
    }

    public void onFailure(int n2, Header[] headerArray, Throwable throwable, JSONObject jSONObject) {
        AsyncHttpClient.log.w(LOG_TAG, "onFailure(int, Header[], Throwable, JSONObject) was not overriden, but callback was received", throwable);
    }

    @Override
    public final void onFailure(final int n2, Header[] object, final byte[] byArray, Throwable throwable) {
        if (byArray != null) {
            object = new Runnable((Header[])object, throwable){
                final /* synthetic */ Header[] val$headers;
                final /* synthetic */ Throwable val$throwable;
                {
                    this.val$headers = headerArray;
                    this.val$throwable = throwable;
                }

                @Override
                public void run() {
                    try {
                        final Object object = JsonHttpResponseHandler.this.parseResponse(byArray);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (!JsonHttpResponseHandler.this.useRFC5179CompatibilityMode && object == null) {
                                    JsonHttpResponseHandler.this.onFailure(n2, val$headers, (String)null, val$throwable);
                                    return;
                                }
                                if (object instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onFailure(n2, val$headers, val$throwable, (JSONObject)object);
                                    return;
                                }
                                if (object instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onFailure(n2, val$headers, val$throwable, (JSONArray)object);
                                    return;
                                }
                                if (object instanceof String) {
                                    JsonHttpResponseHandler.this.onFailure(n2, val$headers, (String)object, val$throwable);
                                    return;
                                }
                                JsonHttpResponseHandler.this.onFailure(n2, val$headers, (Throwable)new JSONException("Unexpected response type " + object.getClass().getName()), (JSONObject)null);
                            }
                        });
                        return;
                    }
                    catch (JSONException jSONException) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                JsonHttpResponseHandler.this.onFailure(n2, val$headers, (Throwable)jSONException, (JSONObject)null);
                            }
                        });
                        return;
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread((Runnable)object).start();
                return;
            }
            object.run();
            return;
        }
        AsyncHttpClient.log.v(LOG_TAG, "response body is null, calling onFailure(Throwable, JSONObject)");
        this.onFailure(n2, (Header[])object, throwable, (JSONObject)null);
    }

    @Override
    public void onSuccess(int n2, Header[] headerArray, String string2) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], String) was not overriden, but callback was received");
    }

    public void onSuccess(int n2, Header[] headerArray, JSONArray jSONArray) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], JSONArray) was not overriden, but callback was received");
    }

    public void onSuccess(int n2, Header[] headerArray, JSONObject jSONObject) {
        AsyncHttpClient.log.w(LOG_TAG, "onSuccess(int, Header[], JSONObject) was not overriden, but callback was received");
    }

    @Override
    public final void onSuccess(final int n2, Header[] object, final byte[] byArray) {
        if (n2 != 204) {
            object = new Runnable((Header[])object){
                final /* synthetic */ Header[] val$headers;
                {
                    this.val$headers = headerArray;
                }

                @Override
                public void run() {
                    try {
                        final Object object = JsonHttpResponseHandler.this.parseResponse(byArray);
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                if (!JsonHttpResponseHandler.this.useRFC5179CompatibilityMode && object == null) {
                                    JsonHttpResponseHandler.this.onSuccess(n2, val$headers, (String)null);
                                    return;
                                }
                                if (object instanceof JSONObject) {
                                    JsonHttpResponseHandler.this.onSuccess(n2, val$headers, (JSONObject)object);
                                    return;
                                }
                                if (object instanceof JSONArray) {
                                    JsonHttpResponseHandler.this.onSuccess(n2, val$headers, (JSONArray)object);
                                    return;
                                }
                                if (object instanceof String) {
                                    if (JsonHttpResponseHandler.this.useRFC5179CompatibilityMode) {
                                        JsonHttpResponseHandler.this.onFailure(n2, val$headers, (String)object, (Throwable)new JSONException("Response cannot be parsed as JSON data"));
                                        return;
                                    }
                                    JsonHttpResponseHandler.this.onSuccess(n2, val$headers, (String)object);
                                    return;
                                }
                                JsonHttpResponseHandler.this.onFailure(n2, val$headers, (Throwable)new JSONException("Unexpected response type " + object.getClass().getName()), (JSONObject)null);
                            }
                        });
                        return;
                    }
                    catch (JSONException jSONException) {
                        JsonHttpResponseHandler.this.postRunnable(new Runnable(){

                            @Override
                            public void run() {
                                JsonHttpResponseHandler.this.onFailure(n2, val$headers, (Throwable)jSONException, (JSONObject)null);
                            }
                        });
                        return;
                    }
                }
            };
            if (!this.getUseSynchronousMode() && !this.getUsePoolThread()) {
                new Thread((Runnable)object).start();
                return;
            }
            object.run();
            return;
        }
        this.onSuccess(n2, (Header[])object, new JSONObject());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    protected Object parseResponse(byte[] object) throws JSONException {
        void var1_6;
        String string2;
        String string3;
        block7: {
            Object var4_12;
            block8: {
                block9: {
                    if (object == null) {
                        return null;
                    }
                    var4_12 = null;
                    string2 = string3 = JsonHttpResponseHandler.getResponseString(object, this.getCharset());
                    Object var1_2 = var4_12;
                    if (string3 == null) break block7;
                    string3 = string3.trim();
                    if (!this.useRFC5179CompatibilityMode) break block8;
                    if (string3.startsWith("{")) break block9;
                    string2 = string3;
                    Object var1_3 = var4_12;
                    if (!string3.startsWith("[")) break block7;
                }
                Object object2 = new JSONTokener(string3).nextValue();
                string2 = string3;
                break block7;
            }
            if (string3.startsWith("{") && string3.endsWith("}") || string3.startsWith("[") && string3.endsWith("]")) {
                Object object3 = new JSONTokener(string3).nextValue();
                string2 = string3;
            } else {
                string2 = string3;
                Object var1_8 = var4_12;
                if (string3.startsWith("\"")) {
                    string2 = string3;
                    Object var1_9 = var4_12;
                    if (string3.endsWith("\"")) {
                        String string4 = string3.substring(1, string3.length() - 1);
                        string2 = string3;
                    }
                }
            }
        }
        string3 = var1_6;
        if (var1_6 != null) return string3;
        return string2;
    }

    public void setUseRFC5179CompatibilityMode(boolean bl) {
        this.useRFC5179CompatibilityMode = bl;
    }
}

