/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.Utils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public abstract class FileAsyncHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "FileAsyncHttpRH";
    protected final boolean append;
    protected final File file;
    protected File frontendFile;
    protected final boolean renameIfExists;

    public FileAsyncHttpResponseHandler(Context context) {
        this.file = this.getTemporaryFile(context);
        this.append = false;
        this.renameIfExists = false;
    }

    public FileAsyncHttpResponseHandler(File file) {
        this(file, false);
    }

    public FileAsyncHttpResponseHandler(File file, boolean bl) {
        this(file, bl, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    public FileAsyncHttpResponseHandler(File file, boolean bl, boolean bl2) {
        boolean bl3 = file != null;
        Utils.asserts(bl3, "File passed into FileAsyncHttpResponseHandler constructor must not be null");
        if (!file.isDirectory() && !file.getParentFile().isDirectory()) {
            Utils.asserts(file.getParentFile().mkdirs(), "Cannot create parent directories for requested File location");
        }
        if (file.isDirectory() && !file.mkdirs()) {
            AsyncHttpClient.log.d(LOG_TAG, "Cannot create directories for requested Directory location, might not be a problem");
        }
        this.file = file;
        this.append = bl;
        this.renameIfExists = bl2;
    }

    public boolean deleteTargetFile() {
        return this.getTargetFile() != null && this.getTargetFile().delete();
    }

    /*
     * Enabled aggressive block sorting
     */
    protected File getOriginalFile() {
        boolean bl = this.file != null;
        Utils.asserts(bl, "Target file is null, fatal!");
        return this.file;
    }

    @Override
    protected byte[] getResponseData(HttpEntity object) throws IOException {
        if (object != null) {
            InputStream inputStream = object.getContent();
            long l2 = object.getContentLength();
            object = new FileOutputStream(this.getTargetFile(), this.append);
            if (inputStream != null) {
                block8: {
                    int n2;
                    int n3;
                    byte[] byArray;
                    try {
                        byArray = new byte[4096];
                        n3 = 0;
                    }
                    catch (Throwable throwable) {
                        AsyncHttpClient.silentCloseInputStream(inputStream);
                        ((OutputStream)object).flush();
                        AsyncHttpClient.silentCloseOutputStream((OutputStream)object);
                        throw throwable;
                    }
                    while (true) {
                        n2 = inputStream.read(byArray);
                        if (n2 == -1) break block8;
                        break;
                    }
                    {
                        if (Thread.currentThread().isInterrupted()) break block8;
                        n3 += n2;
                        ((FileOutputStream)object).write(byArray, 0, n2);
                        this.sendProgressMessage(n3, l2);
                        continue;
                    }
                }
                AsyncHttpClient.silentCloseInputStream(inputStream);
                ((OutputStream)object).flush();
                AsyncHttpClient.silentCloseOutputStream((OutputStream)object);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public File getTargetFile() {
        if (this.frontendFile == null) {
            File file = this.getOriginalFile().isDirectory() ? this.getTargetFileByParsingURL() : this.getOriginalFile();
            this.frontendFile = file;
        }
        return this.frontendFile;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected File getTargetFileByParsingURL() {
        Utils.asserts(this.getOriginalFile().isDirectory(), "Target file is not a directory, cannot proceed");
        boolean bl = this.getRequestURI() != null;
        Utils.asserts(bl, "RequestURI is null, cannot proceed");
        String string2 = this.getRequestURI().toString();
        string2 = string2.substring(string2.lastIndexOf(47) + 1, string2.length());
        File file = new File(this.getOriginalFile(), string2);
        if (!file.exists() || !this.renameIfExists) {
            return file;
        }
        string2 = !string2.contains(".") ? string2 + " (%d)" : string2.substring(0, string2.lastIndexOf(46)) + " (%d)" + string2.substring(string2.lastIndexOf(46), string2.length());
        int n2 = 0;
        while ((file = new File(this.getOriginalFile(), String.format(string2, n2))).exists()) {
            ++n2;
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected File getTemporaryFile(Context object) {
        boolean bl = object != null;
        Utils.asserts(bl, "Tried creating temporary file without having Context");
        try {
            return File.createTempFile("temp_", "_handled", object.getCacheDir());
        }
        catch (IOException iOException) {
            AsyncHttpClient.log.e(LOG_TAG, "Cannot create temporary file", iOException);
            return null;
        }
    }

    public abstract void onFailure(int var1, Header[] var2, Throwable var3, File var4);

    @Override
    public final void onFailure(int n2, Header[] headerArray, byte[] byArray, Throwable throwable) {
        this.onFailure(n2, headerArray, throwable, this.getTargetFile());
    }

    public abstract void onSuccess(int var1, Header[] var2, File var3);

    @Override
    public final void onSuccess(int n2, Header[] headerArray, byte[] byArray) {
        this.onSuccess(n2, headerArray, this.getTargetFile());
    }
}

