/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Message;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.util.ByteArrayBuffer;

public abstract class DataAsyncHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "DataAsyncHttpRH";
    protected static final int PROGRESS_DATA_MESSAGE = 7;

    public static byte[] copyOfRange(byte[] byArray, int n2, int n3) throws ArrayIndexOutOfBoundsException, IllegalArgumentException, NullPointerException {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        int n4 = byArray.length;
        if (n2 < 0 || n2 > n4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        n4 = Math.min(n3 -= n2, n4 - n2);
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n4);
        return byArray2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    byte[] getResponseData(HttpEntity httpEntity) throws IOException {
        byte[] byArray;
        byte[] byArray2 = byArray = null;
        if (httpEntity == null) return byArray2;
        InputStream inputStream = httpEntity.getContent();
        byArray2 = byArray;
        if (inputStream == null) return byArray2;
        long l2 = httpEntity.getContentLength();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
        }
        long l3 = l2;
        if (l2 < 0L) {
            l3 = 4096L;
        }
        httpEntity = new ByteArrayBuffer((int)l3);
        {
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                throw new IOException("File too large to fit into available memory");
            }
            try {
                int n2;
                byArray2 = new byte[4096];
                while ((n2 = inputStream.read(byArray2)) != -1) {
                    if (Thread.currentThread().isInterrupted()) return httpEntity.toByteArray();
                    httpEntity.append(byArray2, 0, n2);
                    this.sendProgressDataMessage(DataAsyncHttpResponseHandler.copyOfRange(byArray2, 0, n2));
                    this.sendProgressMessage(0, l3);
                }
                return httpEntity.toByteArray();
            }
            finally {
                AsyncHttpClient.silentCloseInputStream(inputStream);
            }
        }
    }

    @Override
    protected void handleMessage(Message objectArray) {
        super.handleMessage((Message)objectArray);
        switch (objectArray.what) {
            default: {
                return;
            }
            case 7: 
        }
        objectArray = (Object[])objectArray.obj;
        if (objectArray != null && objectArray.length >= 1) {
            try {
                this.onProgressData((byte[])objectArray[0]);
                return;
            }
            catch (Throwable throwable) {
                AsyncHttpClient.log.e(LOG_TAG, "custom onProgressData contains an error", throwable);
                return;
            }
        }
        AsyncHttpClient.log.e(LOG_TAG, "PROGRESS_DATA_MESSAGE didn't got enough params");
    }

    public void onProgressData(byte[] byArray) {
        AsyncHttpClient.log.d(LOG_TAG, "onProgressData(byte[]) was not overriden, but callback was received");
    }

    public final void sendProgressDataMessage(byte[] byArray) {
        this.sendMessage(this.obtainMessage(7, new Object[]{byArray}));
    }
}

