/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Looper;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.AsyncHttpResponseHandler;
import java.io.IOException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;

public abstract class BinaryHttpResponseHandler
extends AsyncHttpResponseHandler {
    private static final String LOG_TAG = "BinaryHttpRH";
    private String[] mAllowedContentTypes = new String[]{"application/octet-stream", "image/jpeg", "image/png", "image/gif"};

    public BinaryHttpResponseHandler() {
    }

    public BinaryHttpResponseHandler(String[] stringArray) {
        if (stringArray != null) {
            this.mAllowedContentTypes = stringArray;
            return;
        }
        AsyncHttpClient.log.e(LOG_TAG, "Constructor passed allowedContentTypes was null !");
    }

    public BinaryHttpResponseHandler(String[] stringArray, Looper looper) {
        super(looper);
        if (stringArray != null) {
            this.mAllowedContentTypes = stringArray;
            return;
        }
        AsyncHttpClient.log.e(LOG_TAG, "Constructor passed allowedContentTypes was null !");
    }

    public String[] getAllowedContentTypes() {
        return this.mAllowedContentTypes;
    }

    @Override
    public abstract void onFailure(int var1, Header[] var2, byte[] var3, Throwable var4);

    @Override
    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void sendResponseMessage(HttpResponse httpResponse) throws IOException {
        StatusLine statusLine = httpResponse.getStatusLine();
        Header header = httpResponse.getHeaders("Content-Type");
        if (((Header[])header).length != 1) {
            this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null, (Throwable)new HttpResponseException(statusLine.getStatusCode(), "None, or more than one, Content-Type Header found!"));
            return;
        }
        header = header[0];
        boolean bl = false;
        for (String string2 : this.getAllowedContentTypes()) {
            try {
                boolean bl2 = Pattern.matches(string2, header.getValue());
                if (!bl2) continue;
                bl = true;
            }
            catch (PatternSyntaxException patternSyntaxException) {
                AsyncHttpClient.log.e(LOG_TAG, "Given pattern is not valid: " + string2, patternSyntaxException);
            }
        }
        if (!bl) {
            this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), null, (Throwable)new HttpResponseException(statusLine.getStatusCode(), "Content-Type (" + header.getValue() + ") not allowed!"));
            return;
        }
        super.sendResponseMessage(httpResponse);
    }
}

