/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.Base64;
import com.loopj.android.http.Base64DataException;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Base64OutputStream
extends FilterOutputStream {
    private static byte[] EMPTY = new byte[0];
    private int bpos = 0;
    private byte[] buffer = null;
    private final Base64.Coder coder;
    private final int flags;

    public Base64OutputStream(OutputStream outputStream, int n2) {
        this(outputStream, n2, true);
    }

    public Base64OutputStream(OutputStream outputStream, int n2, boolean bl) {
        super(outputStream);
        this.flags = n2;
        if (bl) {
            this.coder = new Base64.Encoder(n2, null);
            return;
        }
        this.coder = new Base64.Decoder(n2, null);
    }

    private byte[] embiggen(byte[] byArray, int n2) {
        byte[] byArray2;
        block3: {
            block2: {
                if (byArray == null) break block2;
                byArray2 = byArray;
                if (byArray.length >= n2) break block3;
            }
            byArray2 = new byte[n2];
        }
        return byArray2;
    }

    private void flushBuffer() throws IOException {
        if (this.bpos > 0) {
            this.internalWrite(this.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
    }

    private void internalWrite(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        this.coder.output = this.embiggen(this.coder.output, this.coder.maxOutputSize(n3));
        if (!this.coder.process(byArray, n2, n3, bl)) {
            throw new Base64DataException("bad base-64");
        }
        this.out.write(this.coder.output, 0, this.coder.op);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() throws IOException {
        IOException iOException;
        block7: {
            IOException iOException2 = null;
            try {
                this.flushBuffer();
                this.internalWrite(EMPTY, 0, 0, true);
            }
            catch (IOException iOException3) {}
            try {
                if ((this.flags & 0x10) == 0) {
                    this.out.close();
                    iOException = iOException2;
                    break block7;
                }
                this.out.flush();
                iOException = iOException2;
            }
            catch (IOException iOException4) {
                iOException = iOException2;
                if (iOException2 == null) break block7;
                iOException = iOException4;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void write(int n2) throws IOException {
        if (this.buffer == null) {
            this.buffer = new byte[1024];
        }
        if (this.bpos >= this.buffer.length) {
            this.internalWrite(this.buffer, 0, this.bpos, false);
            this.bpos = 0;
        }
        byte[] byArray = this.buffer;
        int n3 = this.bpos;
        this.bpos = n3 + 1;
        byArray[n3] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 <= 0) {
            return;
        }
        this.flushBuffer();
        this.internalWrite(byArray, n2, n3, false);
    }
}

