/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.LogInterface;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.URI;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpResponseException;
import org.apache.http.util.ByteArrayBuffer;

public abstract class AsyncHttpResponseHandler
implements ResponseHandlerInterface {
    protected static final int BUFFER_SIZE = 4096;
    protected static final int CANCEL_MESSAGE = 6;
    public static final String DEFAULT_CHARSET = "UTF-8";
    protected static final int FAILURE_MESSAGE = 1;
    protected static final int FINISH_MESSAGE = 3;
    private static final String LOG_TAG = "AsyncHttpRH";
    protected static final int PROGRESS_MESSAGE = 4;
    protected static final int RETRY_MESSAGE = 5;
    protected static final int START_MESSAGE = 2;
    protected static final int SUCCESS_MESSAGE = 0;
    public static final String UTF8_BOM = "\ufeff";
    private WeakReference<Object> TAG = new WeakReference<Object>(null);
    private Handler handler;
    private Looper looper = null;
    private Header[] requestHeaders = null;
    private URI requestURI = null;
    private String responseCharset = "UTF-8";
    private boolean usePoolThread;
    private boolean useSynchronousMode;

    public AsyncHttpResponseHandler() {
        this(null);
    }

    public AsyncHttpResponseHandler(Looper looper) {
        Looper looper2 = looper;
        if (looper == null) {
            looper2 = Looper.myLooper();
        }
        this.looper = looper2;
        this.setUseSynchronousMode(false);
        this.setUsePoolThread(false);
    }

    public AsyncHttpResponseHandler(boolean bl) {
        this.setUsePoolThread(bl);
        if (!this.getUsePoolThread()) {
            this.looper = Looper.myLooper();
            this.setUseSynchronousMode(false);
        }
    }

    public String getCharset() {
        if (this.responseCharset == null) {
            return DEFAULT_CHARSET;
        }
        return this.responseCharset;
    }

    @Override
    public Header[] getRequestHeaders() {
        return this.requestHeaders;
    }

    @Override
    public URI getRequestURI() {
        return this.requestURI;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] getResponseData(HttpEntity httpEntity) throws IOException {
        Object object;
        Object object2 = object = null;
        if (httpEntity == null) return object2;
        InputStream inputStream = httpEntity.getContent();
        object2 = object;
        if (inputStream == null) return object2;
        long l2 = httpEntity.getContentLength();
        if (l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("HTTP entity too large to be buffered in memory");
        }
        int n2 = l2 <= 0L ? 4096 : (int)l2;
        object2 = new ByteArrayBuffer(n2);
        {
            catch (OutOfMemoryError outOfMemoryError) {
                System.gc();
                throw new IOException("File too large to fit into available memory");
            }
            try {
                object = new byte[4096];
                long l3 = 0L;
                while ((n2 = inputStream.read((byte[])object)) != -1) {
                    if (Thread.currentThread().isInterrupted()) return object2.toByteArray();
                    long l4 = l3 + (long)n2;
                    object2.append((byte[])object, 0, n2);
                    l3 = l2 <= 0L ? 1L : l2;
                    this.sendProgressMessage(l4, l3);
                    l3 = l4;
                }
                return object2.toByteArray();
            }
            finally {
                AsyncHttpClient.silentCloseInputStream(inputStream);
                AsyncHttpClient.endEntityViaReflection(httpEntity);
            }
        }
    }

    @Override
    public Object getTag() {
        return this.TAG.get();
    }

    @Override
    public boolean getUsePoolThread() {
        return this.usePoolThread;
    }

    @Override
    public boolean getUseSynchronousMode() {
        return this.useSynchronousMode;
    }

    /*
     * Exception decompiling
     */
    protected void handleMessage(Message var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 108->132)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected Message obtainMessage(int n2, Object object) {
        return Message.obtain((Handler)this.handler, (int)n2, (Object)object);
    }

    public void onCancel() {
        AsyncHttpClient.log.d(LOG_TAG, "Request got cancelled");
    }

    public abstract void onFailure(int var1, Header[] var2, byte[] var3, Throwable var4);

    public void onFinish() {
    }

    @Override
    public void onPostProcessResponse(ResponseHandlerInterface responseHandlerInterface, HttpResponse httpResponse) {
    }

    @Override
    public void onPreProcessResponse(ResponseHandlerInterface responseHandlerInterface, HttpResponse httpResponse) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void onProgress(long l2, long l3) {
        LogInterface logInterface = AsyncHttpClient.log;
        double d2 = l3 > 0L ? (double)l2 * 1.0 / (double)l3 * 100.0 : -1.0;
        logInterface.v(LOG_TAG, String.format("Progress %d from %d (%2.0f%%)", l2, l3, d2));
    }

    public void onRetry(int n2) {
        AsyncHttpClient.log.d(LOG_TAG, String.format("Request retry no. %d", n2));
    }

    public void onStart() {
    }

    public abstract void onSuccess(int var1, Header[] var2, byte[] var3);

    public void onUserException(Throwable throwable) {
        AsyncHttpClient.log.e(LOG_TAG, "User-space exception detected!", throwable);
        throw new RuntimeException(throwable);
    }

    protected void postRunnable(Runnable runnable) {
        block3: {
            block2: {
                if (runnable == null) break block2;
                if (!this.getUseSynchronousMode() && this.handler != null) break block3;
                runnable.run();
            }
            return;
        }
        this.handler.post(runnable);
    }

    @Override
    public final void sendCancelMessage() {
        this.sendMessage(this.obtainMessage(6, null));
    }

    @Override
    public final void sendFailureMessage(int n2, Header[] headerArray, byte[] byArray, Throwable throwable) {
        this.sendMessage(this.obtainMessage(1, new Object[]{n2, headerArray, byArray, throwable}));
    }

    @Override
    public final void sendFinishMessage() {
        this.sendMessage(this.obtainMessage(3, null));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void sendMessage(Message message) {
        boolean bl;
        if (this.getUseSynchronousMode() || this.handler == null) {
            this.handleMessage(message);
            return;
        } else {
            if (Thread.currentThread().isInterrupted()) return;
            bl = this.handler != null;
        }
        Utils.asserts(bl, "handler should not be null!");
        this.handler.sendMessage(message);
    }

    @Override
    public final void sendProgressMessage(long l2, long l3) {
        this.sendMessage(this.obtainMessage(4, new Object[]{l2, l3}));
    }

    @Override
    public void sendResponseMessage(HttpResponse httpResponse) throws IOException {
        byte[] byArray;
        StatusLine statusLine;
        block3: {
            block2: {
                if (Thread.currentThread().isInterrupted()) break block2;
                statusLine = httpResponse.getStatusLine();
                byArray = this.getResponseData(httpResponse.getEntity());
                if (Thread.currentThread().isInterrupted()) break block2;
                if (statusLine.getStatusCode() < 300) break block3;
                this.sendFailureMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), byArray, (Throwable)new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase()));
            }
            return;
        }
        this.sendSuccessMessage(statusLine.getStatusCode(), httpResponse.getAllHeaders(), byArray);
    }

    @Override
    public final void sendRetryMessage(int n2) {
        this.sendMessage(this.obtainMessage(5, new Object[]{n2}));
    }

    @Override
    public final void sendStartMessage() {
        this.sendMessage(this.obtainMessage(2, null));
    }

    @Override
    public final void sendSuccessMessage(int n2, Header[] headerArray, byte[] byArray) {
        this.sendMessage(this.obtainMessage(0, new Object[]{n2, headerArray, byArray}));
    }

    public void setCharset(String string2) {
        this.responseCharset = string2;
    }

    @Override
    public void setRequestHeaders(Header[] headerArray) {
        this.requestHeaders = headerArray;
    }

    @Override
    public void setRequestURI(URI uRI) {
        this.requestURI = uRI;
    }

    @Override
    public void setTag(Object object) {
        this.TAG = new WeakReference<Object>(object);
    }

    @Override
    public void setUsePoolThread(boolean bl) {
        if (bl) {
            this.looper = null;
            this.handler = null;
        }
        this.usePoolThread = bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setUseSynchronousMode(boolean bl) {
        boolean bl2 = bl;
        if (!bl) {
            bl2 = bl;
            if (this.looper == null) {
                bl2 = true;
                AsyncHttpClient.log.w(LOG_TAG, "Current thread has not called Looper.prepare(). Forcing synchronous mode.");
            }
        }
        if (!bl2 && this.handler == null) {
            this.handler = new ResponderHandler(this, this.looper);
        } else if (bl2 && this.handler != null) {
            this.handler = null;
        }
        this.useSynchronousMode = bl2;
    }

    private static class ResponderHandler
    extends Handler {
        private final AsyncHttpResponseHandler mResponder;

        ResponderHandler(AsyncHttpResponseHandler asyncHttpResponseHandler, Looper looper) {
            super(looper);
            this.mResponder = asyncHttpResponseHandler;
        }

        public void handleMessage(Message message) {
            this.mResponder.handleMessage(message);
        }
    }
}

