/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.RangeFileAsyncHttpResponseHandler;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.Utils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.protocol.HttpContext;

public class AsyncHttpRequest
implements Runnable {
    private boolean cancelIsNotified;
    private final AbstractHttpClient client;
    private final HttpContext context;
    private int executionCount;
    private final AtomicBoolean isCancelled = new AtomicBoolean();
    private volatile boolean isFinished;
    private boolean isRequestPreProcessed;
    private final HttpUriRequest request;
    private final ResponseHandlerInterface responseHandler;

    public AsyncHttpRequest(AbstractHttpClient abstractHttpClient, HttpContext httpContext, HttpUriRequest httpUriRequest, ResponseHandlerInterface responseHandlerInterface) {
        this.client = Utils.notNull(abstractHttpClient, "client");
        this.context = Utils.notNull(httpContext, "context");
        this.request = Utils.notNull(httpUriRequest, "request");
        this.responseHandler = Utils.notNull(responseHandlerInterface, "responseHandler");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void makeRequest() throws IOException {
        HttpResponse httpResponse;
        block6: {
            block5: {
                if (this.isCancelled()) break block5;
                if (this.request.getURI().getScheme() == null) {
                    throw new MalformedURLException("No valid URI scheme was provided");
                }
                if (this.responseHandler instanceof RangeFileAsyncHttpResponseHandler) {
                    ((RangeFileAsyncHttpResponseHandler)this.responseHandler).updateRequestHeaders(this.request);
                }
                httpResponse = this.client.execute(this.request, this.context);
                if (this.isCancelled()) break block5;
                this.responseHandler.onPreProcessResponse(this.responseHandler, httpResponse);
                if (this.isCancelled()) break block5;
                this.responseHandler.sendResponseMessage(httpResponse);
                if (!this.isCancelled()) break block6;
            }
            return;
        }
        this.responseHandler.onPostProcessResponse(this.responseHandler, httpResponse);
    }

    /*
     * Exception decompiling
     */
    private void makeRequestWithRetries() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sendCancelNotification() {
        synchronized (this) {
            if (!this.isFinished && this.isCancelled.get() && !this.cancelIsNotified) {
                this.cancelIsNotified = true;
                this.responseHandler.sendCancelMessage();
            }
            return;
        }
    }

    public boolean cancel(boolean bl) {
        this.isCancelled.set(true);
        this.request.abort();
        return this.isCancelled();
    }

    public Object getTag() {
        return this.responseHandler.getTag();
    }

    public boolean isCancelled() {
        boolean bl = this.isCancelled.get();
        if (bl) {
            this.sendCancelNotification();
        }
        return bl;
    }

    public boolean isDone() {
        return this.isCancelled() || this.isFinished;
    }

    public void onPostProcessRequest(AsyncHttpRequest asyncHttpRequest) {
    }

    public void onPreProcessRequest(AsyncHttpRequest asyncHttpRequest) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block9: {
            block8: {
                if (this.isCancelled()) break block8;
                if (!this.isRequestPreProcessed) {
                    this.isRequestPreProcessed = true;
                    this.onPreProcessRequest(this);
                }
                if (this.isCancelled()) break block8;
                this.responseHandler.sendStartMessage();
                if (this.isCancelled()) break block8;
                try {
                    this.makeRequestWithRetries();
                }
                catch (IOException iOException) {
                    if (!this.isCancelled()) {
                        this.responseHandler.sendFailureMessage(0, null, null, iOException);
                    }
                    AsyncHttpClient.log.e("AsyncHttpRequest", "makeRequestWithRetries returned error", iOException);
                }
                if (this.isCancelled()) break block8;
                this.responseHandler.sendFinishMessage();
                if (!this.isCancelled()) break block9;
            }
            return;
        }
        this.onPostProcessRequest(this);
        this.isFinished = true;
    }

    public AsyncHttpRequest setRequestTag(Object object) {
        this.responseHandler.setTag(object);
        return this;
    }
}

