/*
 * Decompiled with CFR 0.152.
 */
package com.loopj.android.http;

import android.content.Context;
import android.os.Looper;
import com.loopj.android.http.AsyncHttpRequest;
import com.loopj.android.http.AsyncHttpResponseHandler;
import com.loopj.android.http.HttpDelete;
import com.loopj.android.http.HttpGet;
import com.loopj.android.http.HttpPatch;
import com.loopj.android.http.LogHandler;
import com.loopj.android.http.LogInterface;
import com.loopj.android.http.MyRedirectHandler;
import com.loopj.android.http.MySSLSocketFactory;
import com.loopj.android.http.PreemptiveAuthorizationHttpRequestInterceptor;
import com.loopj.android.http.RequestHandle;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.RetryHandler;
import com.loopj.android.http.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.GZIPInputStream;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.entity.HttpEntityWrapper;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.SyncBasicHttpContext;

public class AsyncHttpClient {
    public static final int DEFAULT_MAX_CONNECTIONS = 10;
    public static final int DEFAULT_MAX_RETRIES = 5;
    public static final int DEFAULT_RETRY_SLEEP_TIME_MILLIS = 1500;
    public static final int DEFAULT_SOCKET_BUFFER_SIZE = 8192;
    public static final int DEFAULT_SOCKET_TIMEOUT = 10000;
    public static final String ENCODING_GZIP = "gzip";
    public static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    public static final String HEADER_CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    public static final String HEADER_CONTENT_RANGE = "Content-Range";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String LOG_TAG = "AsyncHttpClient";
    public static LogInterface log = new LogHandler();
    private final Map<String, String> clientHeaderMap;
    private int connectTimeout;
    private final DefaultHttpClient httpClient;
    private final HttpContext httpContext;
    private boolean isUrlEncodingEnabled;
    private int maxConnections;
    private final Map<Context, List<RequestHandle>> requestMap;
    private int responseTimeout;
    private ExecutorService threadPool;

    public AsyncHttpClient() {
        this(false, 80, 443);
    }

    public AsyncHttpClient(int n2) {
        this(false, n2, 443);
    }

    public AsyncHttpClient(int n2, int n3) {
        this(false, n2, n3);
    }

    /*
     * Enabled aggressive block sorting
     */
    public AsyncHttpClient(SchemeRegistry schemeRegistry) {
        boolean bl = true;
        this.maxConnections = 10;
        this.connectTimeout = 10000;
        this.responseTimeout = 10000;
        this.isUrlEncodingEnabled = true;
        BasicHttpParams basicHttpParams = new BasicHttpParams();
        ConnManagerParams.setTimeout((HttpParams)basicHttpParams, (long)this.connectTimeout);
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)basicHttpParams, (ConnPerRoute)new ConnPerRouteBean(this.maxConnections));
        ConnManagerParams.setMaxTotalConnections((HttpParams)basicHttpParams, (int)10);
        HttpConnectionParams.setSoTimeout((HttpParams)basicHttpParams, (int)this.responseTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)basicHttpParams, (int)this.connectTimeout);
        HttpConnectionParams.setTcpNoDelay((HttpParams)basicHttpParams, (boolean)true);
        HttpConnectionParams.setSocketBufferSize((HttpParams)basicHttpParams, (int)8192);
        HttpProtocolParams.setVersion((HttpParams)basicHttpParams, (ProtocolVersion)HttpVersion.HTTP_1_1);
        schemeRegistry = this.createConnectionManager(schemeRegistry, basicHttpParams);
        if (schemeRegistry == null) {
            bl = false;
        }
        Utils.asserts(bl, "Custom implementation of #createConnectionManager(SchemeRegistry, BasicHttpParams) returned null");
        this.threadPool = this.getDefaultThreadPool();
        this.requestMap = Collections.synchronizedMap(new WeakHashMap());
        this.clientHeaderMap = new HashMap<String, String>();
        this.httpContext = new SyncBasicHttpContext((HttpContext)new BasicHttpContext());
        this.httpClient = new DefaultHttpClient((ClientConnectionManager)schemeRegistry, (HttpParams)basicHttpParams);
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest httpRequest, HttpContext object) {
                if (!httpRequest.containsHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING)) {
                    httpRequest.addHeader(AsyncHttpClient.HEADER_ACCEPT_ENCODING, AsyncHttpClient.ENCODING_GZIP);
                }
                for (String string2 : AsyncHttpClient.this.clientHeaderMap.keySet()) {
                    if (httpRequest.containsHeader(string2)) {
                        Header header = httpRequest.getFirstHeader(string2);
                        log.d(AsyncHttpClient.LOG_TAG, String.format("Headers were overwritten! (%s | %s) overwrites (%s | %s)", string2, AsyncHttpClient.this.clientHeaderMap.get(string2), header.getName(), header.getValue()));
                        httpRequest.removeHeader(header);
                    }
                    httpRequest.addHeader(string2, (String)AsyncHttpClient.this.clientHeaderMap.get(string2));
                }
            }
        });
        this.httpClient.addResponseInterceptor(new HttpResponseInterceptor(){

            /*
             * Enabled aggressive block sorting
             */
            public void process(HttpResponse httpResponse, HttpContext httpContext) {
                HeaderElement[] headerElementArray;
                httpContext = httpResponse.getEntity();
                if (httpContext != null && (headerElementArray = httpContext.getContentEncoding()) != null) {
                    headerElementArray = headerElementArray.getElements();
                    int n2 = headerElementArray.length;
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!headerElementArray[i2].getName().equalsIgnoreCase(AsyncHttpClient.ENCODING_GZIP)) continue;
                        httpResponse.setEntity((HttpEntity)new InflatingEntity((HttpEntity)httpContext));
                        return;
                    }
                }
            }
        });
        this.httpClient.addRequestInterceptor(new HttpRequestInterceptor(){

            public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
                httpRequest = (AuthState)httpContext.getAttribute("http.auth.target-scope");
                CredentialsProvider credentialsProvider = (CredentialsProvider)httpContext.getAttribute("http.auth.credentials-provider");
                httpContext = (HttpHost)httpContext.getAttribute("http.target_host");
                if (httpRequest.getAuthScheme() == null && (httpContext = credentialsProvider.getCredentials(new AuthScope(httpContext.getHostName(), httpContext.getPort()))) != null) {
                    httpRequest.setAuthScheme((AuthScheme)new BasicScheme());
                    httpRequest.setCredentials((Credentials)httpContext);
                }
            }
        }, 0);
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(5, 1500));
    }

    public AsyncHttpClient(boolean bl, int n2, int n3) {
        this(AsyncHttpClient.getDefaultSchemeRegistry(bl, n2, n3));
    }

    private HttpEntityEnclosingRequestBase addEntityToRequestBase(HttpEntityEnclosingRequestBase httpEntityEnclosingRequestBase, HttpEntity httpEntity) {
        if (httpEntity != null) {
            httpEntityEnclosingRequestBase.setEntity(httpEntity);
        }
        return httpEntityEnclosingRequestBase;
    }

    public static void allowRetryExceptionClass(Class<?> clazz) {
        if (clazz != null) {
            RetryHandler.addClassToWhitelist(clazz);
        }
    }

    public static void blockRetryExceptionClass(Class<?> clazz) {
        if (clazz != null) {
            RetryHandler.addClassToBlacklist(clazz);
        }
    }

    private void cancelRequests(List<RequestHandle> object, boolean bl) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                ((RequestHandle)object.next()).cancel(bl);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void endEntityViaReflection(HttpEntity var0) {
        if (!(var0 instanceof HttpEntityWrapper)) ** GOTO lbl23
        var4_2 = null;
        try {
            var5_3 = HttpEntityWrapper.class.getDeclaredFields();
            var2_4 = var5_3.length;
            var1_5 = 0;
        }
        catch (Throwable var0_1) {
            AsyncHttpClient.log.e("AsyncHttpClient", "wrappedEntity consume", var0_1);
            return;
        }
        while (true) lbl-1000:
        // 2 sources

        {
            var3_6 = var4_2;
            if (var1_5 < var2_4) {
                var3_6 = var5_3[var1_5];
                if (!var3_6.getName().equals("wrappedEntity")) break block7;
            }
            if (var3_6 == null) ** GOTO lbl23
            var3_6.setAccessible(true);
            var0 = (HttpEntity)var3_6.get(var0);
            if (var0 == null) ** GOTO lbl23
            break;
        }
        {
            block7: {
                var0.consumeContent();
lbl23:
                // 4 sources

                return;
            }
            ++var1_5;
            ** while (true)
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static SchemeRegistry getDefaultSchemeRegistry(boolean bl, int n2, int n3) {
        if (bl) {
            log.d(LOG_TAG, "Beware! Using the fix is insecure, as it doesn't verify SSL certificates.");
        }
        int n4 = n2;
        if (n2 < 1) {
            n4 = 80;
            log.d(LOG_TAG, "Invalid HTTP port number specified, defaulting to 80");
        }
        n2 = n3;
        if (n3 < 1) {
            n2 = 443;
            log.d(LOG_TAG, "Invalid HTTPS port number specified, defaulting to 443");
        }
        SSLSocketFactory sSLSocketFactory = bl ? MySSLSocketFactory.getFixedSocketFactory() : SSLSocketFactory.getSocketFactory();
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), n4));
        schemeRegistry.register(new Scheme("https", (SocketFactory)sSLSocketFactory, n2));
        return schemeRegistry;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getUrlWithQueryString(boolean bl, String object, RequestParams object2) {
        if (object == null) {
            return null;
        }
        Object object3 = object;
        if (bl) {
            try {
                object3 = new URL(URLDecoder.decode((String)object, "UTF-8"));
                object3 = new URI(((URL)object3).getProtocol(), ((URL)object3).getUserInfo(), ((URL)object3).getHost(), ((URL)object3).getPort(), ((URL)object3).getPath(), ((URL)object3).getQuery(), ((URL)object3).getRef()).toASCIIString();
            }
            catch (Exception exception) {
                log.e(LOG_TAG, "getUrlWithQueryString encoding URL", exception);
                object3 = object;
            }
        }
        object = object3;
        if (object2 == null) return object;
        object2 = ((RequestParams)object2).getParamString().trim();
        object = object3;
        if (((String)object2).equals("")) return object;
        object = object3;
        if (((String)object2).equals("?")) return object;
        StringBuilder stringBuilder = new StringBuilder().append((String)object3);
        object = ((String)object3).contains("?") ? "&" : "?";
        object = stringBuilder.append((String)object).toString();
        return (String)object + (String)object2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isInputStreamGZIPCompressed(PushbackInputStream pushbackInputStream) throws IOException {
        boolean bl = true;
        if (pushbackInputStream == null) {
            return false;
        }
        byte[] byArray = new byte[2];
        int n2 = pushbackInputStream.read(byArray);
        pushbackInputStream.unread(byArray);
        byte by = byArray[0];
        byte by2 = byArray[1];
        if (n2 != 2) return false;
        if (35615 != (by & 0xFF | by2 << 8 & 0xFF00)) return false;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private HttpEntity paramsToEntity(RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        HttpEntity httpEntity = null;
        if (requestParams == null) return httpEntity;
        try {
            return requestParams.getEntity(responseHandlerInterface);
        }
        catch (IOException iOException) {
            if (responseHandlerInterface != null) {
                responseHandlerInterface.sendFailureMessage(0, null, null, iOException);
                return null;
            }
            iOException.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void silentCloseInputStream(InputStream inputStream) {
        if (inputStream == null) return;
        try {
            inputStream.close();
            return;
        }
        catch (IOException iOException) {
            log.w(LOG_TAG, "Cannot close input stream", iOException);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void silentCloseOutputStream(OutputStream outputStream) {
        if (outputStream == null) return;
        try {
            outputStream.close();
            return;
        }
        catch (IOException iOException) {
            log.w(LOG_TAG, "Cannot close output stream", iOException);
            return;
        }
    }

    public void addHeader(String string2, String string3) {
        this.clientHeaderMap.put(string2, string3);
    }

    public void cancelAllRequests(boolean bl) {
        for (List<RequestHandle> list : this.requestMap.values()) {
            if (list == null) continue;
            list = list.iterator();
            while (list.hasNext()) {
                ((RequestHandle)list.next()).cancel(bl);
            }
        }
        this.requestMap.clear();
    }

    public void cancelRequests(Context object, final boolean bl) {
        if (object == null) {
            log.e(LOG_TAG, "Passed null Context to cancelRequests");
            return;
        }
        final List<RequestHandle> list = this.requestMap.get(object);
        this.requestMap.remove(object);
        if (Looper.myLooper() == Looper.getMainLooper()) {
            object = new Runnable(){

                @Override
                public void run() {
                    AsyncHttpClient.this.cancelRequests(list, bl);
                }
            };
            this.threadPool.submit((Runnable)object);
            return;
        }
        this.cancelRequests(list, bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void cancelRequestsByTAG(Object object, boolean bl) {
        if (object == null) {
            log.d(LOG_TAG, "cancelRequestsByTAG, passed TAG is null, cannot proceed");
            return;
        } else {
            for (List<RequestHandle> list : this.requestMap.values()) {
                if (list == null) continue;
                list = list.iterator();
                while (list.hasNext()) {
                    RequestHandle requestHandle = (RequestHandle)list.next();
                    if (!object.equals(requestHandle.getTag())) continue;
                    requestHandle.cancel(bl);
                }
            }
        }
    }

    public void clearCredentialsProvider() {
        this.httpClient.getCredentialsProvider().clear();
    }

    protected ClientConnectionManager createConnectionManager(SchemeRegistry schemeRegistry, BasicHttpParams basicHttpParams) {
        return new ThreadSafeClientConnManager((HttpParams)basicHttpParams, schemeRegistry);
    }

    public RequestHandle delete(Context context, String object, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpDelete(this.getURI((String)object));
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public RequestHandle delete(Context context, String string2, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase(new HttpDelete(URI.create(string2).normalize()), httpEntity), string3, responseHandlerInterface, context);
    }

    public RequestHandle delete(Context context, String object, Header[] headerArray, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpDelete(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, object, requestParams));
        if (headerArray != null) {
            object.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public RequestHandle delete(Context context, String object, Header[] headerArray, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpDelete(this.getURI((String)object));
        if (headerArray != null) {
            object.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public RequestHandle delete(String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.delete(null, string2, responseHandlerInterface);
    }

    public void delete(String object, RequestParams requestParams, AsyncHttpResponseHandler asyncHttpResponseHandler) {
        object = new HttpDelete(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, object, requestParams));
        this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, asyncHttpResponseHandler, null);
    }

    public RequestHandle get(Context context, String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpGet(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, string2, requestParams)), null, responseHandlerInterface, context);
    }

    public RequestHandle get(Context context, String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.get(context, string2, null, responseHandlerInterface);
    }

    public RequestHandle get(Context context, String string2, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase(new HttpGet(URI.create(string2).normalize()), httpEntity), string3, responseHandlerInterface, context);
    }

    public RequestHandle get(Context context, String object, Header[] headerArray, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        object = new HttpGet(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, object, requestParams));
        if (headerArray != null) {
            object.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)object, null, responseHandlerInterface, context);
    }

    public RequestHandle get(String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.get(null, string2, requestParams, responseHandlerInterface);
    }

    public RequestHandle get(String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.get(null, string2, null, responseHandlerInterface);
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    protected ExecutorService getDefaultThreadPool() {
        return Executors.newCachedThreadPool();
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }

    public LogInterface getLogInterface() {
        return log;
    }

    public int getLoggingLevel() {
        return log.getLoggingLevel();
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getResponseTimeout() {
        return this.responseTimeout;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    protected URI getURI(String string2) {
        return URI.create(string2).normalize();
    }

    public RequestHandle head(Context context, String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)new HttpHead(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, string2, requestParams)), null, responseHandlerInterface, context);
    }

    public RequestHandle head(Context context, String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.head(context, string2, null, responseHandlerInterface);
    }

    public RequestHandle head(Context context, String string2, Header[] headerArray, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        string2 = new HttpHead(AsyncHttpClient.getUrlWithQueryString(this.isUrlEncodingEnabled, string2, requestParams));
        if (headerArray != null) {
            string2.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string2, null, responseHandlerInterface, context);
    }

    public RequestHandle head(String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.head(null, string2, requestParams, responseHandlerInterface);
    }

    public RequestHandle head(String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.head(null, string2, null, responseHandlerInterface);
    }

    public boolean isLoggingEnabled() {
        return log.isLoggingEnabled();
    }

    public boolean isUrlEncodingEnabled() {
        return this.isUrlEncodingEnabled;
    }

    protected AsyncHttpRequest newAsyncHttpRequest(DefaultHttpClient defaultHttpClient, HttpContext httpContext, HttpUriRequest httpUriRequest, String string2, ResponseHandlerInterface responseHandlerInterface, Context context) {
        return new AsyncHttpRequest((AbstractHttpClient)defaultHttpClient, httpContext, httpUriRequest, responseHandlerInterface);
    }

    public RequestHandle patch(Context context, String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.patch(context, string2, this.paramsToEntity(requestParams, responseHandlerInterface), null, responseHandlerInterface);
    }

    public RequestHandle patch(Context context, String string2, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase(new HttpPatch(this.getURI(string2)), httpEntity), string3, responseHandlerInterface, context);
    }

    public RequestHandle patch(Context context, String string2, Header[] headerArray, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        string2 = this.addEntityToRequestBase(new HttpPatch(this.getURI(string2)), httpEntity);
        if (headerArray != null) {
            string2.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string2, string3, responseHandlerInterface, context);
    }

    public RequestHandle patch(String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.patch(null, string2, requestParams, responseHandlerInterface);
    }

    public RequestHandle patch(String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.patch(null, string2, null, responseHandlerInterface);
    }

    public RequestHandle post(Context context, String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.post(context, string2, this.paramsToEntity(requestParams, responseHandlerInterface), null, responseHandlerInterface);
    }

    public RequestHandle post(Context context, String string2, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(this.getURI(string2)), httpEntity), string3, responseHandlerInterface, context);
    }

    public RequestHandle post(Context context, String string2, Header[] headerArray, RequestParams requestParams, String string3, ResponseHandlerInterface responseHandlerInterface) {
        string2 = new HttpPost(this.getURI(string2));
        if (requestParams != null) {
            string2.setEntity(this.paramsToEntity(requestParams, responseHandlerInterface));
        }
        if (headerArray != null) {
            string2.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string2, string3, responseHandlerInterface, context);
    }

    public RequestHandle post(Context context, String string2, Header[] headerArray, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        string2 = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPost(this.getURI(string2)), httpEntity);
        if (headerArray != null) {
            string2.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string2, string3, responseHandlerInterface, context);
    }

    public RequestHandle post(String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.post(null, string2, requestParams, responseHandlerInterface);
    }

    public RequestHandle post(String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.post(null, string2, null, responseHandlerInterface);
    }

    public RequestHandle put(Context context, String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.put(context, string2, this.paramsToEntity(requestParams, responseHandlerInterface), null, responseHandlerInterface);
    }

    public RequestHandle put(Context context, String string2, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(this.getURI(string2)), httpEntity), string3, responseHandlerInterface, context);
    }

    public RequestHandle put(Context context, String string2, Header[] headerArray, HttpEntity httpEntity, String string3, ResponseHandlerInterface responseHandlerInterface) {
        string2 = this.addEntityToRequestBase((HttpEntityEnclosingRequestBase)new HttpPut(this.getURI(string2)), httpEntity);
        if (headerArray != null) {
            string2.setHeaders(headerArray);
        }
        return this.sendRequest(this.httpClient, this.httpContext, (HttpUriRequest)string2, string3, responseHandlerInterface, context);
    }

    public RequestHandle put(String string2, RequestParams requestParams, ResponseHandlerInterface responseHandlerInterface) {
        return this.put(null, string2, requestParams, responseHandlerInterface);
    }

    public RequestHandle put(String string2, ResponseHandlerInterface responseHandlerInterface) {
        return this.put(null, string2, null, responseHandlerInterface);
    }

    public void removeAllHeaders() {
        this.clientHeaderMap.clear();
    }

    public void removeHeader(String string2) {
        this.clientHeaderMap.remove(string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected RequestHandle sendRequest(DefaultHttpClient object, HttpContext object2, HttpUriRequest object3, String object4, ResponseHandlerInterface responseHandlerInterface, Context context) {
        if (object3 == null) {
            throw new IllegalArgumentException("HttpUriRequest must not be null");
        }
        if (responseHandlerInterface == null) {
            throw new IllegalArgumentException("ResponseHandler must not be null");
        }
        if (responseHandlerInterface.getUseSynchronousMode() && !responseHandlerInterface.getUsePoolThread()) {
            throw new IllegalArgumentException("Synchronous ResponseHandler used in AsyncHttpClient. You should create your response handler in a looper thread or use SyncHttpClient instead.");
        }
        if (object4 != null) {
            if (object3 instanceof HttpEntityEnclosingRequestBase && ((HttpEntityEnclosingRequestBase)object3).getEntity() != null && object3.containsHeader(HEADER_CONTENT_TYPE)) {
                log.w(LOG_TAG, "Passed contentType will be ignored because HttpEntity sets content type");
            } else {
                object3.setHeader(HEADER_CONTENT_TYPE, (String)object4);
            }
        }
        responseHandlerInterface.setRequestHeaders(object3.getAllHeaders());
        responseHandlerInterface.setRequestURI(object3.getURI());
        object = this.newAsyncHttpRequest((DefaultHttpClient)object, (HttpContext)object2, (HttpUriRequest)object3, (String)object4, responseHandlerInterface, context);
        this.threadPool.submit((Runnable)object);
        object3 = new RequestHandle((AsyncHttpRequest)object);
        if (context != null) {
            object4 = this.requestMap;
            synchronized (object4) {
                object2 = this.requestMap.get(context);
                object = object2;
                if (object2 == null) {
                    object = Collections.synchronizedList(new LinkedList());
                    this.requestMap.put(context, (List<RequestHandle>)object);
                }
            }
            object.add(object3);
            object = object.iterator();
            while (object.hasNext()) {
                if (!((RequestHandle)object.next()).shouldBeGarbageCollected()) continue;
                object.remove();
            }
        }
        return object3;
    }

    public void setAuthenticationPreemptive(boolean bl) {
        if (bl) {
            this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthorizationHttpRequestInterceptor(), 0);
            return;
        }
        this.httpClient.removeRequestInterceptorByClass(PreemptiveAuthorizationHttpRequestInterceptor.class);
    }

    public void setBasicAuth(String string2, String string3) {
        this.setBasicAuth(string2, string3, false);
    }

    public void setBasicAuth(String string2, String string3, AuthScope authScope) {
        this.setBasicAuth(string2, string3, authScope, false);
    }

    public void setBasicAuth(String string2, String string3, AuthScope authScope, boolean bl) {
        this.setCredentials(authScope, (Credentials)new UsernamePasswordCredentials(string2, string3));
        this.setAuthenticationPreemptive(bl);
    }

    public void setBasicAuth(String string2, String string3, boolean bl) {
        this.setBasicAuth(string2, string3, null, bl);
    }

    public void setConnectTimeout(int n2) {
        int n3 = n2;
        if (n2 < 1000) {
            n3 = 10000;
        }
        this.connectTimeout = n3;
        HttpParams httpParams = this.httpClient.getParams();
        ConnManagerParams.setTimeout((HttpParams)httpParams, (long)this.connectTimeout);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParams, (int)this.connectTimeout);
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.httpContext.setAttribute("http.cookie-store", (Object)cookieStore);
    }

    public void setCredentials(AuthScope authScope, Credentials credentials) {
        if (credentials == null) {
            log.d(LOG_TAG, "Provided credentials are null, not setting");
            return;
        }
        CredentialsProvider credentialsProvider = this.httpClient.getCredentialsProvider();
        AuthScope authScope2 = authScope;
        if (authScope == null) {
            authScope2 = AuthScope.ANY;
        }
        credentialsProvider.setCredentials(authScope2, credentials);
    }

    public void setEnableRedirects(boolean bl) {
        this.setEnableRedirects(bl, bl, bl);
    }

    public void setEnableRedirects(boolean bl, boolean bl2) {
        this.setEnableRedirects(bl, bl2, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setEnableRedirects(boolean bl, boolean bl2, boolean bl3) {
        HttpParams httpParams = this.httpClient.getParams();
        bl2 = !bl2;
        httpParams.setBooleanParameter("http.protocol.reject-relative-redirect", bl2);
        this.httpClient.getParams().setBooleanParameter("http.protocol.allow-circular-redirects", bl3);
        this.httpClient.setRedirectHandler((RedirectHandler)new MyRedirectHandler(bl));
    }

    public void setLogInterface(LogInterface logInterface) {
        if (logInterface != null) {
            log = logInterface;
        }
    }

    public void setLoggingEnabled(boolean bl) {
        log.setLoggingEnabled(bl);
    }

    public void setLoggingLevel(int n2) {
        log.setLoggingLevel(n2);
    }

    public void setMaxConnections(int n2) {
        int n3 = n2;
        if (n2 < 1) {
            n3 = 10;
        }
        this.maxConnections = n3;
        ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)this.httpClient.getParams(), (ConnPerRoute)new ConnPerRouteBean(this.maxConnections));
    }

    public void setMaxRetriesAndTimeout(int n2, int n3) {
        this.httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new RetryHandler(n2, n3));
    }

    public void setProxy(String string2, int n2) {
        string2 = new HttpHost(string2, n2);
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)string2);
    }

    public void setProxy(String string2, int n2, String string3, String string4) {
        this.httpClient.getCredentialsProvider().setCredentials(new AuthScope(string2, n2), (Credentials)new UsernamePasswordCredentials(string3, string4));
        string2 = new HttpHost(string2, n2);
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)string2);
    }

    public void setRedirectHandler(RedirectHandler redirectHandler) {
        this.httpClient.setRedirectHandler(redirectHandler);
    }

    public void setResponseTimeout(int n2) {
        int n3 = n2;
        if (n2 < 1000) {
            n3 = 10000;
        }
        this.responseTimeout = n3;
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)this.responseTimeout);
    }

    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.httpClient.getConnectionManager().getSchemeRegistry().register(new Scheme("https", (SocketFactory)sSLSocketFactory, 443));
    }

    public void setThreadPool(ExecutorService executorService) {
        this.threadPool = executorService;
    }

    public void setTimeout(int n2) {
        int n3 = n2;
        if (n2 < 1000) {
            n3 = 10000;
        }
        this.setConnectTimeout(n3);
        this.setResponseTimeout(n3);
    }

    public void setURLEncodingEnabled(boolean bl) {
        this.isUrlEncodingEnabled = bl;
    }

    public void setUserAgent(String string2) {
        HttpProtocolParams.setUserAgent((HttpParams)this.httpClient.getParams(), (String)string2);
    }

    private static class InflatingEntity
    extends HttpEntityWrapper {
        GZIPInputStream gzippedStream;
        PushbackInputStream pushbackStream;
        InputStream wrappedStream;

        public InflatingEntity(HttpEntity httpEntity) {
            super(httpEntity);
        }

        public void consumeContent() throws IOException {
            AsyncHttpClient.silentCloseInputStream(this.wrappedStream);
            AsyncHttpClient.silentCloseInputStream(this.pushbackStream);
            AsyncHttpClient.silentCloseInputStream(this.gzippedStream);
            super.consumeContent();
        }

        public InputStream getContent() throws IOException {
            this.wrappedStream = this.wrappedEntity.getContent();
            this.pushbackStream = new PushbackInputStream(this.wrappedStream, 2);
            if (AsyncHttpClient.isInputStreamGZIPCompressed(this.pushbackStream)) {
                this.gzippedStream = new GZIPInputStream(this.pushbackStream);
                return this.gzippedStream;
            }
            return this.pushbackStream;
        }

        public long getContentLength() {
            if (this.wrappedEntity == null) {
                return 0L;
            }
            return this.wrappedEntity.getContentLength();
        }
    }
}

