/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location.service;

import android.content.Context;
import com.baidu.location.BDLocationListener;
import com.baidu.location.LocationClient;
import com.baidu.location.LocationClientOption;

public class LocationService {
    private LocationClient client = null;
    private LocationClientOption mOption;
    private Object objLock;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public LocationService(Context context) {
        Object object = this.objLock = new Object();
        synchronized (object) {
            if (this.client == null) {
                this.client = new LocationClient(context);
                this.client.setLocOption(this.getDefaultLocationClientOption());
            }
            return;
        }
    }

    public LocationClientOption getDefaultLocationClientOption() {
        if (this.mOption == null) {
            this.mOption = new LocationClientOption();
            this.mOption.setLocationMode(LocationClientOption.LocationMode.Hight_Accuracy);
            this.mOption.setCoorType("bd09ll");
            this.mOption.setScanSpan(1000);
            this.mOption.setIsNeedAddress(true);
            this.mOption.setIsNeedLocationDescribe(false);
            this.mOption.setNeedDeviceDirect(false);
            this.mOption.setLocationNotify(false);
            this.mOption.setIgnoreKillProcess(true);
            this.mOption.setIsNeedLocationDescribe(false);
            this.mOption.setIsNeedLocationPoiList(false);
            this.mOption.SetIgnoreCacheException(false);
            this.mOption.setIsNeedAltitude(false);
        }
        return this.mOption;
    }

    public boolean registerListener(BDLocationListener bDLocationListener) {
        boolean bl = false;
        if (bDLocationListener != null) {
            this.client.registerLocationListener(bDLocationListener);
            bl = true;
        }
        return bl;
    }

    public boolean requestHotSpotState() {
        return this.client.requestHotSpotState();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void start() {
        Object object = this.objLock;
        synchronized (object) {
            if (this.client != null && !this.client.isStarted()) {
                this.client.start();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        Object object = this.objLock;
        synchronized (object) {
            if (this.client != null && this.client.isStarted()) {
                this.client.stop();
            }
            return;
        }
    }

    public void unregisterListener(BDLocationListener bDLocationListener) {
        if (bDLocationListener != null) {
            this.client.unRegisterLocationListener(bDLocationListener);
        }
    }
}

