/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.location.Location;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.Messenger;
import android.text.TextUtils;
import com.baidu.location.BDLocation;
import com.baidu.location.BDLocationListener;
import com.baidu.location.BDNotifyListener;
import com.baidu.location.Jni;
import com.baidu.location.LocationClientOption;
import com.baidu.location.a.b;
import com.baidu.location.a.i;
import com.baidu.location.c;
import com.baidu.location.f;
import java.util.ArrayList;
import java.util.Iterator;

public final class LocationClient
implements b.b {
    public static final int CONNECT_HOT_SPOT_FALSE = 0;
    public static final int CONNECT_HOT_SPOT_TRUE = 1;
    public static final int CONNECT_HOT_SPOT_UNKNOWN = -1;
    private static final int MIN_REQUEST_SPAN = 1000;
    private static final int MSG_REG_LISTENER = 5;
    private static final int MSG_REG_NOTIFY_LISTENER = 8;
    private static final int MSG_REMOVE_NOTIFY = 10;
    private static final int MSG_REQ_LOC = 4;
    private static final int MSG_REQ_NOTIFY_LOC = 11;
    private static final int MSG_REQ_OFFLINE_LOC = 12;
    private static final int MSG_REQ_POI = 7;
    private static final int MSG_RIGSTER_NOTIFY = 9;
    private static final int MSG_SET_OPT = 3;
    private static final int MSG_START = 1;
    private static final int MSG_STOP = 2;
    private static final int MSG_UNREG_LISTENER = 6;
    private static final String mTAG = "baidu_location_Client";
    private BDLocationListener NotifyLocationListenner = null;
    private boolean clientFirst = false;
    private Boolean firstConnected = true;
    private boolean inDoorState = false;
    private boolean isScheduled = false;
    private boolean isStop = true;
    private boolean isWaitingForLocation = false;
    private boolean isWaitingLocTag = false;
    private long lastReceiveGpsTime = 0L;
    private long lastReceiveLocationTime = 0L;
    private Boolean mConfig_map = false;
    private Boolean mConfig_preimport = false;
    private ServiceConnection mConnection;
    private Context mContext = null;
    private boolean mDebugByDev;
    private boolean mGpsStatus = false;
    private a mHandler;
    private boolean mIsStarted = false;
    private String mKey;
    private BDLocation mLastLocation = null;
    private long mLastRequestTime = 0L;
    private ArrayList<BDLocationListener> mLocationListeners = null;
    private final Object mLock;
    private final Messenger mMessenger;
    private com.baidu.location.d.a mNotifyCache = null;
    private LocationClientOption mOption = new LocationClientOption();
    private String mPackName = null;
    private b mScheduledRequest = null;
    private Messenger mServer = null;
    private HandlerThread mThread;
    private com.baidu.location.a.b mloc = null;
    private boolean serverFirst = false;
    private String serviceName = null;

    public LocationClient(Context context) {
        this.mLock = new Object();
        this.mConnection = new com.baidu.location.b(this);
        this.mContext = context;
        this.mOption = new LocationClientOption();
        this.mThread = new HandlerThread("LocationClient");
        this.mThread.start();
        this.mHandler = new a(this.mThread.getLooper());
        this.mMessenger = new Messenger((Handler)this.mHandler);
    }

    public LocationClient(Context context, LocationClientOption locationClientOption) {
        this.mLock = new Object();
        this.mConnection = new com.baidu.location.b(this);
        this.mContext = context;
        this.mOption = locationClientOption;
        this.mThread = new HandlerThread("LocationClient");
        this.mThread.start();
        this.mHandler = new a(this.mThread.getLooper());
        this.mMessenger = new Messenger((Handler)this.mHandler);
    }

    static /* synthetic */ Messenger access$002(LocationClient locationClient, Messenger messenger) {
        locationClient.mServer = messenger;
        return messenger;
    }

    static /* synthetic */ boolean access$102(LocationClient locationClient, boolean bl) {
        locationClient.mIsStarted = bl;
        return bl;
    }

    static /* synthetic */ boolean access$1202(LocationClient locationClient, boolean bl) {
        locationClient.isScheduled = bl;
        return bl;
    }

    static /* synthetic */ b access$1502(LocationClient locationClient, b b2) {
        locationClient.mScheduledRequest = b2;
        return b2;
    }

    static /* synthetic */ boolean access$200(LocationClient locationClient) {
        return locationClient.isStop;
    }

    static /* synthetic */ boolean access$2702(LocationClient locationClient, boolean bl) {
        locationClient.mGpsStatus = bl;
        return bl;
    }

    static /* synthetic */ boolean access$2802(LocationClient locationClient, boolean bl) {
        locationClient.serverFirst = bl;
        return bl;
    }

    static /* synthetic */ Bundle access$500(LocationClient locationClient) {
        return locationClient.getOptionBundle();
    }

    static /* synthetic */ Boolean access$700(LocationClient locationClient) {
        return locationClient.firstConnected;
    }

    static /* synthetic */ Boolean access$702(LocationClient locationClient, Boolean bl) {
        locationClient.firstConnected = bl;
        return bl;
    }

    static /* synthetic */ com.baidu.location.a.b access$800(LocationClient locationClient) {
        return locationClient.mloc;
    }

    static /* synthetic */ com.baidu.location.a.b access$802(LocationClient locationClient, com.baidu.location.a.b b2) {
        locationClient.mloc = b2;
        return b2;
    }

    static /* synthetic */ Context access$900(LocationClient locationClient) {
        return locationClient.mContext;
    }

    private void callListeners(int n2) {
        block7: {
            block6: {
                if (this.mLastLocation.getCoorType() == null) {
                    this.mLastLocation.setCoorType(this.mOption.coorType);
                }
                if (!this.isWaitingForLocation && (!this.mOption.location_change_notify || this.mLastLocation.getLocType() != 61) && this.mLastLocation.getLocType() != 66 && this.mLastLocation.getLocType() != 67 && !this.inDoorState && this.mLastLocation.getLocType() != 161) break block6;
                if (this.mLocationListeners != null) {
                    Iterator<BDLocationListener> iterator = this.mLocationListeners.iterator();
                    while (iterator.hasNext()) {
                        iterator.next().onReceiveLocation(this.mLastLocation);
                    }
                }
                if (this.mLastLocation.getLocType() != 66 && this.mLastLocation.getLocType() != 67) break block7;
            }
            return;
        }
        this.isWaitingForLocation = false;
        this.lastReceiveLocationTime = System.currentTimeMillis();
    }

    public static BDLocation getBDLocationInCoorType(BDLocation object, String string2) {
        BDLocation bDLocation = new BDLocation((BDLocation)object);
        object = Jni.coorEncrypt(((BDLocation)object).getLongitude(), ((BDLocation)object).getLatitude(), string2);
        bDLocation.setLatitude((double)object[1]);
        bDLocation.setLongitude((double)object[0]);
        return bDLocation;
    }

    private Bundle getOptionBundle() {
        if (this.mOption == null) {
            return null;
        }
        Bundle bundle = new Bundle();
        bundle.putString("packName", this.mPackName);
        bundle.putString("prodName", this.mOption.prodName);
        bundle.putString("coorType", this.mOption.coorType);
        bundle.putString("addrType", this.mOption.addrType);
        bundle.putBoolean("openGPS", this.mOption.openGps);
        bundle.putBoolean("location_change_notify", this.mOption.location_change_notify);
        bundle.putInt("scanSpan", this.mOption.scanSpan);
        bundle.putBoolean("enableSimulateGps", this.mOption.enableSimulateGps);
        bundle.putInt("timeOut", this.mOption.timeOut);
        bundle.putInt("priority", this.mOption.priority);
        bundle.putBoolean("map", this.mConfig_map.booleanValue());
        bundle.putBoolean("import", this.mConfig_preimport.booleanValue());
        bundle.putBoolean("needDirect", this.mOption.mIsNeedDeviceDirect);
        bundle.putBoolean("isneedaptag", this.mOption.isNeedAptag);
        bundle.putBoolean("isneedpoiregion", this.mOption.isNeedPoiRegion);
        bundle.putBoolean("isneedregular", this.mOption.isNeedRegular);
        bundle.putBoolean("isneedaptagd", this.mOption.isNeedAptagd);
        bundle.putBoolean("isneedaltitude", this.mOption.isNeedAltitude);
        bundle.putInt("autoNotifyMaxInterval", this.mOption.getAutoNotifyMaxInterval());
        bundle.putInt("autoNotifyMinTimeInterval", this.mOption.getAutoNotifyMinTimeInterval());
        bundle.putInt("autoNotifyMinDistance", this.mOption.getAutoNotifyMinDistance());
        bundle.putFloat("autoNotifyLocSensitivity", this.mOption.getAutoNotifyLocSensitivity());
        return bundle;
    }

    private void onNewLocation(Message message, int n2) {
        if (!this.mIsStarted) {
            return;
        }
        try {
            message = message.getData();
            message.setClassLoader(BDLocation.class.getClassLoader());
            this.mLastLocation = (BDLocation)message.getParcelable("locStr");
            if (this.mLastLocation.getLocType() == 61) {
                this.lastReceiveGpsTime = System.currentTimeMillis();
            }
            this.callListeners(n2);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void onNewNotifyLocation(Message object) {
        try {
            object = object.getData();
            object.setClassLoader(BDLocation.class.getClassLoader());
            object = (BDLocation)object.getParcelable("locStr");
            if (this.NotifyLocationListenner != null) {
                if (this.mOption != null && this.mOption.isDisableCache() && ((BDLocation)object).getLocType() == 65) {
                    return;
                }
                this.NotifyLocationListenner.onReceiveLocation((BDLocation)object);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRegisterListener(Message object) {
        BDLocationListener bDLocationListener;
        block5: {
            block4: {
                if (object == null || object.obj == null) break block4;
                bDLocationListener = (BDLocationListener)object.obj;
                if (this.mLocationListeners == null) {
                    this.mLocationListeners = new ArrayList();
                }
                if (!this.mLocationListeners.contains(bDLocationListener)) break block5;
            }
            return;
        }
        this.mLocationListeners.add(bDLocationListener);
    }

    private void onRegisterNotify(Message object) {
        if (object == null || object.obj == null) {
            return;
        }
        object = (BDNotifyListener)object.obj;
        if (this.mNotifyCache == null) {
            this.mNotifyCache = new com.baidu.location.d.a(this.mContext, this);
        }
        this.mNotifyCache.a((BDNotifyListener)object);
    }

    private void onRegisterNotifyLocationListener(Message message) {
        if (message == null || message.obj == null) {
            return;
        }
        this.NotifyLocationListenner = (BDLocationListener)message.obj;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onRemoveNotifyEvent(Message object) {
        BDNotifyListener bDNotifyListener;
        block3: {
            block2: {
                if (object == null || object.obj == null) break block2;
                bDNotifyListener = (BDNotifyListener)object.obj;
                if (this.mNotifyCache != null) break block3;
            }
            return;
        }
        this.mNotifyCache.c(bDNotifyListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onRequestLocation() {
        Object object;
        if (this.mServer == null) {
            return;
        }
        if (!(System.currentTimeMillis() - this.lastReceiveGpsTime <= 3000L && this.mOption.location_change_notify && !this.isWaitingLocTag || this.inDoorState && System.currentTimeMillis() - this.lastReceiveLocationTime <= 20000L && !this.isWaitingLocTag)) {
            object = Message.obtain(null, (int)22);
            if (this.isWaitingLocTag) {
                Bundle bundle = new Bundle();
                bundle.putBoolean("isWaitingLocTag", this.isWaitingLocTag);
                this.isWaitingLocTag = false;
                object.setData(bundle);
            }
            try {
                object.replyTo = this.mMessenger;
                this.mServer.send(object);
                this.mLastRequestTime = System.currentTimeMillis();
                this.isWaitingForLocation = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object = this.mLock;
        synchronized (object) {
            if (this.mOption != null && this.mOption.scanSpan >= 1000 && !this.isScheduled) {
                if (this.mScheduledRequest == null) {
                    this.mScheduledRequest = new b(null);
                }
                this.mHandler.postDelayed(this.mScheduledRequest, this.mOption.scanSpan);
                this.isScheduled = true;
            }
            return;
        }
    }

    private void onRequestNotifyLocation() {
        if (this.mServer == null) {
            return;
        }
        Message message = Message.obtain(null, (int)22);
        try {
            message.replyTo = this.mMessenger;
            this.mServer.send(message);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void onRequestOffLineLocation() {
        Message message = Message.obtain(null, (int)28);
        try {
            message.replyTo = this.mMessenger;
            this.mServer.send(message);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onSetOption(Message object) {
        block17: {
            block16: {
                this.isWaitingLocTag = false;
                if (object == null || object.obj == null || this.mOption.optionEquals((LocationClientOption)(object = (LocationClientOption)object.obj))) break block16;
                if (this.mOption.scanSpan != object.scanSpan) {
                    try {
                        Object object2 = this.mLock;
                        synchronized (object2) {
                            if (!this.isScheduled) break block15;
                        }
                    }
                    catch (Exception exception) {}
                    {
                        block15: {
                            this.mHandler.removeCallbacks(this.mScheduledRequest);
                            this.isScheduled = false;
                        }
                        if (object.scanSpan >= 1000 && !this.isScheduled) {
                            if (this.mScheduledRequest == null) {
                                this.mScheduledRequest = new b(null);
                            }
                            this.mHandler.postDelayed(this.mScheduledRequest, object.scanSpan);
                            this.isScheduled = true;
                        }
                    }
                }
                this.mOption = new LocationClientOption((LocationClientOption)object);
                if (this.mServer != null) break block17;
            }
            return;
        }
        try {
            object = Message.obtain(null, (int)15);
            object.replyTo = this.mMessenger;
            object.setData(this.getOptionBundle());
            this.mServer.send(object);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onStart() {
        if (this.mIsStarted) {
            return;
        }
        if (this.firstConnected.booleanValue()) {
            new c(this).start();
            this.firstConnected = false;
        }
        this.mPackName = this.mContext.getPackageName();
        this.serviceName = this.mPackName + "_bdls_v2.9";
        Intent intent = new Intent(this.mContext, f.class);
        try {
            intent.putExtra("debug_dev", this.mDebugByDev);
        }
        catch (Exception exception) {}
        if (this.mOption == null) {
            this.mOption = new LocationClientOption();
        }
        intent.putExtra("cache_exception", this.mOption.isIgnoreCacheException);
        intent.putExtra("kill_process", this.mOption.isIgnoreKillProcess);
        try {
            this.mContext.bindService(intent, this.mConnection, 1);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.mIsStarted = false;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void onStop() {
        if (!this.mIsStarted) return;
        if (this.mServer == null) {
            return;
        }
        Object object = Message.obtain(null, (int)12);
        object.replyTo = this.mMessenger;
        try {
            this.mServer.send(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.mContext.unbindService(this.mConnection);
        }
        catch (Exception exception) {}
        object = this.mLock;
        // MONITORENTER : object
        try {
            if (this.isScheduled) {
                this.mHandler.removeCallbacks(this.mScheduledRequest);
                this.isScheduled = false;
            }
            // MONITOREXIT : object
        }
        catch (Exception exception) {}
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        if (this.mNotifyCache != null) {
            this.mNotifyCache.a();
        }
        this.mServer = null;
        this.isWaitingLocTag = false;
        this.inDoorState = false;
        this.mIsStarted = false;
        this.clientFirst = false;
        this.serverFirst = false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onUnRegisterListener(Message object) {
        BDLocationListener bDLocationListener;
        block3: {
            block2: {
                if (object == null || object.obj == null) break block2;
                bDLocationListener = (BDLocationListener)object.obj;
                if (this.mLocationListeners != null && this.mLocationListeners.contains(bDLocationListener)) break block3;
            }
            return;
        }
        this.mLocationListeners.remove(bDLocationListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendFirstLoc(BDLocation bDLocation) {
        if (!this.isStop) {
            this.mLastLocation = bDLocation;
            if (!this.serverFirst && bDLocation.getLocType() == 161) {
                this.clientFirst = true;
            }
            if (this.mLocationListeners != null) {
                Iterator<BDLocationListener> iterator = this.mLocationListeners.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onReceiveLocation(bDLocation);
                }
            }
        }
    }

    private boolean sendServerMessage(int n2) {
        if (this.mServer == null || !this.mIsStarted) {
            return false;
        }
        try {
            Message message = Message.obtain(null, (int)n2);
            this.mServer.send(message);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getAccessKey() {
        try {
            this.mKey = i.b(this.mContext);
            if (TextUtils.isEmpty((CharSequence)this.mKey)) {
                throw new IllegalStateException("please setting key from Manifest.xml");
            }
            String string2 = String.format("KEY=%s", this.mKey);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BDLocation getLastKnownLocation() {
        return this.mLastLocation;
    }

    public LocationClientOption getLocOption() {
        return this.mOption;
    }

    public String getVersion() {
        return "7.1.1";
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onReceiveLocation(BDLocation bDLocation) {
        if (this.serverFirst && !this.clientFirst || bDLocation == null) {
            return;
        }
        Message message = this.mHandler.obtainMessage(701);
        message.obj = bDLocation;
        message.sendToTarget();
    }

    public void registerLocationListener(BDLocationListener bDLocationListener) {
        if (bDLocationListener == null) {
            throw new IllegalStateException("please set a non-null listener");
        }
        Message message = this.mHandler.obtainMessage(5);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    public void registerNotify(BDNotifyListener bDNotifyListener) {
        Message message = this.mHandler.obtainMessage(9);
        message.obj = bDNotifyListener;
        message.sendToTarget();
    }

    public void registerNotifyLocationListener(BDLocationListener bDLocationListener) {
        Message message = this.mHandler.obtainMessage(8);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    public void removeNotifyEvent(BDNotifyListener bDNotifyListener) {
        Message message = this.mHandler.obtainMessage(10);
        message.obj = bDNotifyListener;
        message.sendToTarget();
    }

    public boolean requestHotSpotState() {
        if (this.mServer == null || !this.mIsStarted) {
            return false;
        }
        try {
            Message message = Message.obtain(null, (int)406);
            this.mServer.send(message);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int requestLocation() {
        if (this.mServer == null || this.mMessenger == null) {
            return 1;
        }
        if (this.mLocationListeners == null || this.mLocationListeners.size() < 1) {
            return 2;
        }
        if (System.currentTimeMillis() - this.mLastRequestTime < 1000L) {
            return 6;
        }
        this.isWaitingLocTag = true;
        Message message = this.mHandler.obtainMessage(4);
        message.arg1 = 0;
        message.sendToTarget();
        return 0;
    }

    public void requestNotifyLocation() {
        this.mHandler.obtainMessage(11).sendToTarget();
    }

    public int requestOfflineLocation() {
        if (this.mServer == null || this.mMessenger == null) {
            return 1;
        }
        if (this.mLocationListeners == null || this.mLocationListeners.size() < 1) {
            return 2;
        }
        this.mHandler.obtainMessage(12).sendToTarget();
        return 0;
    }

    public void setLocOption(LocationClientOption locationClientOption) {
        LocationClientOption locationClientOption2 = locationClientOption;
        if (locationClientOption == null) {
            locationClientOption2 = new LocationClientOption();
        }
        if (locationClientOption2.getAutoNotifyMaxInterval() > 0) {
            locationClientOption2.setScanSpan(0);
            locationClientOption2.setLocationNotify(true);
        }
        locationClientOption = this.mHandler.obtainMessage(3);
        ((Message)locationClientOption).obj = locationClientOption2;
        locationClientOption.sendToTarget();
    }

    public void start() {
        this.isStop = false;
        this.mHandler.obtainMessage(1).sendToTarget();
    }

    public boolean startIndoorMode() {
        boolean bl = this.sendServerMessage(110);
        if (bl) {
            this.inDoorState = true;
        }
        return bl;
    }

    public void stop() {
        this.isStop = true;
        this.mHandler.obtainMessage(2).sendToTarget();
        this.mloc = null;
    }

    public boolean stopIndoorMode() {
        boolean bl = this.sendServerMessage(111);
        if (bl) {
            this.inDoorState = false;
        }
        return bl;
    }

    public void unRegisterLocationListener(BDLocationListener bDLocationListener) {
        if (bDLocationListener == null) {
            throw new IllegalStateException("please set a non-null listener");
        }
        Message message = this.mHandler.obtainMessage(6);
        message.obj = bDLocationListener;
        message.sendToTarget();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean updateLocation(Location location) {
        if (this.mServer == null || this.mMessenger == null || location == null) {
            return false;
        }
        try {
            Message message = Message.obtain(null, (int)57);
            message.obj = location;
            this.mServer.send(message);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return true;
        }
    }

    private class a
    extends Handler {
        a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        public void handleMessage(Message object) {
            Object object2;
            block27: {
                switch (object.what) {
                    default: {
                        super.handleMessage(object);
                    }
                    case 7: {
                        return;
                    }
                    case 3: {
                        LocationClient.this.onSetOption(object);
                        return;
                    }
                    case 8: {
                        LocationClient.this.onRegisterNotifyLocationListener(object);
                        return;
                    }
                    case 5: {
                        LocationClient.this.onRegisterListener(object);
                        return;
                    }
                    case 6: {
                        LocationClient.this.onUnRegisterListener(object);
                        return;
                    }
                    case 9: {
                        LocationClient.this.onRegisterNotify(object);
                        return;
                    }
                    case 10: {
                        LocationClient.this.onRemoveNotifyEvent(object);
                        return;
                    }
                    case 1: {
                        LocationClient.this.onStart();
                        return;
                    }
                    case 2: {
                        LocationClient.this.onStop();
                        return;
                    }
                    case 11: {
                        LocationClient.this.onRequestNotifyLocation();
                        return;
                    }
                    case 4: {
                        LocationClient.this.onRequestLocation();
                        return;
                    }
                    case 12: {
                        LocationClient.this.onRequestOffLineLocation();
                        return;
                    }
                    case 54: {
                        if (!((LocationClient)LocationClient.this).mOption.location_change_notify) return;
                        LocationClient.access$2702(LocationClient.this, true);
                        return;
                    }
                    case 55: {
                        if (!((LocationClient)LocationClient.this).mOption.location_change_notify) return;
                        LocationClient.access$2702(LocationClient.this, false);
                        return;
                    }
                    case 21: {
                        Object object3 = object.getData();
                        object3.setClassLoader(BDLocation.class.getClassLoader());
                        object3 = (BDLocation)object3.getParcelable("locStr");
                        if (!LocationClient.this.serverFirst && LocationClient.this.clientFirst) {
                            if (((BDLocation)object3).getLocType() == 66) return;
                        }
                        if (!LocationClient.this.serverFirst && LocationClient.this.clientFirst) {
                            LocationClient.access$2802(LocationClient.this, true);
                            return;
                        }
                        if (!LocationClient.this.serverFirst) {
                            LocationClient.access$2802(LocationClient.this, true);
                        }
                        LocationClient.this.onNewLocation(object, 21);
                        return;
                    }
                    case 26: {
                        LocationClient.this.onNewLocation(object, 26);
                        return;
                    }
                    case 27: {
                        LocationClient.this.onNewNotifyLocation(object);
                        return;
                    }
                    case 406: {
                        try {
                            object2 = object.getData();
                            byte[] byArray = object2.getByteArray("mac");
                            if (byArray == null) break;
                            String string2 = new String(byArray, "UTF-8");
                            break block27;
                        }
                        catch (Exception exception) {
                            return;
                        }
                    }
                    case 701: {
                        LocationClient.this.sendFirstLoc((BDLocation)object.obj);
                        return;
                    }
                }
                Object var1_6 = null;
            }
            int n2 = object2.getInt("hotspot", -1);
            if (LocationClient.this.mLocationListeners == null) return;
            object2 = LocationClient.this.mLocationListeners.iterator();
            while (object2.hasNext()) {
                void var1_4;
                ((BDLocationListener)object2.next()).onConnectHotSpotMessage((String)var1_4, n2);
            }
        }
    }

    private class b
    implements Runnable {
        private b() {
        }

        /* synthetic */ b(com.baidu.location.b b2) {
            this();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            Object object = LocationClient.this.mLock;
            synchronized (object) {
                LocationClient.access$1202(LocationClient.this, false);
                if (LocationClient.this.mServer == null || LocationClient.this.mMessenger == null) {
                    return;
                }
                if (LocationClient.this.mLocationListeners == null || LocationClient.this.mLocationListeners.size() < 1) {
                    return;
                }
                if (!LocationClient.this.isWaitingLocTag) {
                    LocationClient.this.mHandler.obtainMessage(4).sendToTarget();
                    return;
                }
                if (LocationClient.this.mScheduledRequest == null) {
                    LocationClient.access$1502(LocationClient.this, new b());
                }
                LocationClient.this.mHandler.postDelayed(LocationClient.this.mScheduledRequest, ((LocationClient)LocationClient.this).mOption.scanSpan);
                return;
            }
        }
    }
}

