/*
 * Decompiled with CFR 0.152.
 */
package com.android.dingtalk.share.ddsharemodule.message;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class DDMediaMessage {
    private static final int MAX_CONTENT_LENGTH = 1024;
    private static final int MAX_THUMB_DATA_LENGTH = 32768;
    private static final int MAX_TITLE_LENGTH = 512;
    private static final String TAG = "DDMediaMessage";
    public String mContent;
    public IMediaObject mMediaObject;
    public int mSDKVersion;
    public byte[] mThumbData;
    public String mThumbUrl;
    public String mTitle;
    public String mUrl;

    public DDMediaMessage() {
        this(null);
    }

    public DDMediaMessage(IMediaObject iMediaObject) {
        this.mMediaObject = iMediaObject;
    }

    public final boolean checkArgs() {
        if (this.mThumbData != null && this.mThumbData.length > 32768) {
            Log.e((String)TAG, (String)"checkArgs fail, thumbData is invalid");
            return false;
        }
        if (this.mTitle != null && this.mTitle.length() > 512) {
            Log.e((String)TAG, (String)"checkArgs fail, title is invalid");
            return false;
        }
        if (this.mContent != null && this.mContent.length() > 1024) {
            Log.e((String)TAG, (String)"checkArgs fail, content is invalid");
            return false;
        }
        if (this.mMediaObject == null) {
            Log.e((String)TAG, (String)"checkArgs fail, mediaObject is null");
            return false;
        }
        return this.mMediaObject.checkArgs();
    }

    public final int getType() {
        if (this.mMediaObject == null) {
            return 0;
        }
        return this.mMediaObject.type();
    }

    public final void setThumbImage(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.mThumbData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public static class Builder {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static DDMediaMessage fromBundle(Bundle bundle) {
            DDMediaMessage dDMediaMessage = new DDMediaMessage();
            dDMediaMessage.mSDKVersion = bundle.getInt("android.intent.ding.EXTRA_AP_OBJECT_SDK_VERSION");
            dDMediaMessage.mTitle = bundle.getString("android.intent.ding.EXTRA_AP_OBJECT_TITLE");
            dDMediaMessage.mContent = bundle.getString("android.intent.ding.EXTRA_AP_OBJECT_DESCRIPTION");
            dDMediaMessage.mThumbData = bundle.getByteArray("android.intent.ding.EXTRA_AP_OBJECT_THUMB_DATA");
            dDMediaMessage.mThumbUrl = bundle.getString("android.intent.ding.EXTRA_AP_OBJECT_THUMB_URL");
            String string2 = bundle.getString("android.intent.ding.EXTRA_AP_OBJECT_IDENTIFIER");
            if (string2 == null || string2.length() <= 0) return dDMediaMessage;
            try {
                dDMediaMessage.mMediaObject = (IMediaObject)Class.forName(string2).newInstance();
                dDMediaMessage.mMediaObject.unserialize(bundle);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.e((String)DDMediaMessage.TAG, (String)("get media object from bundle failed: unknown ident " + string2));
                return dDMediaMessage;
            }
            return dDMediaMessage;
        }

        public static Bundle toBundle(DDMediaMessage dDMediaMessage) {
            Bundle bundle = new Bundle();
            bundle.putInt("android.intent.ding.EXTRA_AP_OBJECT_SDK_VERSION", dDMediaMessage.mSDKVersion);
            bundle.putString("android.intent.ding.EXTRA_AP_OBJECT_TITLE", dDMediaMessage.mTitle);
            bundle.putString("android.intent.ding.EXTRA_AP_OBJECT_DESCRIPTION", dDMediaMessage.mContent);
            bundle.putByteArray("android.intent.ding.EXTRA_AP_OBJECT_THUMB_DATA", dDMediaMessage.mThumbData);
            bundle.putString("android.intent.ding.EXTRA_AP_OBJECT_THUMB_URL", dDMediaMessage.mThumbUrl);
            if (dDMediaMessage.mMediaObject != null) {
                bundle.putString("android.intent.ding.EXTRA_AP_OBJECT_IDENTIFIER", dDMediaMessage.mMediaObject.getClass().getName());
                dDMediaMessage.mMediaObject.serialize(bundle);
            }
            return bundle;
        }
    }

    public static interface IMediaObject {
        public static final int TYPE_IMAGE = 3;
        public static final int TYPE_TEXT = 2;
        public static final int TYPE_WEBPAGE = 1;
        public static final int TYPE_ZHIFUBAO = 0;

        public boolean checkArgs();

        public void serialize(Bundle var1);

        public int type();

        public void unserialize(Bundle var1);
    }
}

