/*
 * Decompiled with CFR 0.152.
 */
package com.android.dingtalk.share.ddsharemodule.message;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.android.dingtalk.share.ddsharemodule.message.DDMediaMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class DDImageMessage
implements DDMediaMessage.IMediaObject {
    private static final int MAX_IMAGE_DATA_LENGTH = 0xA00000;
    private static final int MAX_IMAGE_THUMB_DATA_LENGTH = 32768;
    private static final int MAX_IMAGE_URL_LENGTH = 10240;
    private static final String TAG = "DDImageMessage";
    public byte[] mImageData;
    public String mImagePath;
    public String mImageUrl;

    public DDImageMessage() {
    }

    public DDImageMessage(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.mImageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public DDImageMessage(byte[] byArray) {
        this.mImageData = byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean checkArgs() {
        if (this.mImageData != null && this.mImageData.length != 0 || this.mImagePath != null && this.mImagePath.length() != 0 || this.mImageUrl != null && this.mImageUrl.length() != 0) {
            if (this.mImageData != null && this.mImageData.length > 0xA00000) {
                Log.e((String)TAG, (String)"checkArgs fail, content is too large");
                return false;
            }
            if (this.mImagePath != null && this.mImagePath.length() > 10240) {
                Log.e((String)TAG, (String)"checkArgs fail, path is invalid");
                return false;
            }
            if (this.mImagePath != null) {
                Object object = this.mImagePath;
                int n2 = this.mImagePath != null && ((String)object).length() != 0 ? (!((File)(object = new File((String)object))).exists() ? 0 : (int)((File)object).length()) : 0;
                if (n2 > 0xA00000) {
                    Log.e((String)TAG, (String)"checkArgs fail, image content is too large");
                    return false;
                }
            }
            if (this.mImageUrl != null && this.mImageUrl.length() > 10240) {
                Log.e((String)TAG, (String)"checkArgs fail, url is invalid");
                return false;
            }
            return true;
        }
        Log.e((String)TAG, (String)"checkArgs fail, all arguments are null");
        return false;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray("android.intent.ding.EXTRA_IMAGE_OBJECT_IMAGE_DATA", this.mImageData);
        bundle.putString("android.intent.ding.EXTRA_IMAGE_OBJECT_IMAGE_PATH", this.mImagePath);
        bundle.putString("android.intent.ding.EXTRA_IMAGE_OBJECT_IMAGE_URL", this.mImageUrl);
    }

    @Override
    public int type() {
        return 3;
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.mImageData = bundle.getByteArray("android.intent.ding.EXTRA_IMAGE_OBJECT_IMAGE_DATA");
        this.mImagePath = bundle.getString("android.intent.ding.EXTRA_IMAGE_OBJECT_IMAGE_PATH");
        this.mImageUrl = bundle.getString("android.intent.ding.EXTRA_IMAGE_OBJECT_IMAGE_URL");
    }
}

