/*
 * Decompiled with CFR 0.152.
 */
package com.android.dingtalk.share.ddsharemodule;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.android.dingtalk.share.ddsharemodule.IDDAPIEventHandler;
import com.android.dingtalk.share.ddsharemodule.IDDShareApi;
import com.android.dingtalk.share.ddsharemodule.ShareConstant;
import com.android.dingtalk.share.ddsharemodule.message.BaseReq;
import com.android.dingtalk.share.ddsharemodule.message.DDMessage;
import com.android.dingtalk.share.ddsharemodule.message.DDMessageAct;
import com.android.dingtalk.share.ddsharemodule.message.SendMessageToDD;
import com.android.dingtalk.share.ddsharemodule.plugin.DDVersionCheck;
import com.android.dingtalk.share.ddsharemodule.plugin.SignatureCheck;

public class DDShareApi
implements IDDShareApi {
    private static final String TAG = "DDShareApi";
    private String mAppId;
    private Context mContext;
    private boolean mNeedSignatureCheck;

    public DDShareApi(Context context, String string2) {
        this(context, string2, false);
    }

    public DDShareApi(Context context, String string2, boolean bl) {
        this.mContext = context;
        this.mAppId = string2;
        this.mNeedSignatureCheck = bl;
    }

    private boolean checkSumConsistent(String string2) {
        if (!this.mNeedSignatureCheck) {
            Log.d((String)TAG, (String)"ignore dd app signature validation");
            return true;
        }
        return TextUtils.equals((CharSequence)SignatureCheck.getMD5Signature(this.mContext, string2), (CharSequence)"d2cef93010963d9273440efe6a05dd8d");
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray.length != 0 && byArray2 != null && byArray2.length != 0) {
            if (byArray.length != byArray2.length) {
                Log.e((String)TAG, (String)"checkSumConsistent fail, length is different");
                return false;
            } else {
                int n2 = 0;
                while (true) {
                    if (n2 >= byArray.length) {
                        return true;
                    }
                    if (byArray[n2] != byArray2[n2]) return false;
                    ++n2;
                }
            }
        }
        Log.e((String)TAG, (String)"checkSumConsistent fail, invalid arguments");
        return false;
    }

    @Override
    public int getDDSupportAPI() {
        if (!this.isDDAppInstalled()) {
            Log.e((String)TAG, (String)"open dd app failed, not installed or signature check failed");
            return 0;
        }
        return DDVersionCheck.getSdkVersionFromMetaData(this.mContext, 0);
    }

    @Override
    public boolean handleIntent(Intent intent, IDDAPIEventHandler iDDAPIEventHandler) {
        String string2 = intent.getStringExtra("android.intent.ding.EXTRA_MESSAGE_APP_PACKAGE_NAME");
        if (string2 != null && string2.length() != 0 && iDDAPIEventHandler != null) {
            switch (intent.getIntExtra("android.intent.ding.EXTRA_COMMAND_TYPE", 0)) {
                default: {
                    return false;
                }
                case 1: {
                    iDDAPIEventHandler.onResp(new SendMessageToDD.Resp(intent.getExtras()));
                    return true;
                }
                case 2: {
                    iDDAPIEventHandler.onResp(new SendMessageToDD.Resp(intent.getExtras()));
                    return true;
                }
                case 3: {
                    iDDAPIEventHandler.onReq(new SendMessageToDD.Req(intent.getExtras()));
                    return true;
                }
                case 4: 
            }
            iDDAPIEventHandler.onReq(new SendMessageToDD.Req(intent.getExtras()));
            return true;
        }
        Log.e((String)"TAG", (String)"invalid argument");
        return false;
    }

    @Override
    public boolean isDDAppInstalled() {
        boolean bl;
        boolean bl2 = bl = false;
        try {
            if (this.mContext.getPackageManager().getPackageInfo("com.alibaba.android.rimet", 64) != null) {
                boolean bl3 = this.checkSumConsistent("com.alibaba.android.rimet");
                bl2 = bl;
                if (bl3) {
                    bl2 = true;
                }
            }
            return bl2;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    @Override
    public boolean isDDSupportAPI() {
        return this.getDDSupportAPI() > 20151125;
    }

    @Override
    public boolean isDDSupportDingAPI() {
        return this.getDDSupportAPI() > 20160214;
    }

    @Override
    public boolean openDDApp() {
        if (!this.isDDAppInstalled()) {
            Log.e((String)TAG, (String)"open dd app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.mContext.startActivity(this.mContext.getPackageManager().getLaunchIntentForPackage("com.alibaba.android.rimet"));
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("start dd Main Activity fail, exception = " + exception.getMessage()));
            return false;
        }
    }

    @Override
    public boolean registerApp(String string2) {
        if (!this.checkSumConsistent("com.alibaba.android.rimet")) {
            Log.e((String)TAG, (String)"register app failed for alipay app signature check failed");
            return false;
        }
        if (string2 != null) {
            this.mAppId = string2;
        }
        Log.d((String)TAG, (String)("register app " + this.mContext.getPackageName()));
        DDMessage.send(this.mContext, "com.alibaba.android.rimet", ShareConstant.PERMISSION_ACTION_HANDLE_APP_REGISTER, ShareConstant.ACTION_APP_REGISTER + string2);
        return true;
    }

    @Override
    public boolean sendReq(BaseReq baseReq) {
        if (!this.checkSumConsistent("com.alibaba.android.rimet")) {
            Log.e((String)TAG, (String)"sendReq failed for dd app signature check failed");
            return false;
        }
        if (!baseReq.checkArgs()) {
            Log.e((String)TAG, (String)"sendReq checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        baseReq.toBundle(bundle);
        return DDMessageAct.sendDDFriend(this.mContext, this.mAppId, bundle);
    }

    @Override
    public boolean sendReqToDing(BaseReq baseReq) {
        if (!this.checkSumConsistent("com.alibaba.android.rimet")) {
            Log.e((String)TAG, (String)"sendReq failed for dd app signature check failed");
            return false;
        }
        if (!baseReq.checkArgs()) {
            Log.e((String)TAG, (String)"sendReq checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        baseReq.toBundle(bundle);
        return DDMessageAct.sendDing(this.mContext, this.mAppId, bundle);
    }

    @Override
    public void unregisterApp() {
        if (!this.checkSumConsistent("com.alibaba.android.rimet")) {
            Log.e((String)TAG, (String)"unregister app failed for dd app signature check failed");
            return;
        }
        if (this.mAppId != null && this.mAppId.length() != 0) {
            Log.d((String)TAG, (String)("unregister app " + this.mContext.getPackageName()));
            DDMessage.send(this.mContext, "com.alibaba.android.rimet", ShareConstant.PERMISSION_ACTION_HANDLE_APP_UNREGISTER, ShareConstant.ACTION_APP_UNREGISTER + this.mAppId);
            return;
        }
        Log.e((String)TAG, (String)"unregisterApp fail, appId is empty");
    }
}

