/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public class APMediaMessage {
    private static final String TAG = "APSDK.ZFBMediaMessage";
    public String description;
    public IMediaObject mediaObject;
    public int sdkVer;
    public byte[] thumbData;
    public String thumbUrl;
    public String title;

    public APMediaMessage() {
        this(null);
    }

    public APMediaMessage(IMediaObject iMediaObject) {
        this.mediaObject = iMediaObject;
    }

    final boolean checkArgs() {
        if (this.thumbData != null && this.thumbData.length > 32768) {
            Log.e((String)TAG, (String)"checkArgs fail, thumbData is invalid");
            return false;
        }
        if (this.title != null && this.title.length() > 512) {
            Log.e((String)TAG, (String)"checkArgs fail, title is invalid");
            return false;
        }
        if (this.description != null && this.description.length() > 1024) {
            Log.e((String)TAG, (String)"checkArgs fail, description is invalid");
            return false;
        }
        if (this.mediaObject == null) {
            Log.e((String)TAG, (String)"checkArgs fail, mediaObject is null");
            return false;
        }
        return this.mediaObject.checkArgs();
    }

    public final int getType() {
        if (this.mediaObject == null) {
            return 0;
        }
        return this.mediaObject.type();
    }

    public final void setThumbImage(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.thumbData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"put thumb failed");
            return;
        }
    }

    public static class Builder {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static APMediaMessage fromBundle(Bundle bundle) {
            APMediaMessage aPMediaMessage = new APMediaMessage();
            aPMediaMessage.sdkVer = bundle.getInt(Constant.EXTRA_AP_OBJECT_SDK_VERSION);
            aPMediaMessage.title = bundle.getString(Constant.EXTRA_AP_OBJECT_TITLE);
            aPMediaMessage.description = bundle.getString(Constant.EXTRA_AP_OBJECT_DESCRIPTION);
            aPMediaMessage.thumbData = bundle.getByteArray(Constant.EXTRA_AP_OBJECT_THUMB_DATA);
            aPMediaMessage.thumbUrl = bundle.getString(Constant.EXTRA_AP_OBJECT_THUMB_URL);
            String string2 = bundle.getString(Constant.EXTRA_AP_OBJECT_IDENTIFIER);
            if (string2 == null || string2.length() <= 0) return aPMediaMessage;
            try {
                aPMediaMessage.mediaObject = (IMediaObject)Class.forName(string2).newInstance();
                aPMediaMessage.mediaObject.unserialize(bundle);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Log.e((String)APMediaMessage.TAG, (String)("get media object from bundle failed: unknown ident " + string2));
                return aPMediaMessage;
            }
            return aPMediaMessage;
        }

        public static Bundle toBundle(APMediaMessage aPMediaMessage) {
            Bundle bundle = new Bundle();
            bundle.putInt(Constant.EXTRA_AP_OBJECT_SDK_VERSION, aPMediaMessage.sdkVer);
            bundle.putString(Constant.EXTRA_AP_OBJECT_TITLE, aPMediaMessage.title);
            bundle.putString(Constant.EXTRA_AP_OBJECT_DESCRIPTION, aPMediaMessage.description);
            bundle.putByteArray(Constant.EXTRA_AP_OBJECT_THUMB_DATA, aPMediaMessage.thumbData);
            bundle.putString(Constant.EXTRA_AP_OBJECT_THUMB_URL, aPMediaMessage.thumbUrl);
            if (aPMediaMessage.mediaObject != null) {
                bundle.putString(Constant.EXTRA_AP_OBJECT_IDENTIFIER, aPMediaMessage.mediaObject.getClass().getSimpleName());
                aPMediaMessage.mediaObject.serialize(bundle);
            }
            return bundle;
        }
    }

    public static interface IMediaObject {
        public static final int TYPE_FUND = 122;
        public static final int TYPE_IMAGE = 14;
        public static final int TYPE_STOCK = 120;
        public static final int TYPE_TAOBAO_GOODS = 1010;
        public static final int TYPE_TEXT = 11;
        public static final int TYPE_UNKNOWN = 0;
        public static final int TYPE_URL = 1001;

        public boolean checkArgs();

        public void serialize(Bundle var1);

        public int type();

        public void unserialize(Bundle var1);
    }
}

