/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import com.alipay.share.sdk.openapi.APMediaMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class APImageObject
implements APMediaMessage.IMediaObject {
    private static final String TAG = "APSDK.ZFBImageObject";
    public byte[] imageData;
    public String imagePath;
    public String imageUrl;

    public APImageObject() {
    }

    public APImageObject(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public APImageObject(byte[] byArray) {
        this.imageData = byArray;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean checkArgs() {
        if (!(this.imageData != null && this.imageData.length != 0 || this.imagePath != null && this.imagePath.length() != 0 || this.imageUrl != null && this.imageUrl.length() != 0)) {
            Log.e((String)TAG, (String)"checkArgs fail, all arguments are null");
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0xA00000) {
            Log.e((String)TAG, (String)"checkArgs fail, content is too large");
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 10240) {
            Log.e((String)TAG, (String)"checkArgs fail, path is invalid");
            return false;
        }
        if (this.imagePath != null) {
            Object object = this.imagePath;
            int n2 = this.imagePath != null && ((String)object).length() != 0 ? (!((File)(object = new File((String)object))).exists() ? 0 : (int)((File)object).length()) : 0;
            if (n2 > 0xA00000) {
                Log.e((String)TAG, (String)"checkArgs fail, image content is too large");
                return false;
            }
        }
        if (this.imageUrl != null && this.imageUrl.length() > 10240) {
            Log.e((String)TAG, (String)"checkArgs fail, url is invalid");
            return false;
        }
        return true;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray(Constant.EXTRA_IMAGE_OBJECT_IMAGE_DATA, this.imageData);
        bundle.putString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_PATH, this.imagePath);
        bundle.putString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_URL, this.imageUrl);
    }

    public void setImagePath(String string2) {
        this.imagePath = string2;
    }

    @Override
    public int type() {
        return 14;
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.imageData = bundle.getByteArray(Constant.EXTRA_IMAGE_OBJECT_IMAGE_DATA);
        this.imagePath = bundle.getString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_PATH);
        this.imageUrl = bundle.getString(Constant.EXTRA_IMAGE_OBJECT_IMAGE_URL);
    }
}

