/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.share.sdk.openapi;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import android.util.Log;
import com.alipay.share.sdk.Constant;
import com.alipay.share.sdk.openapi.BaseReq;
import com.alipay.share.sdk.openapi.IAPAPIEventHandler;
import com.alipay.share.sdk.openapi.IAPApi;
import com.alipay.share.sdk.openapi.SendMessageToZFB;
import com.alipay.share.sdk.openapi.algorithm.MD5;
import com.alipay.share.sdk.openapi.channel.APMessageAct;
import com.alipay.share.sdk.plugin.APVersionCheck;

public class APApiImlV1
implements IAPApi {
    private static final String TAG = "APSDK.ZFBApiImlV1";
    private String appId;
    private Context context;
    private boolean needSignatureCheck;

    public APApiImlV1(Context context, String string2) {
        this(context, string2, false);
    }

    public APApiImlV1(Context context, String string2, boolean bl) {
        this.context = context;
        this.appId = string2;
        this.needSignatureCheck = bl;
    }

    private boolean checkSumConsistent(String string2) {
        if (!this.needSignatureCheck) {
            Log.d((String)TAG, (String)"ignore alipay app signature validation");
            return true;
        }
        try {
            string2 = this.context.getPackageManager().getPackageInfo(string2, 64);
            return this.checkSumConsistent(((PackageInfo)string2).signatures);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private static boolean checkSumConsistent(byte[] byArray, byte[] byArray2) {
        if (byArray != null && byArray.length != 0 && byArray2 != null && byArray2.length != 0) {
            if (byArray.length != byArray2.length) {
                Log.e((String)TAG, (String)"checkSumConsistent fail, length is different");
                return false;
            }
        } else {
            Log.e((String)TAG, (String)"checkSumConsistent fail, invalid arguments");
            return false;
        }
        int n2 = 0;
        while (n2 < byArray.length) {
            if (byArray[n2] != byArray2[n2]) return false;
            ++n2;
        }
        return true;
    }

    private boolean checkSumConsistent(Signature[] signatureArray) {
        if (!this.needSignatureCheck) {
            Log.d((String)TAG, (String)"ignore alipay app signature validation");
            return true;
        }
        int n2 = signatureArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = signatureArray[n3].toCharsString();
            Log.d((String)TAG, (String)("check signature:" + string2));
            if (string2.equals("30820244308201ad02044b28a3c9300d06092a864886f70d01010405003068310b300906035504061302636e3110300e060355040813076265696a696e673110300e060355040713076265696a696e67310f300d060355040a1306616c69706179310f300d060355040b1306616c69706179311330110603550403130a73686971756e2e7368693020170d3039313231363039303932395a180f32303531303131303039303932395a3068310b300906035504061302636e3110300e060355040813076265696a696e673110300e060355040713076265696a696e67310f300d060355040a1306616c69706179310f300d060355040b1306616c69706179311330110603550403130a73686971756e2e73686930819f300d06092a864886f70d010101050003818d0030818902818100b6cbad6cbd5ed0d209afc69ad3b7a617efaae9b3c47eabe0be42d924936fa78c8001b1fd74b079e5ff9690061dacfa4768e981a526b9ca77156ca36251cf2f906d105481374998a7e6e6e18f75ca98b8ed2eaf86ff402c874cca0a263053f22237858206867d210020daa38c48b20cc9dfd82b44a51aeb5db459b22794e2d6490203010001300d06092a864886f70d010104050003818100b6b5e3854b2d5daaa02d127195d13a1927991176047982feaa3d1625740788296443e9000fe14dfe6701d7e86be06b9282e68d4eff32b19d48555b8a0838a6e146238f048aca986715d7eab0fb445796bbd19360a7721b8d99ba04581af957a290c47302055f813862f3c40b840e95898e72a1de03b6257a1acad4b482cd815c")) {
                Log.d((String)TAG, (String)"checkSumConsistent pass");
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public int getZFBVersionCode() {
        return new APVersionCheck(this.context).getZFBAppVersionCode();
    }

    @Override
    public final boolean handleIntent(Intent intent, IAPAPIEventHandler iAPAPIEventHandler) {
        String string2 = intent.getStringExtra(Constant.EXTRA_MESSAGE_CONTENT);
        int n2 = intent.getIntExtra(Constant.EXTRA_MESSAGE_SDK_VERSION, 0);
        String string3 = intent.getStringExtra(Constant.EXTRA_MESSAGE_APP_PACKAGE_NAME);
        if (string3 != null && string3.length() != 0) {
            byte[] byArray = intent.getByteArrayExtra(Constant.EXTRA_MESSAGE_CHECK_SUM);
            StringBuffer stringBuffer = new StringBuffer();
            if (string2 != null) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(n2);
            stringBuffer.append(string3);
            stringBuffer.append("alipay");
            if (!APApiImlV1.checkSumConsistent(byArray, MD5.getMessageDigest(stringBuffer.toString().substring(1, 9).getBytes()).getBytes())) {
                Log.e((String)TAG, (String)"checksum fail");
                return false;
            }
            switch (intent.getIntExtra(Constant.EXTRA_COMMAND_TYPE, 0)) {
                default: {
                    return false;
                }
                case 1: {
                    iAPAPIEventHandler.onResp(new SendMessageToZFB.Resp(intent.getExtras()));
                    return true;
                }
                case 2: {
                    iAPAPIEventHandler.onResp(new SendMessageToZFB.Resp(intent.getExtras()));
                    return true;
                }
                case 3: {
                    iAPAPIEventHandler.onReq(new SendMessageToZFB.Req(intent.getExtras()));
                    return true;
                }
                case 4: 
            }
            iAPAPIEventHandler.onReq(new SendMessageToZFB.Req(intent.getExtras()));
            return true;
        }
        Log.e((String)TAG, (String)"invalid argument");
        return false;
    }

    @Override
    public boolean isZFBAppInstalled() {
        boolean bl;
        block3: {
            PackageInfo packageInfo;
            boolean bl2 = false;
            try {
                packageInfo = this.context.getPackageManager().getPackageInfo("com.eg.android.AlipayGphone", 64);
                bl = bl2;
                if (packageInfo == null) break block3;
            }
            catch (Exception exception) {
                return false;
            }
            boolean bl3 = this.checkSumConsistent(packageInfo.signatures);
            bl = bl2;
            if (!bl3) break block3;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isZFBSupportAPI() {
        return this.getZFBVersionCode() >= 77;
    }

    @Override
    public boolean openZFBApp() {
        if (!this.isZFBAppInstalled()) {
            Log.e((String)TAG, (String)"open Alipay app failed, not installed or signature check failed");
            return false;
        }
        try {
            this.context.startActivity(this.context.getPackageManager().getLaunchIntentForPackage("com.eg.android.AlipayGphone"));
            return true;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)("start Alipay Main Activity fail, exception = " + exception.getMessage()));
            return false;
        }
    }

    @Override
    public boolean sendReq(BaseReq baseReq) {
        if (!this.checkSumConsistent("com.eg.android.AlipayGphone")) {
            Log.e((String)TAG, (String)"sendReq failed for alipay app signature check failed");
            return false;
        }
        if (!baseReq.checkArgs()) {
            Log.e((String)TAG, (String)"sendReq checkArgs fail");
            return false;
        }
        Bundle bundle = new Bundle();
        baseReq.toBundle(bundle);
        return APMessageAct.sendToZFB(this.context, String.valueOf(Constant.SEND_REQUEST_CONTENT_APPID) + this.appId, bundle);
    }
}

