/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.wechat.utils;

import android.graphics.Bitmap;
import android.os.Bundle;
import cn.sharesdk.framework.utils.d;
import cn.sharesdk.wechat.utils.WXMediaMessage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;

public class WXImageObject
implements WXMediaMessage.IMediaObject {
    public byte[] imageData;
    public String imagePath;
    public String imageUrl;

    public WXImageObject() {
    }

    public WXImageObject(Bitmap bitmap) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, 85, (OutputStream)byteArrayOutputStream);
            this.imageData = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            d.a().w(exception);
            return;
        }
    }

    public WXImageObject(byte[] byArray) {
        this.imageData = byArray;
    }

    @Override
    public boolean checkArgs() {
        if (!(this.imageData != null && this.imageData.length != 0 || this.imagePath != null && this.imagePath.length() != 0 || this.imageUrl != null && this.imageUrl.length() != 0)) {
            d.a().w("checkArgs fail, all arguments are null", new Object[0]);
            return false;
        }
        if (this.imageData != null && this.imageData.length > 0xA00000) {
            d.a().w("checkArgs fail, content is too large", new Object[0]);
            return false;
        }
        if (this.imagePath != null && this.imagePath.length() > 10240) {
            d.a().w("checkArgs fail, path is invalid", new Object[0]);
            return false;
        }
        if (this.imagePath != null && new File(this.imagePath).length() > 0xA00000L) {
            d.a().w("checkArgs fail, image content is too large", new Object[0]);
            return false;
        }
        if (this.imageUrl != null && this.imageUrl.length() > 10240) {
            d.a().w("checkArgs fail, url is invalid", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wximageobject_imageData", this.imageData);
        bundle.putString("_wximageobject_imagePath", this.imagePath);
        bundle.putString("_wximageobject_imageUrl", this.imageUrl);
    }

    @Override
    public int type() {
        return 2;
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.imageData = bundle.getByteArray("_wximageobject_imageData");
        this.imagePath = bundle.getString("_wximageobject_imagePath");
        this.imageUrl = bundle.getString("_wximageobject_imageUrl");
    }
}

