/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.wechat.utils;

import android.os.Bundle;
import android.text.TextUtils;
import cn.sharesdk.framework.utils.d;
import cn.sharesdk.wechat.utils.WXMediaMessage;
import java.io.File;

public class WXEmojiObject
implements WXMediaMessage.IMediaObject {
    public byte[] emojiData;
    public String emojiPath;

    public WXEmojiObject() {
    }

    public WXEmojiObject(String string2) {
        this.emojiPath = string2;
    }

    public WXEmojiObject(byte[] byArray) {
        this.emojiData = byArray;
    }

    @Override
    public boolean checkArgs() {
        if ((this.emojiData == null || this.emojiData.length == 0) && TextUtils.isEmpty((CharSequence)this.emojiPath)) {
            d.a().w("MicroMsg.SDK.WXEmojiObject", "checkArgs fail, both arguments is null");
            return false;
        }
        if (this.emojiData != null && this.emojiData.length > 0xA00000) {
            d.a().w("MicroMsg.SDK.WXEmojiObject", "checkArgs fail, emojiData is too large");
            return false;
        }
        if (this.emojiPath != null) {
            File file = new File(this.emojiPath);
            if (!file.exists()) {
                d.a().w("MicroMsg.SDK.WXEmojiObject", "checkArgs fail, emojiPath not found");
                return false;
            }
            if (file.length() > 0xA00000L) {
                d.a().w("MicroMsg.SDK.WXEmojiObject", "checkArgs fail, emojiSize is too large");
                return false;
            }
        }
        return true;
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putByteArray("_wxemojiobject_emojiData", this.emojiData);
        bundle.putString("_wxemojiobject_emojiPath", this.emojiPath);
    }

    public void setEmojiData(byte[] byArray) {
        this.emojiData = byArray;
    }

    public void setEmojiPath(String string2) {
        this.emojiPath = string2;
    }

    @Override
    public int type() {
        return 8;
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.emojiData = bundle.getByteArray("_wxemojiobject_emojiData");
        this.emojiPath = bundle.getString("_wxemojiobject_emojiPath");
    }
}

