/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare;

import android.app.Activity;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.view.View;
import android.widget.ImageView;
import android.widget.Toast;
import cn.sharesdk.framework.utils.ShareSDKR;
import com.mob.tools.FakeActivity;

public class Shake2Share
extends FakeActivity
implements SensorEventListener {
    private static final int SHAKE_THRESHOLD = 1500;
    private static final int UPDATE_INTERVAL = 100;
    private OnShakeListener listener;
    private long mLastUpdateTime;
    private float mLastX;
    private float mLastY;
    private float mLastZ;
    private SensorManager mSensorManager;
    private boolean shaken;

    private void startSensor() {
        this.mSensorManager = (SensorManager)this.activity.getSystemService("sensor");
        if (this.mSensorManager == null) {
            throw new UnsupportedOperationException();
        }
        Sensor sensor = this.mSensorManager.getDefaultSensor(1);
        if (sensor == null) {
            throw new UnsupportedOperationException();
        }
        if (!this.mSensorManager.registerListener((SensorEventListener)this, sensor, 1)) {
            throw new UnsupportedOperationException();
        }
    }

    private void stopSensor() {
        if (this.mSensorManager != null) {
            this.mSensorManager.unregisterListener((SensorEventListener)this);
            this.mSensorManager = null;
        }
    }

    public void onAccuracyChanged(Sensor sensor, int n2) {
    }

    @Override
    public void onCreate() {
        this.startSensor();
        int n2 = ShareSDKR.getBitmapRes((Context)this.activity, "ssdk_oks_yaoyiyao");
        if (n2 > 0) {
            ImageView imageView = new ImageView((Context)this.activity);
            imageView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            imageView.setImageResource(n2);
            this.activity.setContentView((View)imageView);
        }
        if ((n2 = ShareSDKR.getStringRes((Context)this.activity, "ssdk_oks_shake2share")) > 0) {
            Toast.makeText((Context)this.activity, (int)n2, (int)0).show();
        }
    }

    @Override
    public void onDestroy() {
        this.stopSensor();
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.mLastUpdateTime;
        if (l3 > 100L) {
            if (this.mLastUpdateTime != 0L) {
                float f2 = sensorEvent.values[0];
                float f3 = f2 - this.mLastX;
                float f4 = sensorEvent.values[1];
                float f5 = f4 - this.mLastY;
                float f6 = sensorEvent.values[2];
                float f7 = f6 - this.mLastZ;
                if ((float)Math.sqrt(f3 * f3 + f5 * f5 + f7 * f7) / (float)l3 * 10000.0f > 1500.0f) {
                    if (!this.shaken) {
                        this.shaken = true;
                        this.finish();
                    }
                    if (this.listener != null) {
                        this.listener.onShake();
                    }
                }
                this.mLastX = f2;
                this.mLastY = f4;
                this.mLastZ = f6;
            }
            this.mLastUpdateTime = l2;
        }
    }

    @Override
    public void setActivity(Activity activity) {
        super.setActivity(activity);
        int n2 = ShareSDKR.getBitmapRes((Context)activity, "ssdk_oks_shake_to_share_back");
        if (n2 > 0) {
            activity.setTheme(16973835);
            activity.requestWindowFeature(1);
            activity.getWindow().setBackgroundDrawableResource(n2);
        }
    }

    public void setOnShakeListener(OnShakeListener onShakeListener) {
        this.listener = onShakeListener;
    }

    public static interface OnShakeListener {
        public void onShake();
    }
}

