/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.onekeyshare;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.mob.tools.FakeActivity;

public class PicViewer
extends FakeActivity
implements View.OnTouchListener {
    static final int DRAG = 1;
    static final float MAX_SCALE = 10.0f;
    static final int NONE = 0;
    static final int ZOOM = 2;
    float dist = 1.0f;
    DisplayMetrics dm;
    private ImageView ivViewer;
    Matrix matrix = new Matrix();
    PointF mid;
    float minScaleR = 1.0f;
    int mode = 0;
    private Bitmap pic;
    PointF prev;
    Matrix savedMatrix = new Matrix();

    public PicViewer() {
        this.prev = new PointF();
        this.mid = new PointF();
    }

    private void CheckView() {
        float[] fArray = new float[9];
        this.matrix.getValues(fArray);
        if (this.mode == 2) {
            if (fArray[0] < this.minScaleR) {
                this.matrix.setScale(this.minScaleR, this.minScaleR);
            }
            if (fArray[0] > 10.0f) {
                this.matrix.set(this.savedMatrix);
            }
        }
        this.center();
    }

    private void center() {
        this.center(true, true);
    }

    private void midPoint(PointF pointF, MotionEvent motionEvent) {
        float f2 = motionEvent.getX(0);
        float f3 = motionEvent.getX(1);
        float f4 = motionEvent.getY(0);
        float f5 = motionEvent.getY(1);
        pointF.set((f2 + f3) / 2.0f, (f4 + f5) / 2.0f);
    }

    private void minZoom() {
        this.minScaleR = Math.min((float)this.dm.widthPixels / (float)this.pic.getWidth(), (float)this.dm.heightPixels / (float)this.pic.getHeight());
        this.matrix.setScale(this.minScaleR, this.minScaleR);
    }

    private float spacing(MotionEvent motionEvent) {
        float f2 = motionEvent.getX(0) - motionEvent.getX(1);
        float f3 = motionEvent.getY(0) - motionEvent.getY(1);
        return (float)Math.sqrt(f2 * f2 + f3 * f3);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void center(boolean bl, boolean bl2) {
        int n2;
        float f2;
        Matrix matrix = new Matrix();
        matrix.set(this.matrix);
        RectF rectF = new RectF(0.0f, 0.0f, (float)this.pic.getWidth(), (float)this.pic.getHeight());
        matrix.mapRect(rectF);
        float f3 = rectF.height();
        float f4 = rectF.width();
        float f5 = 0.0f;
        float f6 = f2 = 0.0f;
        if (bl2) {
            n2 = this.dm.heightPixels;
            if (f3 < (float)n2) {
                f6 = ((float)n2 - f3) / 2.0f - rectF.top;
            } else if (rectF.top > 0.0f) {
                f6 = -rectF.top;
            } else {
                f6 = f2;
                if (rectF.bottom < (float)n2) {
                    f6 = (float)this.ivViewer.getHeight() - rectF.bottom;
                }
            }
        }
        f2 = f5;
        if (bl) {
            n2 = this.dm.widthPixels;
            if (f4 < (float)n2) {
                f2 = ((float)n2 - f4) / 2.0f - rectF.left;
            } else if (rectF.left > 0.0f) {
                f2 = -rectF.left;
            } else {
                f2 = f5;
                if (rectF.right < (float)n2) {
                    f2 = (float)this.ivViewer.getWidth() - rectF.right;
                }
            }
        }
        this.matrix.postTranslate(f2, f6);
    }

    @Override
    public void onCreate() {
        this.ivViewer = new ImageView((Context)this.activity);
        this.ivViewer.setScaleType(ImageView.ScaleType.MATRIX);
        this.ivViewer.setBackgroundColor(-1073741824);
        this.ivViewer.setOnTouchListener((View.OnTouchListener)this);
        if (this.pic != null && !this.pic.isRecycled()) {
            this.ivViewer.setImageBitmap(this.pic);
        }
        this.dm = new DisplayMetrics();
        this.activity.getWindowManager().getDefaultDisplay().getMetrics(this.dm);
        this.minZoom();
        this.CheckView();
        this.ivViewer.setImageMatrix(this.matrix);
        this.activity.setContentView((View)this.ivViewer);
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean onTouch(View view, MotionEvent motionEvent) {
        switch (motionEvent.getAction() & 0xFF) {
            case 0: {
                this.savedMatrix.set(this.matrix);
                this.prev.set(motionEvent.getX(), motionEvent.getY());
                this.mode = 1;
                break;
            }
            case 5: {
                this.dist = this.spacing(motionEvent);
                if (!(this.spacing(motionEvent) > 10.0f)) break;
                this.savedMatrix.set(this.matrix);
                this.midPoint(this.mid, motionEvent);
                this.mode = 2;
                break;
            }
            case 1: 
            case 6: {
                this.mode = 0;
                break;
            }
            case 2: {
                float f2;
                if (this.mode == 1) {
                    this.matrix.set(this.savedMatrix);
                    this.matrix.postTranslate(motionEvent.getX() - this.prev.x, motionEvent.getY() - this.prev.y);
                    break;
                }
                if (this.mode != 2 || !((f2 = this.spacing(motionEvent)) > 10.0f)) break;
                this.matrix.set(this.savedMatrix);
                this.matrix.postScale(f2 /= this.dist, f2, this.mid.x, this.mid.y);
                break;
            }
        }
        this.ivViewer.setImageMatrix(this.matrix);
        this.CheckView();
        return true;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.pic = bitmap;
        if (this.ivViewer != null) {
            this.ivViewer.setImageBitmap(bitmap);
        }
    }
}

