/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.framework;

import android.content.Context;
import android.content.SharedPreferences;
import cn.sharesdk.framework.utils.d;
import com.mob.tools.utils.Hashon;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class PlatformDb {
    private static final String DB_NAME = "cn_sharesdk_weibodb";
    private SharedPreferences db;
    private String platformNname;
    private int platformVersion;

    public PlatformDb(Context context, String string2, int n2) {
        this.db = context.getSharedPreferences("cn_sharesdk_weibodb_" + string2 + "_" + n2, 0);
        this.platformNname = string2;
        this.platformVersion = n2;
    }

    public String exportData() {
        try {
            Object object = new HashMap<String, Object>();
            ((HashMap)object).putAll(this.db.getAll());
            object = new Hashon().fromHashMap((HashMap<String, Object>)object);
            return object;
        }
        catch (Throwable throwable) {
            d.a().w(throwable);
            return null;
        }
    }

    public String get(String string2) {
        return this.db.getString(string2, "");
    }

    public long getExpiresIn() {
        try {
            long l2 = this.db.getLong("expiresIn", 0L);
            return l2;
        }
        catch (Throwable throwable) {
            int n2;
            try {
                n2 = this.db.getInt("expiresIn", 0);
            }
            catch (Throwable throwable2) {
                return 0L;
            }
            return n2;
        }
    }

    public long getExpiresTime() {
        return this.db.getLong("expiresTime", 0L) + this.getExpiresIn() * 1000L;
    }

    public String getPlatformNname() {
        return this.platformNname;
    }

    public int getPlatformVersion() {
        return this.platformVersion;
    }

    public String getToken() {
        return this.db.getString("token", "");
    }

    public String getTokenSecret() {
        return this.db.getString("secret", "");
    }

    public String getUserGender() {
        String string2 = this.db.getString("gender", "2");
        if ("0".equals(string2)) {
            return "m";
        }
        if ("1".equals(string2)) {
            return "f";
        }
        return null;
    }

    public String getUserIcon() {
        return this.db.getString("icon", "");
    }

    public String getUserId() {
        return this.db.getString("weibo", "");
    }

    public String getUserName() {
        return this.db.getString("nickname", "");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void importData(String string2) {
        try {
            HashMap<String, Object> hashMap = new Hashon().fromJson(string2);
            if (hashMap == null) return;
            string2 = this.db.edit();
            for (Map.Entry entry : hashMap.entrySet()) {
                Object v2 = entry.getValue();
                if (v2 instanceof Boolean) {
                    string2.putBoolean((String)entry.getKey(), ((Boolean)v2).booleanValue());
                    continue;
                }
                if (v2 instanceof Float) {
                    string2.putFloat((String)entry.getKey(), ((Float)v2).floatValue());
                    continue;
                }
                if (v2 instanceof Integer) {
                    string2.putInt((String)entry.getKey(), ((Integer)v2).intValue());
                    continue;
                }
                if (v2 instanceof Long) {
                    string2.putLong((String)entry.getKey(), ((Long)v2).longValue());
                    continue;
                }
                string2.putString((String)entry.getKey(), String.valueOf(v2));
            }
            string2.commit();
            return;
        }
        catch (Throwable throwable) {
            d.a().w(throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isValid() {
        boolean bl = true;
        String string2 = this.getToken();
        if (string2 == null) return false;
        if (string2.length() <= 0) {
            return false;
        }
        boolean bl2 = bl;
        if (this.getExpiresIn() == 0L) return bl2;
        bl2 = bl;
        if (this.getExpiresTime() > System.currentTimeMillis()) return bl2;
        return false;
    }

    public void put(String string2, String string3) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString(string2, string3);
        editor.commit();
    }

    public void putExpiresIn(long l2) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putLong("expiresIn", l2);
        editor.putLong("expiresTime", System.currentTimeMillis());
        editor.commit();
    }

    public void putToken(String string2) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString("token", string2);
        editor.commit();
    }

    public void putTokenSecret(String string2) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString("secret", string2);
        editor.commit();
    }

    public void putUserId(String string2) {
        SharedPreferences.Editor editor = this.db.edit();
        editor.putString("weibo", string2);
        editor.commit();
    }

    public void removeAccount() {
        Object object = new ArrayList();
        SharedPreferences.Editor editor = this.db.getAll().entrySet().iterator();
        while (editor.hasNext()) {
            ((ArrayList)object).add(editor.next().getKey());
        }
        editor = this.db.edit();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            editor.remove((String)object.next());
        }
        editor.commit();
    }
}

