/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.support.v4.app.BackStackRecord;
import android.support.v4.app.BackStackState;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentContainer;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentManagerState;
import android.support.v4.app.FragmentState;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.app.NoSaveStateFrameLayout;
import android.support.v4.app.SuperNotCalledException;
import android.support.v4.util.DebugUtils;
import android.support.v4.util.LogWriter;
import android.util.Log;
import android.util.SparseArray;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

final class FragmentManagerImpl
extends FragmentManager {
    static final Interpolator ACCELERATE_CUBIC;
    static final Interpolator ACCELERATE_QUINT;
    static final int ANIM_DUR = 220;
    public static final int ANIM_STYLE_CLOSE_ENTER = 3;
    public static final int ANIM_STYLE_CLOSE_EXIT = 4;
    public static final int ANIM_STYLE_FADE_ENTER = 5;
    public static final int ANIM_STYLE_FADE_EXIT = 6;
    public static final int ANIM_STYLE_OPEN_ENTER = 1;
    public static final int ANIM_STYLE_OPEN_EXIT = 2;
    static boolean DEBUG = false;
    static final Interpolator DECELERATE_CUBIC;
    static final Interpolator DECELERATE_QUINT;
    static final boolean HONEYCOMB;
    static final String TAG = "FragmentManager";
    static final String TARGET_REQUEST_CODE_STATE_TAG = "android:target_req_state";
    static final String TARGET_STATE_TAG = "android:target_state";
    static final String USER_VISIBLE_HINT_TAG = "android:user_visible_hint";
    static final String VIEW_STATE_TAG = "android:view_state";
    ArrayList<Fragment> mActive;
    FragmentActivity mActivity;
    ArrayList<Fragment> mAdded;
    ArrayList<Integer> mAvailBackStackIndices;
    ArrayList<Integer> mAvailIndices;
    ArrayList<BackStackRecord> mBackStack;
    ArrayList<FragmentManager.OnBackStackChangedListener> mBackStackChangeListeners;
    ArrayList<BackStackRecord> mBackStackIndices;
    FragmentContainer mContainer;
    ArrayList<Fragment> mCreatedMenus;
    int mCurState = 0;
    boolean mDestroyed;
    Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManagerImpl.this.execPendingActions();
        }
    };
    boolean mExecutingActions;
    boolean mHavePendingDeferredStart;
    boolean mNeedMenuInvalidate;
    String mNoTransactionsBecause;
    Fragment mParent;
    ArrayList<Runnable> mPendingActions;
    SparseArray<Parcelable> mStateArray = null;
    Bundle mStateBundle = null;
    boolean mStateSaved;
    Runnable[] mTmpActions;

    static {
        boolean bl = false;
        DEBUG = false;
        if (Build.VERSION.SDK_INT >= 11) {
            bl = true;
        }
        HONEYCOMB = bl;
        DECELERATE_QUINT = new DecelerateInterpolator(2.5f);
        DECELERATE_CUBIC = new DecelerateInterpolator(1.5f);
        ACCELERATE_QUINT = new AccelerateInterpolator(2.5f);
        ACCELERATE_CUBIC = new AccelerateInterpolator(1.5f);
    }

    FragmentManagerImpl() {
    }

    private void checkStateLoss() {
        if (this.mStateSaved) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mNoTransactionsBecause != null) {
            throw new IllegalStateException("Can not perform this action inside of " + this.mNoTransactionsBecause);
        }
    }

    static Animation makeFadeAnimation(Context context, float f2, float f3) {
        context = new AlphaAnimation(f2, f3);
        context.setInterpolator(DECELERATE_CUBIC);
        context.setDuration(220L);
        return context;
    }

    static Animation makeOpenCloseAnimation(Context context, float f2, float f3, float f4, float f5) {
        context = new AnimationSet(false);
        ScaleAnimation scaleAnimation = new ScaleAnimation(f2, f3, f2, f3, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setInterpolator(DECELERATE_QUINT);
        scaleAnimation.setDuration(220L);
        context.addAnimation((Animation)scaleAnimation);
        scaleAnimation = new AlphaAnimation(f4, f5);
        scaleAnimation.setInterpolator(DECELERATE_CUBIC);
        scaleAnimation.setDuration(220L);
        context.addAnimation((Animation)scaleAnimation);
        return context;
    }

    public static int reverseTransit(int n2) {
        switch (n2) {
            default: {
                return 0;
            }
            case 4097: {
                return 8194;
            }
            case 8194: {
                return 4097;
            }
            case 4099: 
        }
        return 4099;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void throwException(RuntimeException runtimeException) {
        Log.e((String)TAG, (String)runtimeException.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        PrintWriter printWriter = new PrintWriter(new LogWriter(TAG));
        if (this.mActivity != null) {
            try {
                this.mActivity.dump("  ", null, printWriter, new String[0]);
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
                throw runtimeException;
            }
            throw runtimeException;
        }
        try {
            this.dump("  ", null, printWriter, new String[0]);
            throw runtimeException;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)"Failed dumping state", (Throwable)exception);
            throw runtimeException;
        }
    }

    public static int transitToStyleIndex(int n2, boolean bl) {
        switch (n2) {
            default: {
                return -1;
            }
            case 4097: {
                if (bl) {
                    return 1;
                }
                return 2;
            }
            case 8194: {
                if (bl) {
                    return 3;
                }
                return 4;
            }
            case 4099: 
        }
        if (bl) {
            return 5;
        }
        return 6;
    }

    void addBackStackState(BackStackRecord backStackRecord) {
        if (this.mBackStack == null) {
            this.mBackStack = new ArrayList();
        }
        this.mBackStack.add(backStackRecord);
        this.reportBackStackChanged();
    }

    public void addFragment(Fragment fragment, boolean bl) {
        if (this.mAdded == null) {
            this.mAdded = new ArrayList();
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("add: " + fragment));
        }
        this.makeActive(fragment);
        if (!fragment.mDetached) {
            if (this.mAdded.contains(fragment)) {
                throw new IllegalStateException("Fragment already added: " + fragment);
            }
            this.mAdded.add(fragment);
            fragment.mAdded = true;
            fragment.mRemoving = false;
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            if (bl) {
                this.moveToState(fragment);
            }
        }
    }

    @Override
    public void addOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners == null) {
            this.mBackStackChangeListeners = new ArrayList();
        }
        this.mBackStackChangeListeners.add(onBackStackChangedListener);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int allocBackStackIndex(BackStackRecord backStackRecord) {
        synchronized (this) {
            if (this.mAvailBackStackIndices == null || this.mAvailBackStackIndices.size() <= 0) {
                if (this.mBackStackIndices == null) {
                    this.mBackStackIndices = new ArrayList();
                }
                int n2 = this.mBackStackIndices.size();
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + n2 + " to " + backStackRecord));
                }
                this.mBackStackIndices.add(backStackRecord);
                return n2;
            }
            int n3 = this.mAvailBackStackIndices.remove(this.mAvailBackStackIndices.size() - 1);
            if (DEBUG) {
                Log.v((String)TAG, (String)("Adding back stack index " + n3 + " with " + backStackRecord));
            }
            this.mBackStackIndices.set(n3, backStackRecord);
            return n3;
        }
    }

    public void attachActivity(FragmentActivity fragmentActivity, FragmentContainer fragmentContainer, Fragment fragment) {
        if (this.mActivity != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mActivity = fragmentActivity;
        this.mContainer = fragmentContainer;
        this.mParent = fragment;
    }

    public void attachFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("attach: " + fragment));
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                if (this.mAdded == null) {
                    this.mAdded = new ArrayList();
                }
                if (this.mAdded.contains(fragment)) {
                    throw new IllegalStateException("Fragment already added: " + fragment);
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("add from attach: " + fragment));
                }
                this.mAdded.add(fragment);
                fragment.mAdded = true;
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                this.moveToState(fragment, this.mCurState, n2, n3, false);
            }
        }
    }

    @Override
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    public void detachFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("detach: " + fragment));
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (this.mAdded != null) {
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("remove from detach: " + fragment));
                    }
                    this.mAdded.remove(fragment);
                }
                if (fragment.mHasMenu && fragment.mMenuVisible) {
                    this.mNeedMenuInvalidate = true;
                }
                fragment.mAdded = false;
                this.moveToState(fragment, 1, n2, n3, false);
            }
        }
    }

    public void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.moveToState(2, false);
    }

    public void dispatchConfigurationChanged(Configuration configuration) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performConfigurationChanged(configuration);
            }
        }
    }

    public boolean dispatchContextItemSelected(MenuItem menuItem) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null || !fragment.performContextItemSelected(menuItem)) continue;
                return true;
            }
        }
        return false;
    }

    public void dispatchCreate() {
        this.mStateSaved = false;
        this.moveToState(1, false);
    }

    public boolean dispatchCreateOptionsMenu(Menu object, MenuInflater menuInflater) {
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<Fragment> arrayList = null;
        ArrayList<Fragment> arrayList2 = null;
        if (this.mAdded != null) {
            n2 = 0;
            while (true) {
                arrayList = arrayList2;
                bl = bl2;
                if (n2 >= this.mAdded.size()) break;
                Fragment fragment = this.mAdded.get(n2);
                arrayList = arrayList2;
                bl = bl2;
                if (fragment != null) {
                    arrayList = arrayList2;
                    bl = bl2;
                    if (fragment.performCreateOptionsMenu((Menu)object, menuInflater)) {
                        bl = true;
                        arrayList = arrayList2;
                        if (arrayList2 == null) {
                            arrayList = new ArrayList<Fragment>();
                        }
                        arrayList.add(fragment);
                    }
                }
                ++n2;
                arrayList2 = arrayList;
                bl2 = bl;
            }
        }
        if (this.mCreatedMenus != null) {
            for (n2 = 0; n2 < this.mCreatedMenus.size(); ++n2) {
                object = this.mCreatedMenus.get(n2);
                if (arrayList != null && arrayList.contains(object)) continue;
                ((Fragment)object).onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = arrayList;
        return bl;
    }

    public void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions();
        this.moveToState(0, false);
        this.mActivity = null;
        this.mContainer = null;
        this.mParent = null;
    }

    public void dispatchDestroyView() {
        this.moveToState(1, false);
    }

    public void dispatchLowMemory() {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performLowMemory();
            }
        }
    }

    public boolean dispatchOptionsItemSelected(MenuItem menuItem) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null || !fragment.performOptionsItemSelected(menuItem)) continue;
                return true;
            }
        }
        return false;
    }

    public void dispatchOptionsMenuClosed(Menu menu) {
        if (this.mAdded != null) {
            for (int i2 = 0; i2 < this.mAdded.size(); ++i2) {
                Fragment fragment = this.mAdded.get(i2);
                if (fragment == null) continue;
                fragment.performOptionsMenuClosed(menu);
            }
        }
    }

    public void dispatchPause() {
        this.moveToState(4, false);
    }

    public boolean dispatchPrepareOptionsMenu(Menu menu) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.mAdded != null) {
            int n2 = 0;
            while (true) {
                bl = bl2;
                if (n2 >= this.mAdded.size()) break;
                Fragment fragment = this.mAdded.get(n2);
                bl = bl2;
                if (fragment != null) {
                    bl = bl2;
                    if (fragment.performPrepareOptionsMenu(menu)) {
                        bl = true;
                    }
                }
                ++n2;
                bl2 = bl;
            }
        }
        return bl;
    }

    public void dispatchReallyStop() {
        this.moveToState(2, false);
    }

    public void dispatchResume() {
        this.mStateSaved = false;
        this.moveToState(5, false);
    }

    public void dispatchStart() {
        this.mStateSaved = false;
        this.moveToState(4, false);
    }

    public void dispatchStop() {
        this.mStateSaved = true;
        this.moveToState(3, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void dump(String string2, FileDescriptor object, PrintWriter printWriter, String[] stringArray) {
        Object object2;
        int n2;
        int n3;
        String string3 = string2 + "    ";
        if (this.mActive != null && (n3 = this.mActive.size()) > 0) {
            printWriter.print(string2);
            printWriter.print("Active Fragments in ");
            printWriter.print(Integer.toHexString(System.identityHashCode(this)));
            printWriter.println(":");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mActive.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(object2);
                if (object2 == null) continue;
                ((Fragment)object2).dump(string3, (FileDescriptor)object, printWriter, stringArray);
            }
        }
        if (this.mAdded != null && (n3 = this.mAdded.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Added Fragments:");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mAdded.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(((Fragment)object2).toString());
            }
        }
        if (this.mCreatedMenus != null && (n3 = this.mCreatedMenus.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Fragments Created Menus:");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mCreatedMenus.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(((Fragment)object2).toString());
            }
        }
        if (this.mBackStack != null && (n3 = this.mBackStack.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack:");
            for (n2 = 0; n2 < n3; ++n2) {
                object2 = this.mBackStack.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(((BackStackRecord)object2).toString());
                ((BackStackRecord)object2).dump(string3, (FileDescriptor)object, printWriter, stringArray);
            }
        }
        // MONITORENTER : this
        if (this.mBackStackIndices != null && (n3 = this.mBackStackIndices.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Back Stack Indices:");
            for (n2 = 0; n2 < n3; ++n2) {
                object = this.mBackStackIndices.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(object);
            }
        }
        if (this.mAvailBackStackIndices != null && this.mAvailBackStackIndices.size() > 0) {
            printWriter.print(string2);
            printWriter.print("mAvailBackStackIndices: ");
            printWriter.println(Arrays.toString(this.mAvailBackStackIndices.toArray()));
        }
        // MONITOREXIT : this
        if (this.mPendingActions != null && (n3 = this.mPendingActions.size()) > 0) {
            printWriter.print(string2);
            printWriter.println("Pending Actions:");
            for (n2 = 0; n2 < n3; ++n2) {
                object = this.mPendingActions.get(n2);
                printWriter.print(string2);
                printWriter.print("  #");
                printWriter.print(n2);
                printWriter.print(": ");
                printWriter.println(object);
            }
        }
        printWriter.print(string2);
        printWriter.println("FragmentManager misc state:");
        printWriter.print(string2);
        printWriter.print("  mActivity=");
        printWriter.println((Object)this.mActivity);
        printWriter.print(string2);
        printWriter.print("  mContainer=");
        printWriter.println(this.mContainer);
        if (this.mParent != null) {
            printWriter.print(string2);
            printWriter.print("  mParent=");
            printWriter.println(this.mParent);
        }
        printWriter.print(string2);
        printWriter.print("  mCurState=");
        printWriter.print(this.mCurState);
        printWriter.print(" mStateSaved=");
        printWriter.print(this.mStateSaved);
        printWriter.print(" mDestroyed=");
        printWriter.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            printWriter.print(string2);
            printWriter.print("  mNeedMenuInvalidate=");
            printWriter.println(this.mNeedMenuInvalidate);
        }
        if (this.mNoTransactionsBecause != null) {
            printWriter.print(string2);
            printWriter.print("  mNoTransactionsBecause=");
            printWriter.println(this.mNoTransactionsBecause);
        }
        if (this.mAvailIndices == null) return;
        if (this.mAvailIndices.size() <= 0) return;
        printWriter.print(string2);
        printWriter.print("  mAvailIndices: ");
        printWriter.println(Arrays.toString(this.mAvailIndices.toArray()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void enqueueAction(Runnable runnable, boolean bl) {
        if (!bl) {
            this.checkStateLoss();
        }
        synchronized (this) {
            if (this.mActivity == null) {
                throw new IllegalStateException("Activity has been destroyed");
            }
            if (this.mPendingActions == null) {
                this.mPendingActions = new ArrayList();
            }
            this.mPendingActions.add(runnable);
            if (this.mPendingActions.size() == 1) {
                this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                this.mActivity.mHandler.post(this.mExecCommit);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execPendingActions() {
        boolean bl;
        block14: {
            int n2;
            if (this.mExecutingActions) {
                throw new IllegalStateException("Recursive entry to executePendingTransactions");
            }
            if (Looper.myLooper() != this.mActivity.mHandler.getLooper()) {
                throw new IllegalStateException("Must be called from main thread of process");
            }
            bl = false;
            while (true) {
                int n3;
                synchronized (this) {
                    if (this.mPendingActions == null || this.mPendingActions.size() == 0) {
                        // MONITOREXIT @DISABLED, blocks:[3, 4, 13] lbl9 : MonitorExitStatement: MONITOREXIT : this
                        if (!this.mHavePendingDeferredStart) break block14;
                        n2 = 0;
                        for (n3 = 0; n3 < this.mActive.size(); ++n3) {
                            Fragment fragment = this.mActive.get(n3);
                            int n4 = n2;
                            if (fragment != null) {
                                n4 = n2;
                                if (fragment.mLoaderManager != null) {
                                    n4 = n2 | fragment.mLoaderManager.hasRunningLoaders();
                                }
                            }
                            n2 = n4;
                        }
                        break;
                    }
                    n2 = this.mPendingActions.size();
                    if (this.mTmpActions == null || this.mTmpActions.length < n2) {
                        this.mTmpActions = new Runnable[n2];
                    }
                    this.mPendingActions.toArray(this.mTmpActions);
                    this.mPendingActions.clear();
                    this.mActivity.mHandler.removeCallbacks(this.mExecCommit);
                }
                this.mExecutingActions = true;
                for (n3 = 0; n3 < n2; ++n3) {
                    this.mTmpActions[n3].run();
                    this.mTmpActions[n3] = null;
                }
                this.mExecutingActions = false;
                bl = true;
            }
            if (n2 == 0) {
                this.mHavePendingDeferredStart = false;
                this.startPendingDeferredFragments();
            }
        }
        return bl;
    }

    @Override
    public boolean executePendingTransactions() {
        return this.execPendingActions();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Fragment findFragmentById(int n2) {
        Fragment fragment;
        int n3;
        if (this.mAdded != null) {
            for (n3 = this.mAdded.size() - 1; n3 >= 0; --n3) {
                fragment = this.mAdded.get(n3);
                if (fragment != null && fragment.mFragmentId == n2) return fragment;
            }
        }
        if (this.mActive == null) return null;
        for (n3 = this.mActive.size() - 1; n3 >= 0; --n3) {
            Fragment fragment2 = this.mActive.get(n3);
            if (fragment2 == null) continue;
            fragment = fragment2;
            if (fragment2.mFragmentId != n2) continue;
            return fragment;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Fragment findFragmentByTag(String string2) {
        Fragment fragment;
        int n2;
        if (this.mAdded != null && string2 != null) {
            for (n2 = this.mAdded.size() - 1; n2 >= 0; --n2) {
                fragment = this.mAdded.get(n2);
                if (fragment != null && string2.equals(fragment.mTag)) return fragment;
            }
        }
        if (this.mActive == null || string2 == null) return null;
        for (n2 = this.mActive.size() - 1; n2 >= 0; --n2) {
            Fragment fragment2 = this.mActive.get(n2);
            if (fragment2 == null) continue;
            fragment = fragment2;
            if (!string2.equals(fragment2.mTag)) continue;
            return fragment;
        }
        return null;
    }

    public Fragment findFragmentByWho(String string2) {
        if (this.mActive != null && string2 != null) {
            for (int i2 = this.mActive.size() - 1; i2 >= 0; --i2) {
                Fragment fragment = this.mActive.get(i2);
                if (fragment == null || (fragment = fragment.findFragmentByWho(string2)) == null) continue;
                return fragment;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void freeBackStackIndex(int n2) {
        synchronized (this) {
            this.mBackStackIndices.set(n2, null);
            if (this.mAvailBackStackIndices == null) {
                this.mAvailBackStackIndices = new ArrayList();
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Freeing back stack index " + n2));
            }
            this.mAvailBackStackIndices.add(n2);
            return;
        }
    }

    @Override
    public FragmentManager.BackStackEntry getBackStackEntryAt(int n2) {
        return this.mBackStack.get(n2);
    }

    @Override
    public int getBackStackEntryCount() {
        if (this.mBackStack != null) {
            return this.mBackStack.size();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Fragment getFragment(Bundle object, String string2) {
        Fragment fragment;
        void var1_3;
        void var2_5;
        int n2 = object.getInt((String)var2_5, -1);
        if (n2 == -1) {
            return var1_3;
        }
        if (n2 >= this.mActive.size()) {
            this.throwException(new IllegalStateException("Fragement no longer exists for key " + (String)var2_5 + ": index " + n2));
        }
        Fragment fragment2 = fragment = this.mActive.get(n2);
        if (fragment != null) {
            return var1_3;
        }
        this.throwException(new IllegalStateException("Fragement no longer exists for key " + (String)var2_5 + ": index " + n2));
        return fragment;
    }

    public void hideFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("hide: " + fragment));
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n2, true, n3);
                if (animation != null) {
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(8);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(true);
        }
    }

    Animation loadAnimation(Fragment fragment, int n2, boolean bl, int n3) {
        Animation animation = fragment.onCreateAnimation(n2, bl, fragment.mNextAnim);
        if (animation != null) {
            return animation;
        }
        if (fragment.mNextAnim != 0 && (fragment = AnimationUtils.loadAnimation((Context)this.mActivity, (int)fragment.mNextAnim)) != null) {
            return fragment;
        }
        if (n2 == 0) {
            return null;
        }
        if ((n2 = FragmentManagerImpl.transitToStyleIndex(n2, bl)) < 0) {
            return null;
        }
        switch (n2) {
            default: {
                n2 = n3;
                if (n3 == 0) {
                    n2 = n3;
                    if (this.mActivity.getWindow() != null) {
                        n2 = this.mActivity.getWindow().getAttributes().windowAnimations;
                    }
                }
                if (n2 != 0) break;
                return null;
            }
            case 1: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.125f, 1.0f, 0.0f, 1.0f);
            }
            case 2: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.0f, 0.975f, 1.0f, 0.0f);
            }
            case 3: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 0.975f, 1.0f, 0.0f, 1.0f);
            }
            case 4: {
                return FragmentManagerImpl.makeOpenCloseAnimation((Context)this.mActivity, 1.0f, 1.075f, 1.0f, 0.0f);
            }
            case 5: {
                return FragmentManagerImpl.makeFadeAnimation((Context)this.mActivity, 0.0f, 1.0f);
            }
            case 6: {
                return FragmentManagerImpl.makeFadeAnimation((Context)this.mActivity, 1.0f, 0.0f);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    void makeActive(Fragment fragment) {
        block7: {
            block6: {
                if (fragment.mIndex >= 0) break block6;
                if (this.mAvailIndices == null || this.mAvailIndices.size() <= 0) {
                    if (this.mActive == null) {
                        this.mActive = new ArrayList();
                    }
                    fragment.setIndex(this.mActive.size(), this.mParent);
                    this.mActive.add(fragment);
                } else {
                    fragment.setIndex(this.mAvailIndices.remove(this.mAvailIndices.size() - 1), this.mParent);
                    this.mActive.set(fragment.mIndex, fragment);
                }
                if (DEBUG) break block7;
            }
            return;
        }
        Log.v((String)TAG, (String)("Allocated fragment index " + fragment));
    }

    void makeInactive(Fragment fragment) {
        if (fragment.mIndex < 0) {
            return;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("Freeing fragment index " + fragment));
        }
        this.mActive.set(fragment.mIndex, null);
        if (this.mAvailIndices == null) {
            this.mAvailIndices = new ArrayList();
        }
        this.mAvailIndices.add(fragment.mIndex);
        this.mActivity.invalidateSupportFragment(fragment.mWho);
        fragment.initState();
    }

    /*
     * Enabled aggressive block sorting
     */
    void moveToState(int n2, int n3, int n4, boolean bl) {
        block9: {
            block8: {
                if (this.mActivity == null && n2 != 0) {
                    throw new IllegalStateException("No activity");
                }
                if (!bl && this.mCurState == n2) break block8;
                this.mCurState = n2;
                if (this.mActive == null) break block8;
                boolean bl2 = false;
                for (int i2 = 0; i2 < this.mActive.size(); ++i2) {
                    Fragment fragment = this.mActive.get(i2);
                    boolean bl3 = bl2;
                    if (fragment != null) {
                        this.moveToState(fragment, n2, n3, n4, false);
                        bl3 = bl2;
                        if (fragment.mLoaderManager != null) {
                            bl3 = bl2 | fragment.mLoaderManager.hasRunningLoaders();
                        }
                    }
                    bl2 = bl3;
                }
                if (!bl2) {
                    this.startPendingDeferredFragments();
                }
                if (this.mNeedMenuInvalidate && this.mActivity != null && this.mCurState == 5) break block9;
            }
            return;
        }
        this.mActivity.supportInvalidateOptionsMenu();
        this.mNeedMenuInvalidate = false;
    }

    void moveToState(int n2, boolean bl) {
        this.moveToState(n2, 0, 0, bl);
    }

    void moveToState(Fragment fragment) {
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    /*
     * Handled duff style switch with additional control
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    void moveToState(final Fragment var1_1, int var2_2, int var3_3, int var4_4, boolean var5_5) {
        block69: {
            block72: {
                block71: {
                    block70: {
                        if (!var1_1.mAdded) break block70;
                        var6_6 = var2_2;
                        if (!var1_1.mDetached) break block71;
                    }
                    var6_6 = var2_2;
                    if (var2_2 > 1) {
                        var6_6 = 1;
                    }
                }
                var7_7 = var6_6;
                if (var1_1.mRemoving) {
                    var7_7 = var6_6;
                    if (var6_6 > var1_1.mState) {
                        var7_7 = var1_1.mState;
                    }
                }
                var2_2 = var7_7;
                if (var1_1.mDeferStart) {
                    var2_2 = var7_7;
                    if (var1_1.mState < 4) {
                        var2_2 = var7_7;
                        if (var7_7 > 3) {
                            var2_2 = 3;
                        }
                    }
                }
                if (var1_1.mState >= var2_2) break block72;
                if (var1_1.mFromLayout && !var1_1.mInLayout) {
                    return;
                }
                if (var1_1.mAnimatingAway != null) {
                    var1_1.mAnimatingAway = null;
                    this.moveToState(var1_1, var1_1.mStateAfterAnimating, 0, 0, true);
                }
                var6_6 = var2_2;
                var8_8 = var2_2;
                var7_7 = var2_2;
                cfr_temp_0 = -2147483648;
                block13: do {
                    switch (cfr_temp_0 == -2147483648 ? var1_1.mState : cfr_temp_0) {
                        default: {
                            var6_6 = var2_2;
                            break block69;
                        }
                        case 0: {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("moveto CREATED: " + var1_1));
                            }
                            var7_7 = var2_2;
                            if (var1_1.mSavedFragmentState != null) {
                                var1_1.mSavedViewState = var1_1.mSavedFragmentState.getSparseParcelableArray("android:view_state");
                                var1_1.mTarget = this.getFragment(var1_1.mSavedFragmentState, "android:target_state");
                                if (var1_1.mTarget != null) {
                                    var1_1.mTargetRequestCode = var1_1.mSavedFragmentState.getInt("android:target_req_state", 0);
                                }
                                var1_1.mUserVisibleHint = var1_1.mSavedFragmentState.getBoolean("android:user_visible_hint", true);
                                var7_7 = var2_2;
                                if (!var1_1.mUserVisibleHint) {
                                    var1_1.mDeferStart = true;
                                    var7_7 = var2_2;
                                    if (var2_2 > 3) {
                                        var7_7 = 3;
                                    }
                                }
                            }
                            var1_1.mActivity = this.mActivity;
                            var1_1.mParentFragment = this.mParent;
                            var9_9 = this.mParent != null ? this.mParent.mChildFragmentManager : this.mActivity.mFragments;
                            var1_1.mFragmentManager = var9_9;
                            var1_1.mCalled = false;
                            var1_1.onAttach(this.mActivity);
                            if (!var1_1.mCalled) {
                                throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onAttach()");
                            }
                            if (var1_1.mParentFragment == null) {
                                this.mActivity.onAttachFragment(var1_1);
                            }
                            if (!var1_1.mRetaining) {
                                var1_1.performCreate(var1_1.mSavedFragmentState);
                            }
                            var1_1.mRetaining = false;
                            var6_6 = var7_7;
                            if (!var1_1.mFromLayout) ** GOTO lbl76
                            var1_1.mView = var1_1.performCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), null, var1_1.mSavedFragmentState);
                            if (var1_1.mView == null) ** GOTO lbl78
                            var1_1.mInnerView = var1_1.mView;
                            var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                            if (var1_1.mHidden) {
                                var1_1.mView.setVisibility(8);
                            }
                            var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
                            var6_6 = var7_7;
                        }
lbl76:
                        // 3 sources

                        case 1: {
                            ** GOTO lbl80
                        }
lbl78:
                        // 1 sources

                        var1_1.mInnerView = null;
                        var6_6 = var7_7;
lbl80:
                        // 2 sources

                        var8_8 = var6_6;
                        cfr_temp_0 = 2;
                        if (var6_6 <= 1) continue block13;
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("moveto ACTIVITY_CREATED: " + var1_1));
                        }
                        if (!var1_1.mFromLayout) {
                            var9_9 = null;
                            if (var1_1.mContainerId != 0) {
                                var10_11 = (ViewGroup)this.mContainer.findViewById(var1_1.mContainerId);
                                var9_9 = var10_11;
                                if (var10_11 == null) {
                                    var9_9 = var10_11;
                                    if (!var1_1.mRestored) {
                                        this.throwException(new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(var1_1.mContainerId) + " (" + var1_1.getResources().getResourceName(var1_1.mContainerId) + ") for fragment " + var1_1));
                                        var9_9 = var10_11;
                                    }
                                }
                            }
                            var1_1.mContainer = var9_9;
                            var1_1.mView = var1_1.performCreateView(var1_1.getLayoutInflater(var1_1.mSavedFragmentState), (ViewGroup)var9_9, var1_1.mSavedFragmentState);
                            if (var1_1.mView != null) {
                                var1_1.mInnerView = var1_1.mView;
                                var1_1.mView = NoSaveStateFrameLayout.wrap(var1_1.mView);
                                if (var9_9 != null) {
                                    var10_11 = this.loadAnimation(var1_1, var3_3, true, var4_4);
                                    if (var10_11 != null) {
                                        var1_1.mView.startAnimation((Animation)var10_11);
                                    }
                                    var9_9.addView(var1_1.mView);
                                }
                                if (var1_1.mHidden) {
                                    var1_1.mView.setVisibility(8);
                                }
                                var1_1.onViewCreated(var1_1.mView, var1_1.mSavedFragmentState);
                            } else {
                                var1_1.mInnerView = null;
                            }
                        }
                        var1_1.performActivityCreated(var1_1.mSavedFragmentState);
                        if (var1_1.mView != null) {
                            var1_1.restoreViewState(var1_1.mSavedFragmentState);
                        }
                        var1_1.mSavedFragmentState = null;
                        cfr_temp_0 = 2;
                        var8_8 = var6_6;
                        case 2: 
                        case 3: {
                            var7_7 = var8_8;
                            if (var8_8 <= 3) break;
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("moveto STARTED: " + var1_1));
                            }
                            var1_1.performStart();
                            var7_7 = var8_8;
                        }
                        case 4: 
                    }
                    break;
                } while (true);
                var6_6 = var7_7;
                if (var7_7 > 4) {
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v((String)"FragmentManager", (String)("moveto RESUMED: " + var1_1));
                    }
                    var1_1.mResumed = true;
                    var1_1.performResume();
                    var1_1.mSavedFragmentState = null;
                    var1_1.mSavedViewState = null;
                    var6_6 = var7_7;
                }
                break block69;
            }
            var6_6 = var2_2;
            if (var1_1.mState > var2_2) {
                switch (var1_1.mState) {
                    default: {
                        var6_6 = var2_2;
                        break;
                    }
                    case 5: {
                        if (var2_2 < 5) {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("movefrom RESUMED: " + var1_1));
                            }
                            var1_1.performPause();
                            var1_1.mResumed = false;
                        }
                    }
                    case 4: {
                        if (var2_2 < 4) {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("movefrom STARTED: " + var1_1));
                            }
                            var1_1.performStop();
                        }
                    }
                    case 3: {
                        if (var2_2 < 3) {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("movefrom STOPPED: " + var1_1));
                            }
                            var1_1.performReallyStop();
                        }
                    }
                    case 2: {
                        if (var2_2 < 2) {
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v((String)"FragmentManager", (String)("movefrom ACTIVITY_CREATED: " + var1_1));
                            }
                            if (var1_1.mView != null && !this.mActivity.isFinishing() && var1_1.mSavedViewState == null) {
                                this.saveFragmentViewState(var1_1);
                            }
                            var1_1.performDestroyView();
                            if (var1_1.mView != null && var1_1.mContainer != null) {
                                var10_12 = null;
                                var9_10 = var10_12;
                                if (this.mCurState > 0) {
                                    var9_10 = var10_12;
                                    if (!this.mDestroyed) {
                                        var9_10 = this.loadAnimation(var1_1, var3_3, false, var4_4);
                                    }
                                }
                                if (var9_10 != null) {
                                    var1_1.mAnimatingAway = var1_1.mView;
                                    var1_1.mStateAfterAnimating = var2_2;
                                    var9_10.setAnimationListener(new Animation.AnimationListener(){

                                        public void onAnimationEnd(Animation animation) {
                                            if (var1_1.mAnimatingAway != null) {
                                                var1_1.mAnimatingAway = null;
                                                FragmentManagerImpl.this.moveToState(var1_1, var1_1.mStateAfterAnimating, 0, 0, false);
                                            }
                                        }

                                        public void onAnimationRepeat(Animation animation) {
                                        }

                                        public void onAnimationStart(Animation animation) {
                                        }
                                    });
                                    var1_1.mView.startAnimation((Animation)var9_10);
                                }
                                var1_1.mContainer.removeView(var1_1.mView);
                            }
                            var1_1.mContainer = null;
                            var1_1.mView = null;
                            var1_1.mInnerView = null;
                        }
                    }
                    case 1: {
                        var6_6 = var2_2;
                        if (var2_2 >= 1) break;
                        if (this.mDestroyed && var1_1.mAnimatingAway != null) {
                            var9_10 = var1_1.mAnimatingAway;
                            var1_1.mAnimatingAway = null;
                            var9_10.clearAnimation();
                        }
                        if (var1_1.mAnimatingAway != null) {
                            var1_1.mStateAfterAnimating = var2_2;
                            var6_6 = 1;
                            break;
                        }
                        if (FragmentManagerImpl.DEBUG) {
                            Log.v((String)"FragmentManager", (String)("movefrom CREATED: " + var1_1));
                        }
                        if (!var1_1.mRetaining) {
                            var1_1.performDestroy();
                        }
                        var1_1.mCalled = false;
                        var1_1.onDetach();
                        if (!var1_1.mCalled) {
                            throw new SuperNotCalledException("Fragment " + var1_1 + " did not call through to super.onDetach()");
                        }
                        var6_6 = var2_2;
                        if (var5_5) break;
                        if (!var1_1.mRetaining) {
                            this.makeInactive(var1_1);
                            var6_6 = var2_2;
                            break;
                        }
                        var1_1.mActivity = null;
                        var1_1.mFragmentManager = null;
                        var6_6 = var2_2;
                    }
                }
            }
        }
        var1_1.mState = var6_6;
    }

    public void noteStateNotSaved() {
        this.mStateSaved = false;
    }

    public void performPendingDeferredStart(Fragment fragment) {
        block3: {
            block2: {
                if (!fragment.mDeferStart) break block2;
                if (!this.mExecutingActions) break block3;
                this.mHavePendingDeferredStart = true;
            }
            return;
        }
        fragment.mDeferStart = false;
        this.moveToState(fragment, this.mCurState, 0, 0, false);
    }

    @Override
    public void popBackStack() {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, -1, 0);
            }
        }, false);
    }

    @Override
    public void popBackStack(final int n2, final int n3) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad id: " + n2);
        }
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, null, n2, n3);
            }
        }, false);
    }

    @Override
    public void popBackStack(final String string2, final int n2) {
        this.enqueueAction(new Runnable(){

            @Override
            public void run() {
                FragmentManagerImpl.this.popBackStackState(FragmentManagerImpl.this.mActivity.mHandler, string2, -1, n2);
            }
        }, false);
    }

    @Override
    public boolean popBackStackImmediate() {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, null, -1, 0);
    }

    @Override
    public boolean popBackStackImmediate(int n2, int n3) {
        this.checkStateLoss();
        this.executePendingTransactions();
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad id: " + n2);
        }
        return this.popBackStackState(this.mActivity.mHandler, null, n2, n3);
    }

    @Override
    public boolean popBackStackImmediate(String string2, int n2) {
        this.checkStateLoss();
        this.executePendingTransactions();
        return this.popBackStackState(this.mActivity.mHandler, string2, -1, n2);
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean popBackStackState(Handler object, String object2, int n2, int n3) {
        if (this.mBackStack == null) {
            return false;
        }
        if (object2 == null && n2 < 0 && (n3 & 1) == 0) {
            n2 = this.mBackStack.size() - 1;
            if (n2 < 0) return false;
            this.mBackStack.remove(n2).popFromBackStack(true);
            this.reportBackStackChanged();
            return true;
        }
        int n4 = -1;
        if (object2 != null || n2 >= 0) {
            int n5;
            for (n5 = this.mBackStack.size() - 1; n5 >= 0; --n5) {
                object = this.mBackStack.get(n5);
                if (object2 != null && ((String)object2).equals(((BackStackRecord)object).getName()) || n2 >= 0 && n2 == ((BackStackRecord)object).mIndex) break;
            }
            if (n5 < 0) return false;
            n4 = n5;
            if ((n3 & 1) != 0) {
                n3 = n5 - 1;
                while (true) {
                    n4 = --n3;
                    if (n3 < 0) break;
                    object = this.mBackStack.get(n3);
                    if (object2 != null && ((String)object2).equals(((BackStackRecord)object).getName())) continue;
                    n4 = n3;
                    if (n2 < 0) break;
                    n4 = n3;
                    if (n2 != ((BackStackRecord)object).mIndex) break;
                }
            }
        }
        if (n4 == this.mBackStack.size() - 1) return false;
        object = new ArrayList();
        for (n2 = this.mBackStack.size() - 1; n2 > n4; --n2) {
            ((ArrayList)object).add(this.mBackStack.remove(n2));
        }
        n3 = ((ArrayList)object).size() - 1;
        n2 = 0;
        while (true) {
            if (n2 > n3) {
                this.reportBackStackChanged();
                return true;
            }
            if (DEBUG) {
                Log.v((String)TAG, (String)("Popping back stack state: " + ((ArrayList)object).get(n2)));
            }
            object2 = (BackStackRecord)((ArrayList)object).get(n2);
            boolean bl = n2 == n3;
            ((BackStackRecord)object2).popFromBackStack(bl);
            ++n2;
        }
    }

    @Override
    public void putFragment(Bundle bundle, String string2, Fragment fragment) {
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putInt(string2, fragment.mIndex);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void removeFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("remove: " + fragment + " nesting=" + fragment.mBackStackNesting));
        }
        int n4 = !fragment.isInBackStack() ? 1 : 0;
        if (!fragment.mDetached || n4 != 0) {
            if (this.mAdded != null) {
                this.mAdded.remove(fragment);
            }
            if (fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mAdded = false;
            fragment.mRemoving = true;
            n4 = n4 != 0 ? 0 : 1;
            this.moveToState(fragment, n4, n2, n3, false);
        }
    }

    @Override
    public void removeOnBackStackChangedListener(FragmentManager.OnBackStackChangedListener onBackStackChangedListener) {
        if (this.mBackStackChangeListeners != null) {
            this.mBackStackChangeListeners.remove(onBackStackChangedListener);
        }
    }

    void reportBackStackChanged() {
        if (this.mBackStackChangeListeners != null) {
            for (int i2 = 0; i2 < this.mBackStackChangeListeners.size(); ++i2) {
                this.mBackStackChangeListeners.get(i2).onBackStackChanged();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void restoreAllState(Parcelable parcelable, ArrayList<Fragment> object) {
        if (parcelable != null) {
            parcelable = (FragmentManagerState)parcelable;
            if (parcelable.mActive != null) {
                Object object2;
                Object object3;
                int n2;
                if (object != null) {
                    for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                        object3 = (Fragment)((ArrayList)object).get(n2);
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("restoreAllState: re-attaching retained " + object3));
                        }
                        object2 = parcelable.mActive[((Fragment)object3).mIndex];
                        ((FragmentState)object2).mInstance = object3;
                        ((Fragment)object3).mSavedViewState = null;
                        ((Fragment)object3).mBackStackNesting = 0;
                        ((Fragment)object3).mInLayout = false;
                        ((Fragment)object3).mAdded = false;
                        ((Fragment)object3).mTarget = null;
                        if (((FragmentState)object2).mSavedFragmentState == null) continue;
                        ((FragmentState)object2).mSavedFragmentState.setClassLoader(this.mActivity.getClassLoader());
                        ((Fragment)object3).mSavedViewState = ((FragmentState)object2).mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_TAG);
                    }
                }
                this.mActive = new ArrayList(parcelable.mActive.length);
                if (this.mAvailIndices != null) {
                    this.mAvailIndices.clear();
                }
                for (n2 = 0; n2 < parcelable.mActive.length; ++n2) {
                    object3 = parcelable.mActive[n2];
                    if (object3 != null) {
                        object2 = ((FragmentState)object3).instantiate(this.mActivity, this.mParent);
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("restoreAllState: active #" + n2 + ": " + object2));
                        }
                        this.mActive.add((Fragment)object2);
                        ((FragmentState)object3).mInstance = null;
                        continue;
                    }
                    this.mActive.add(null);
                    if (this.mAvailIndices == null) {
                        this.mAvailIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("restoreAllState: avail #" + n2));
                    }
                    this.mAvailIndices.add(n2);
                }
                if (object != null) {
                    for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                        object3 = (Fragment)((ArrayList)object).get(n2);
                        if (((Fragment)object3).mTargetIndex < 0) continue;
                        if (((Fragment)object3).mTargetIndex < this.mActive.size()) {
                            ((Fragment)object3).mTarget = this.mActive.get(((Fragment)object3).mTargetIndex);
                            continue;
                        }
                        Log.w((String)TAG, (String)("Re-attaching retained fragment " + object3 + " target no longer exists: " + ((Fragment)object3).mTargetIndex));
                        ((Fragment)object3).mTarget = null;
                    }
                }
                if (parcelable.mAdded == null) {
                    this.mAdded = null;
                } else {
                    this.mAdded = new ArrayList(parcelable.mAdded.length);
                    for (n2 = 0; n2 < parcelable.mAdded.length; ++n2) {
                        object = this.mActive.get(parcelable.mAdded[n2]);
                        if (object == null) {
                            this.throwException(new IllegalStateException("No instantiated fragment for index #" + parcelable.mAdded[n2]));
                        }
                        ((Fragment)object).mAdded = true;
                        if (DEBUG) {
                            Log.v((String)TAG, (String)("restoreAllState: added #" + n2 + ": " + object));
                        }
                        if (this.mAdded.contains(object)) {
                            throw new IllegalStateException("Already added!");
                        }
                        this.mAdded.add((Fragment)object);
                    }
                }
                if (parcelable.mBackStack == null) {
                    this.mBackStack = null;
                    return;
                }
                this.mBackStack = new ArrayList(parcelable.mBackStack.length);
                for (n2 = 0; n2 < parcelable.mBackStack.length; ++n2) {
                    object = parcelable.mBackStack[n2].instantiate(this);
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("restoreAllState: back stack #" + n2 + " (index " + ((BackStackRecord)object).mIndex + "): " + object));
                        ((BackStackRecord)object).dump("  ", new PrintWriter(new LogWriter(TAG)), false);
                    }
                    this.mBackStack.add((BackStackRecord)object);
                    if (((BackStackRecord)object).mIndex < 0) continue;
                    this.setBackStackIndex(((BackStackRecord)object).mIndex, (BackStackRecord)object);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    ArrayList<Fragment> retainNonConfig() {
        ArrayList<Fragment> arrayList = null;
        ArrayList<Fragment> arrayList2 = null;
        if (this.mActive == null) return arrayList;
        int n2 = 0;
        while (true) {
            arrayList = arrayList2;
            if (n2 >= this.mActive.size()) {
                return arrayList;
            }
            Fragment fragment = this.mActive.get(n2);
            ArrayList<Fragment> arrayList3 = arrayList2;
            if (fragment != null) {
                arrayList3 = arrayList2;
                if (fragment.mRetainInstance) {
                    arrayList = arrayList2;
                    if (arrayList2 == null) {
                        arrayList = new ArrayList<Fragment>();
                    }
                    arrayList.add(fragment);
                    fragment.mRetaining = true;
                    int n3 = fragment.mTarget != null ? fragment.mTarget.mIndex : -1;
                    fragment.mTargetIndex = n3;
                    arrayList3 = arrayList;
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("retainNonConfig: keeping retained " + fragment));
                        arrayList3 = arrayList;
                    }
                }
            }
            ++n2;
            arrayList2 = arrayList3;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    Parcelable saveAllState() {
        BackStackState[] backStackStateArray;
        Object object;
        int n2;
        int n3;
        FragmentState[] fragmentStateArray;
        block25: {
            block26: {
                block22: {
                    this.execPendingActions();
                    if (HONEYCOMB) {
                        this.mStateSaved = true;
                    }
                    if (this.mActive == null || this.mActive.size() <= 0) break block22;
                    int n4 = this.mActive.size();
                    fragmentStateArray = new FragmentState[n4];
                    n3 = 0;
                    for (n2 = 0; n2 < n4; ++n2) {
                        int n5;
                        block24: {
                            block23: {
                                object = this.mActive.get(n2);
                                if (object == null) continue;
                                if (((Fragment)object).mIndex < 0) {
                                    this.throwException(new IllegalStateException("Failure saving state: active " + object + " has cleared index: " + ((Fragment)object).mIndex));
                                }
                                n5 = 1;
                                backStackStateArray = new FragmentState((Fragment)object);
                                fragmentStateArray[n2] = backStackStateArray;
                                if (((Fragment)object).mState <= 0 || backStackStateArray.mSavedFragmentState != null) break block23;
                                backStackStateArray.mSavedFragmentState = this.saveFragmentBasicState((Fragment)object);
                                if (((Fragment)object).mTarget != null) {
                                    if (((Fragment)object).mTarget.mIndex < 0) {
                                        this.throwException(new IllegalStateException("Failure saving state: " + object + " has target not in fragment manager: " + ((Fragment)object).mTarget));
                                    }
                                    if (backStackStateArray.mSavedFragmentState == null) {
                                        backStackStateArray.mSavedFragmentState = new Bundle();
                                    }
                                    this.putFragment(backStackStateArray.mSavedFragmentState, TARGET_STATE_TAG, ((Fragment)object).mTarget);
                                    if (((Fragment)object).mTargetRequestCode != 0) {
                                        backStackStateArray.mSavedFragmentState.putInt(TARGET_REQUEST_CODE_STATE_TAG, ((Fragment)object).mTargetRequestCode);
                                    }
                                }
                                break block24;
                            }
                            backStackStateArray.mSavedFragmentState = ((Fragment)object).mSavedFragmentState;
                        }
                        n3 = n5;
                        if (!DEBUG) continue;
                        Log.v((String)TAG, (String)("Saved state of " + object + ": " + backStackStateArray.mSavedFragmentState));
                        n3 = n5;
                    }
                    if (n3 != 0) break block25;
                    if (DEBUG) break block26;
                }
                return null;
            }
            Log.v((String)TAG, (String)"saveAllState: no fragments!");
            return null;
        }
        backStackStateArray = null;
        BackStackState[] backStackStateArray2 = null;
        object = backStackStateArray;
        if (this.mAdded != null) {
            n3 = this.mAdded.size();
            object = backStackStateArray;
            if (n3 > 0) {
                backStackStateArray = (BackStackState[])new int[n3];
                n2 = 0;
                while (true) {
                    object = backStackStateArray;
                    if (n2 >= n3) break;
                    backStackStateArray[n2] = (BackStackState)this.mAdded.get((int)n2).mIndex;
                    if (backStackStateArray[n2] < 0) {
                        this.throwException(new IllegalStateException("Failure saving state: active " + this.mAdded.get(n2) + " has cleared index: " + (int)backStackStateArray[n2]));
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("saveAllState: adding fragment #" + n2 + ": " + this.mAdded.get(n2)));
                    }
                    ++n2;
                }
            }
        }
        backStackStateArray = backStackStateArray2;
        if (this.mBackStack != null) {
            n3 = this.mBackStack.size();
            backStackStateArray = backStackStateArray2;
            if (n3 > 0) {
                backStackStateArray2 = new BackStackState[n3];
                n2 = 0;
                while (true) {
                    backStackStateArray = backStackStateArray2;
                    if (n2 >= n3) break;
                    backStackStateArray2[n2] = new BackStackState(this, this.mBackStack.get(n2));
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("saveAllState: adding back stack #" + n2 + ": " + this.mBackStack.get(n2)));
                    }
                    ++n2;
                }
            }
        }
        backStackStateArray2 = new FragmentManagerState();
        backStackStateArray2.mActive = fragmentStateArray;
        backStackStateArray2.mAdded = (int[])object;
        backStackStateArray2.mBackStack = backStackStateArray;
        return backStackStateArray2;
    }

    Bundle saveFragmentBasicState(Fragment fragment) {
        Bundle bundle = null;
        if (this.mStateBundle == null) {
            this.mStateBundle = new Bundle();
        }
        fragment.performSaveInstanceState(this.mStateBundle);
        if (!this.mStateBundle.isEmpty()) {
            bundle = this.mStateBundle;
            this.mStateBundle = null;
        }
        if (fragment.mView != null) {
            this.saveFragmentViewState(fragment);
        }
        Bundle bundle2 = bundle;
        if (fragment.mSavedViewState != null) {
            bundle2 = bundle;
            if (bundle == null) {
                bundle2 = new Bundle();
            }
            bundle2.putSparseParcelableArray(VIEW_STATE_TAG, fragment.mSavedViewState);
        }
        bundle = bundle2;
        if (!fragment.mUserVisibleHint) {
            bundle = bundle2;
            if (bundle2 == null) {
                bundle = new Bundle();
            }
            bundle.putBoolean(USER_VISIBLE_HINT_TAG, fragment.mUserVisibleHint);
        }
        return bundle;
    }

    @Override
    public Fragment.SavedState saveFragmentInstanceState(Fragment fragment) {
        Fragment.SavedState savedState = null;
        if (fragment.mIndex < 0) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        Fragment.SavedState savedState2 = savedState;
        if (fragment.mState > 0) {
            fragment = this.saveFragmentBasicState(fragment);
            savedState2 = savedState;
            if (fragment != null) {
                savedState2 = new Fragment.SavedState((Bundle)fragment);
            }
        }
        return savedState2;
    }

    /*
     * Enabled aggressive block sorting
     */
    void saveFragmentViewState(Fragment fragment) {
        block6: {
            block5: {
                if (fragment.mInnerView == null) break block5;
                if (this.mStateArray == null) {
                    this.mStateArray = new SparseArray();
                } else {
                    this.mStateArray.clear();
                }
                fragment.mInnerView.saveHierarchyState(this.mStateArray);
                if (this.mStateArray.size() > 0) break block6;
            }
            return;
        }
        fragment.mSavedViewState = this.mStateArray;
        this.mStateArray = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setBackStackIndex(int n2, BackStackRecord backStackRecord) {
        synchronized (this) {
            int n3;
            if (this.mBackStackIndices == null) {
                this.mBackStackIndices = new ArrayList();
            }
            if (n2 < n3) {
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Setting back stack index " + n2 + " to " + backStackRecord));
                }
                this.mBackStackIndices.set(n2, backStackRecord);
            } else {
                for (int i2 = n3 = this.mBackStackIndices.size(); i2 < n2; ++i2) {
                    this.mBackStackIndices.add(null);
                    if (this.mAvailBackStackIndices == null) {
                        this.mAvailBackStackIndices = new ArrayList();
                    }
                    if (DEBUG) {
                        Log.v((String)TAG, (String)("Adding available back stack index " + i2));
                    }
                    this.mAvailBackStackIndices.add(i2);
                }
                if (DEBUG) {
                    Log.v((String)TAG, (String)("Adding back stack index " + n2 + " with " + backStackRecord));
                }
                this.mBackStackIndices.add(backStackRecord);
            }
            return;
        }
    }

    public void showFragment(Fragment fragment, int n2, int n3) {
        if (DEBUG) {
            Log.v((String)TAG, (String)("show: " + fragment));
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            if (fragment.mView != null) {
                Animation animation = this.loadAnimation(fragment, n2, true, n3);
                if (animation != null) {
                    fragment.mView.startAnimation(animation);
                }
                fragment.mView.setVisibility(0);
            }
            if (fragment.mAdded && fragment.mHasMenu && fragment.mMenuVisible) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.onHiddenChanged(false);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void startPendingDeferredFragments() {
        if (this.mActive != null) {
            for (int i2 = 0; i2 < this.mActive.size(); ++i2) {
                Fragment fragment = this.mActive.get(i2);
                if (fragment == null) continue;
                this.performPendingDeferredStart(fragment);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("FragmentManager{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(" in ");
        if (this.mParent != null) {
            DebugUtils.buildShortClassTag(this.mParent, stringBuilder);
        } else {
            DebugUtils.buildShortClassTag((Object)this.mActivity, stringBuilder);
        }
        stringBuilder.append("}}");
        return stringBuilder.toString();
    }
}

