/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.app;

import android.app.Activity;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.v4.app.ActionBarDrawerToggleHoneycomb;
import android.support.v4.widget.DrawerLayout;
import android.view.MenuItem;
import android.view.View;

public class ActionBarDrawerToggle
implements DrawerLayout.DrawerListener {
    private static final int ID_HOME = 16908332;
    private static final ActionBarDrawerToggleImpl IMPL = Build.VERSION.SDK_INT >= 11 ? new ActionBarDrawerToggleImplHC() : new ActionBarDrawerToggleImplBase();
    private final Activity mActivity;
    private final int mCloseDrawerContentDescRes;
    private Drawable mDrawerImage;
    private final int mDrawerImageResource;
    private boolean mDrawerIndicatorEnabled = true;
    private final DrawerLayout mDrawerLayout;
    private final int mOpenDrawerContentDescRes;
    private Object mSetIndicatorInfo;
    private SlideDrawable mSlider;
    private Drawable mThemeImage;

    public ActionBarDrawerToggle(Activity activity, DrawerLayout drawerLayout, int n2, int n3, int n4) {
        this.mActivity = activity;
        this.mDrawerLayout = drawerLayout;
        this.mDrawerImageResource = n2;
        this.mOpenDrawerContentDescRes = n3;
        this.mCloseDrawerContentDescRes = n4;
        this.mThemeImage = IMPL.getThemeUpIndicator(activity);
        this.mDrawerImage = activity.getResources().getDrawable(n2);
        this.mSlider = new SlideDrawable(this.mDrawerImage);
        this.mSlider.setOffsetBy(0.33333334f);
    }

    public boolean isDrawerIndicatorEnabled() {
        return this.mDrawerIndicatorEnabled;
    }

    public void onConfigurationChanged(Configuration configuration) {
        this.mThemeImage = IMPL.getThemeUpIndicator(this.mActivity);
        this.mDrawerImage = this.mActivity.getResources().getDrawable(this.mDrawerImageResource);
        this.syncState();
    }

    @Override
    public void onDrawerClosed(View view) {
        this.mSlider.setOffset(0.0f);
        if (this.mDrawerIndicatorEnabled) {
            this.mSetIndicatorInfo = IMPL.setActionBarDescription(this.mSetIndicatorInfo, this.mActivity, this.mCloseDrawerContentDescRes);
        }
    }

    @Override
    public void onDrawerOpened(View view) {
        this.mSlider.setOffset(1.0f);
        if (this.mDrawerIndicatorEnabled) {
            this.mSetIndicatorInfo = IMPL.setActionBarDescription(this.mSetIndicatorInfo, this.mActivity, this.mOpenDrawerContentDescRes);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onDrawerSlide(View view, float f2) {
        float f3 = this.mSlider.getOffset();
        f2 = f2 > 0.5f ? Math.max(f3, Math.max(0.0f, f2 - 0.5f) * 2.0f) : Math.min(f3, f2 * 2.0f);
        this.mSlider.setOffset(f2);
    }

    @Override
    public void onDrawerStateChanged(int n2) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        block4: {
            block3: {
                if (menuItem == null || menuItem.getItemId() != 16908332 || !this.mDrawerIndicatorEnabled) break block3;
                if (!this.mDrawerLayout.isDrawerVisible(0x800003)) break block4;
                this.mDrawerLayout.closeDrawer(0x800003);
            }
            return false;
        }
        this.mDrawerLayout.openDrawer(0x800003);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDrawerIndicatorEnabled(boolean bl) {
        if (bl != this.mDrawerIndicatorEnabled) {
            if (bl) {
                ActionBarDrawerToggleImpl actionBarDrawerToggleImpl = IMPL;
                Object object = this.mSetIndicatorInfo;
                Activity activity = this.mActivity;
                SlideDrawable slideDrawable = this.mSlider;
                int n2 = this.mDrawerLayout.isDrawerOpen(0x800003) ? this.mOpenDrawerContentDescRes : this.mCloseDrawerContentDescRes;
                this.mSetIndicatorInfo = actionBarDrawerToggleImpl.setActionBarUpIndicator(object, activity, slideDrawable, n2);
            } else {
                this.mSetIndicatorInfo = IMPL.setActionBarUpIndicator(this.mSetIndicatorInfo, this.mActivity, this.mThemeImage, 0);
            }
            this.mDrawerIndicatorEnabled = bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void syncState() {
        if (this.mDrawerLayout.isDrawerOpen(0x800003)) {
            this.mSlider.setOffset(1.0f);
        } else {
            this.mSlider.setOffset(0.0f);
        }
        if (this.mDrawerIndicatorEnabled) {
            ActionBarDrawerToggleImpl actionBarDrawerToggleImpl = IMPL;
            Object object = this.mSetIndicatorInfo;
            Activity activity = this.mActivity;
            SlideDrawable slideDrawable = this.mSlider;
            int n2 = this.mDrawerLayout.isDrawerOpen(0x800003) ? this.mOpenDrawerContentDescRes : this.mCloseDrawerContentDescRes;
            this.mSetIndicatorInfo = actionBarDrawerToggleImpl.setActionBarUpIndicator(object, activity, slideDrawable, n2);
        }
    }

    private static interface ActionBarDrawerToggleImpl {
        public Drawable getThemeUpIndicator(Activity var1);

        public Object setActionBarDescription(Object var1, Activity var2, int var3);

        public Object setActionBarUpIndicator(Object var1, Activity var2, Drawable var3, int var4);
    }

    private static class ActionBarDrawerToggleImplBase
    implements ActionBarDrawerToggleImpl {
        private ActionBarDrawerToggleImplBase() {
        }

        @Override
        public Drawable getThemeUpIndicator(Activity activity) {
            return null;
        }

        @Override
        public Object setActionBarDescription(Object object, Activity activity, int n2) {
            return object;
        }

        @Override
        public Object setActionBarUpIndicator(Object object, Activity activity, Drawable drawable2, int n2) {
            return object;
        }
    }

    private static class ActionBarDrawerToggleImplHC
    implements ActionBarDrawerToggleImpl {
        private ActionBarDrawerToggleImplHC() {
        }

        @Override
        public Drawable getThemeUpIndicator(Activity activity) {
            return ActionBarDrawerToggleHoneycomb.getThemeUpIndicator(activity);
        }

        @Override
        public Object setActionBarDescription(Object object, Activity activity, int n2) {
            return ActionBarDrawerToggleHoneycomb.setActionBarDescription(object, activity, n2);
        }

        @Override
        public Object setActionBarUpIndicator(Object object, Activity activity, Drawable drawable2, int n2) {
            return ActionBarDrawerToggleHoneycomb.setActionBarUpIndicator(object, activity, drawable2, n2);
        }
    }

    private static class SlideDrawable
    extends Drawable
    implements Drawable.Callback {
        private float mOffset;
        private float mOffsetBy;
        private final Rect mTmpRect = new Rect();
        private Drawable mWrapped;

        public SlideDrawable(Drawable drawable2) {
            this.mWrapped = drawable2;
        }

        public void clearColorFilter() {
            this.mWrapped.clearColorFilter();
        }

        public void draw(Canvas canvas) {
            this.mWrapped.copyBounds(this.mTmpRect);
            canvas.save();
            canvas.translate(this.mOffsetBy * (float)this.mTmpRect.width() * -this.mOffset, 0.0f);
            this.mWrapped.draw(canvas);
            canvas.restore();
        }

        public int getChangingConfigurations() {
            return this.mWrapped.getChangingConfigurations();
        }

        public Drawable.ConstantState getConstantState() {
            return super.getConstantState();
        }

        public Drawable getCurrent() {
            return this.mWrapped.getCurrent();
        }

        public int getIntrinsicHeight() {
            return this.mWrapped.getIntrinsicHeight();
        }

        public int getIntrinsicWidth() {
            return this.mWrapped.getIntrinsicWidth();
        }

        public int getMinimumHeight() {
            return this.mWrapped.getMinimumHeight();
        }

        public int getMinimumWidth() {
            return this.mWrapped.getMinimumWidth();
        }

        public float getOffset() {
            return this.mOffset;
        }

        public int getOpacity() {
            return this.mWrapped.getOpacity();
        }

        public boolean getPadding(Rect rect) {
            return this.mWrapped.getPadding(rect);
        }

        public int[] getState() {
            return this.mWrapped.getState();
        }

        public Region getTransparentRegion() {
            return this.mWrapped.getTransparentRegion();
        }

        public void invalidateDrawable(Drawable drawable2) {
            if (drawable2 == this.mWrapped) {
                this.invalidateSelf();
            }
        }

        public boolean isStateful() {
            return this.mWrapped.isStateful();
        }

        protected void onBoundsChange(Rect rect) {
            super.onBoundsChange(rect);
            this.mWrapped.setBounds(rect);
        }

        protected boolean onStateChange(int[] nArray) {
            this.mWrapped.setState(nArray);
            return super.onStateChange(nArray);
        }

        public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l2) {
            if (drawable2 == this.mWrapped) {
                this.scheduleSelf(runnable, l2);
            }
        }

        public void setAlpha(int n2) {
            this.mWrapped.setAlpha(n2);
        }

        public void setChangingConfigurations(int n2) {
            this.mWrapped.setChangingConfigurations(n2);
        }

        public void setColorFilter(int n2, PorterDuff.Mode mode) {
            this.mWrapped.setColorFilter(n2, mode);
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.mWrapped.setColorFilter(colorFilter);
        }

        public void setDither(boolean bl) {
            this.mWrapped.setDither(bl);
        }

        public void setFilterBitmap(boolean bl) {
            this.mWrapped.setFilterBitmap(bl);
        }

        public void setOffset(float f2) {
            this.mOffset = f2;
            this.invalidateSelf();
        }

        public void setOffsetBy(float f2) {
            this.mOffsetBy = f2;
            this.invalidateSelf();
        }

        public boolean setState(int[] nArray) {
            return this.mWrapped.setState(nArray);
        }

        public boolean setVisible(boolean bl, boolean bl2) {
            return super.setVisible(bl, bl2);
        }

        public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
            if (drawable2 == this.mWrapped) {
                this.unscheduleSelf(runnable);
            }
        }
    }
}

