﻿
using System;
using fomm.Scripting;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Windows.Forms;
using System.Globalization;
using System.Collections.Generic;

class Script : SkyrimBaseScript {

	static Version SKSE_MIN_VERSION = new Version("0.1.6.9");

	// Main dialog
	static Form mainInstallForm;
	static TextBox textArea;
	static Button refreshButton;
	static Button installButton;
	static Button cancelButton;

	static string[] checkedLooseFiles = {
		"Scripts/SKI_ActiveEffectsWidget.pex",
		"Scripts/SKI_ConfigBase.pex",
		"Scripts/SKI_ConfigManager.pex",
		"Scripts/SKI_Main.pex",
		"Scripts/SKI_MeterWidget.pex",
		"Scripts/SKI_PlayerLoadGameAlias.pex",
		"Scripts/SKI_QuestBase.pex",
		"Scripts/SKI_StatusWidget.pex",
		"Scripts/SKI_WidgetBase.pex",
		"Scripts/SKI_WidgetManager.pex",
		"Interface/skyui_cfg.txt",
		"Interface/skyui_translate.txt",
		"Interface/bartermenu.swf",
		"Interface/containermenu.swf",
		"Interface/inventorymenu.swf",
		"Interface/magicmenu.swf",
		"Interface/skyui/inventorylists.swf",
		"Interface/skyui/tabbedinventorylists.swf",
		"Interface/skyui/skyui_icons_cat.swf",
		"Interface/skyui/skyui_icons_inv.swf",
		"Interface/skyui/skyui_icons_magic.swf"
	};

	static bool install = false;

	static int problemCount = 0;

	static List<string> foundLooseFiles = new List<string>();

	static bool noSKSE = false;
	static bool noSKSEScripts = false;
	static Version skseVersion;
	
	public static bool OnActivate()
	{
		DetectProblems();

		// Detected problems? Show report. Otherwise just install
		if (problemCount > 0) {
			InitializeComponents();
			mainInstallForm.ShowDialog(); 
		} else {
			install = true;
		}
				
		if (install)
			PerformBasicInstall();
		
		return install;
	}

	static void DetectProblems()
	{
		// Clean up previous data
		problemCount = 0;
		foundLooseFiles.Clear();
		noSKSE = false;
		noSKSEScripts = false;
		skseVersion = new Version();


		// 1. Check Loose files
 		foreach (string file in checkedLooseFiles)
 			if (GetExistingDataFile(file) != null)
 				foundLooseFiles.Add(file);

 		if (foundLooseFiles.Count > 0)
 			problemCount++;

 		// 2. Check if skse is present
 		noSKSE = !ScriptExtenderPresent();
 		if (noSKSE)
 			problemCount++;

		// 3. Check SKSE version
 		skseVersion = GetSkseVersion();
 		if (skseVersion == null || skseVersion < SKSE_MIN_VERSION)
 			problemCount++;

		// 4. Check missing SKSE.pex
		if (GetExistingDataFile("Scripts/SKSE.pex") == null) {
 			noSKSEScripts = true;
 			problemCount++;
 		}
	}

	static void GenerateReport()
	{
		int c = 0;
		textArea.Clear();

		if (problemCount == 0) {
			PrintReport("所有问题已解决。");
			return;
		}

		PrintReport("本报告包含了 SkyUI 安装中出现的问题。");
		PrintReport("");
		PrintReport("请解决以下问题，然后按 '刷新' 键重新检查。");
		PrintReport("所有问题解决后将继续安装。");
		PrintReport("");

		if (foundLooseFiles.Count > 0) {
			c++;
			PrintReport("-----------");
			PrintReport("问题 #" + c + "：");
			PrintReport("-----------");
			PrintReport(" 'Data' 目录下存在以下独立文件, 将会覆盖 SkyUI.bsa 压缩包中的新版本。");
			PrintReport("");
			PrintReport("文件名：");
 			foreach (string file in foundLooseFiles)
	 			PrintReport("\tData/" + file);
			PrintReport("");
	 		PrintReport("可能原因：");
	 		PrintReport("* 安装新版之前没有卸载旧版的 SkyUI 。");
	 		PrintReport("");
	 		PrintReport("解决方法：");
	 		PrintReport("1. 如果通过NMM安装了旧版本的 SkyUI，请卸载后重试。");
	 		PrintReport("2. 如果仍然报告文件存在，请手动删除。");
	 		PrintReport("");
		}

		if (noSKSE) {
			c++;
			PrintReport("-----------");
			PrintReport("问题 #" + c + "：");
			PrintReport("-----------");
			PrintReport("天际脚本扩展 (SKSE) 没有安装。");
	 		PrintReport("");
	 		PrintReport("解决方法：");
			PrintReport("1. 从 'http://skse.silverlock.org/' 下载最新版本并安装。");
			PrintReport("   如果安装时出现问题，请参照以下视频：");
			PrintReport("   http://www.youtube.com/watch?v=xTGnQIiNVqA");

		} else if (skseVersion == null || skseVersion < SKSE_MIN_VERSION) {
			c++;
			PrintReport("-----------");
			PrintReport("问题 #" + c + "：");
			PrintReport("-----------");
			PrintReport("天际脚本扩展 (SKSE) 版本过旧。");
			PrintReport("");
			PrintReport("当前版本：" + skseVersion);
			PrintReport("需求版本：" + SKSE_MIN_VERSION + " (或更新)");
	 		PrintReport("");
	 		PrintReport("解决方法：");
			PrintReport("1. 从 'http://skse.silverlock.org/' 下载最新版本并安装。");
			PrintReport("   如果安装时出现问题，请参照以下视频：");
			PrintReport("   http://www.youtube.com/watch?v=xTGnQIiNVqA");

		} else if (noSKSEScripts) {
			c++;
			PrintReport("-----------");
			PrintReport("问题 #" + c + "：");
			PrintReport("-----------");
			PrintReport("天际脚本扩展 (SKSE) 脚本缺失。");
			PrintReport("");
			PrintReport("可能原因：");
	 		PrintReport("* 没有完整安装 SKSE 的脚本。");
	 		PrintReport("");
	 		PrintReport("解决方法：");
			PrintReport("1. 重新安装 SKSE。确保从下载回来的压缩包中解压 'Data/' 目录到游戏安装目录下并覆盖存在的文件。");
		}
		

	}

	static void PrintReport(string line)
	{
		textArea.AppendText(line + "\n");
	}
	
	static void InitializeComponents()
	{
        textArea = new System.Windows.Forms.TextBox();
        refreshButton = new System.Windows.Forms.Button();
        installButton = new System.Windows.Forms.Button();
        cancelButton = new System.Windows.Forms.Button();

        // 
        // textArea
        // 
        textArea.BackColor = System.Drawing.SystemColors.ControlLightLight;
        textArea.Location = new System.Drawing.Point(12, 12);
        textArea.Font = new System.Drawing.Font("宋体", 9F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
        textArea.Multiline = true;
        textArea.Name = "textArea";
        textArea.ReadOnly = true;
        textArea.ScrollBars = System.Windows.Forms.ScrollBars.Both;
		textArea.Size = new System.Drawing.Size(610, 439);
        textArea.TabIndex = 0;
        // 
        // refreshButton
        // 
		refreshButton.Location = new System.Drawing.Point(280, 457);
        refreshButton.Name = "refreshButton";
        refreshButton.Size = new System.Drawing.Size(75, 23);
        refreshButton.TabIndex = 1;
        refreshButton.Text = "刷新";
        refreshButton.UseVisualStyleBackColor = true;
        refreshButton.Click += new System.EventHandler(refreshButton_Click);
        // 
        // installButton
        // 
		installButton.Location = new System.Drawing.Point(547, 457);
        installButton.Name = "installButton";
        installButton.Size = new System.Drawing.Size(75, 23);
        installButton.TabIndex = 2;
        installButton.Text = "安装";
        installButton.UseVisualStyleBackColor = true;
        installButton.Click += new System.EventHandler(installButton_Click);
        // 
        // cancelButton
        // 
		cancelButton.Location = new System.Drawing.Point(12, 457);
        cancelButton.Name = "cancelButton";
        cancelButton.Size = new System.Drawing.Size(75, 23);
        cancelButton.TabIndex = 3;
        cancelButton.Text = "取消";
        cancelButton.UseVisualStyleBackColor = true;
        cancelButton.Click += new System.EventHandler(cancelButton_Click);
        // 
        // mainInstallForm
        // 
		mainInstallForm = CreateCustomForm();
        mainInstallForm.AutoScaleDimensions = new System.Drawing.SizeF(6F, 13F);
        mainInstallForm.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
		mainInstallForm.ClientSize = new System.Drawing.Size(634, 492);
        mainInstallForm.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedSingle;
        mainInstallForm.MaximizeBox = false;
		mainInstallForm.MinimizeBox = false;
        mainInstallForm.Controls.Add(installButton);
        mainInstallForm.Controls.Add(refreshButton);
        mainInstallForm.Controls.Add(cancelButton);
        mainInstallForm.Controls.Add(textArea);
        mainInstallForm.Name = "mainInstallForm";
        mainInstallForm.Text = "SkyUI 问题报告";
        mainInstallForm.Load += new System.EventHandler(mainInstallForm_Load);
	}
	
	static void installButton_Click(object sender, EventArgs e)
	{
		install = true;
		mainInstallForm.Close();
	}

	static void refreshButton_Click(object sender, EventArgs e)
	{
		DetectProblems();
		GenerateReport();
	}

	static void cancelButton_Click(object sender, EventArgs e)
	{
		install = false;
		mainInstallForm.Close();
	}

	static void mainInstallForm_Load(object sender, EventArgs e)
	{
		GenerateReport();
	}
	
	static bool IsPluginActive(String pluginName)
	{  	
		string[] loadOrder = GetActivePlugins();  
		for (int i = 0; i < loadOrder.Length; ++i) {  
			if (loadOrder[i].Equals(pluginName, StringComparison.InvariantCultureIgnoreCase)) {
				 return true;  
			}
		}  
	
		return false;  
	}
}
