#include "skse/PluginAPI.h"
#include "skse/skse_version.h"
#include "skse/SafeWrite.h"
#include "skse/GameAPI.h"

PluginHandle	g_pluginHandle = kPluginHandle_Invalid;

#include "Adapter.h"
#include "Configs.h"
#include "log.h"
#include <fstream>
#include <detours.h>

typedef void (* _RegisterPapyrusFunctions)(VMClassRegistry ** registry);
auto OLD_RegisterPapyrusFunctions = (_RegisterPapyrusFunctions)0x008F9720;

void MyRegisterPapyrusFunctions(VMClassRegistry ** registry)
{
	OLD_RegisterPapyrusFunctions(registry);
	RegisterFunctions(*registry);
	LogDebug("API Registed!!");
}


BOOL WINAPI DllMain(HANDLE hDllHandle, DWORD dwReason, LPVOID lpreserved)
{
	switch(dwReason)
	{
	case DLL_PROCESS_ATTACH:
		Configs::ReloadAll();
		g_Log->SetLevel(Configs::logLevel);
		
		DisableThreadLibraryCalls((HMODULE)hDllHandle);
		DetourRestoreAfterWith();  
		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());

		DetourAttach((void**)&OLD_RegisterPapyrusFunctions, MyRegisterPapyrusFunctions);

		DetourTransactionCommit();

		LogDebug("Hooked!!");

		break;

	case DLL_PROCESS_DETACH:
		
		DetourTransactionBegin();
		DetourUpdateThread(GetCurrentThread());
		
		DetourDetach((void**)&OLD_RegisterPapyrusFunctions, MyRegisterPapyrusFunctions);
		
		DetourTransactionCommit();

		Adapter::Release();

		break;
	};

	return TRUE;
}

extern "C"
{

bool SKSEPlugin_Query(const SKSEInterface * skse, PluginInfo * info)
{
	LogRaw(PLUGIN_NAME);

	// populate info structure
	info->infoVersion =	PluginInfo::kInfoVersion;
	info->name =		PLUGIN_NAME;
	info->version =		1;

	// store plugin handle so we can identify ourselves later
	g_pluginHandle = skse->GetPluginHandle();

	if(skse->isEditor)
	{
		LogError("loaded in editor, marking as incompatible");

		return false;
	}
	else if(skse->runtimeVersion < RUNTIME_VERSION_1_9_32_0)
	{
		LogError("unsupported runtime version %08X", skse->runtimeVersion);

		return false;
	}

	if(Adapter::Initialize())
	{
		LogError("Thread initialize failed... Something trouble with Oerating System?");
		return false;
	}
	// ### do not do anything else in this callback
	// ### only fill out PluginInfo and return true/false

	// supported runtime version
	LogInfo("Queue OK");
	return true;
}

bool SKSEPlugin_Load(const SKSEInterface * skse)
{
	LogInfo("SKSEPlugin_Load");
	return true;
}

};
