#pragma once

#include "Thread.h"
#include <iostream>
#include <fstream>

class Logger : Lockable
{
public:
	
	enum LOGLEVEL{
		LOG_NONE,
		LOG_ERROR,
		LOG_WARNING,
		LOG_INFO,
		LOG_DEBUG
	};

	Logger():out(stderr), i_maxLevel(LOG_INFO){}
	Logger(const char* path);

	void SetLevel(int level){i_maxLevel = level;}	
	void Write( int level, const char* fmt, ... );
	void WriteRaw(const char* fmt, ...);
	
private:

	int i_maxLevel;
	char buffer[2000];
	FILE* out;
};

extern Logger* g_Log;

#define LogRaw( fmt, ... ) g_Log->WriteRaw( fmt, __VA_ARGS__ )
#define LogError( fmt, ... ) g_Log->Write( Logger::LOG_ERROR, fmt, __VA_ARGS__ )
#define LogWarning( fmt, ... ) g_Log->Write( Logger::LOG_WARNING, fmt, __VA_ARGS__ )
#define LogInfo( fmt, ... ) g_Log->Write( Logger::LOG_INFO, fmt, __VA_ARGS__ )
#define LogDebug( fmt, ... ) g_Log->Write( Logger::LOG_DEBUG, fmt, __VA_ARGS__ )