#include "log.h"
#include <cassert>
#include <ctime>

const char* LevelName[] = {"", "ERROR", "WARNING", "INFO", "DEBUG" };

Logger::Logger(const char* path):i_maxLevel(LOG_INFO)
{
	out = fopen(path, "w");
	if(!out)
		out = stderr;
}

void Logger::WriteRaw( const char* fmt, ...  )
{
	Locker locker(*this);

	va_list arg;
	va_start(arg, fmt);
	vfprintf(out, fmt, arg);
	va_end(arg);
	fprintf(out, "\n");

	fflush(out);
}

void Logger::Write( int level, const char* fmt, ...  )
{
	Locker lock(*this);
	assert( level >= LOG_ERROR && level <= LOG_DEBUG );
	if( level > i_maxLevel )return;

	time_t rawtm;
	tm timeinfo;

	time(&rawtm);
	localtime_s(&timeinfo, &rawtm);

	strftime(buffer, 50, "%c", &timeinfo);
	fprintf(out, "[%s]%s: ", buffer, LevelName[level]);

	va_list arg;
	va_start(arg, fmt);
	vfprintf(out, fmt, arg);
	va_end(arg);
	fprintf(out, "\n");

	fflush(out);
}