#include "configs.h"
#include "log.h"

extern const char* const LogPath;
const char* const PackageName = "hdtHighHeelEffect";
const char* const MCMPackageName = "hdtHighHeelMCM";

namespace Configs
{
	INIWrapper<float> offset("Adapter", "fGlobalOffset", 0.f, INIPath);
	INIWrapper<int> optionals("Adapter", "bfOptionals", 0x0FB, INIPath);
	INIWrapper<int> stableMode("Adapter", "iStableMode", 1, INIPath);
	INIWrapper<float> stableModeMaxSwing("Adapter", "fStableModeMaxSwing", 1.f, INIPath);

	INIWrapper<int> decalUpdate("Performance", "iDecalUpdate", 20, INIPath);
	INIWrapper<int> priority("Performance", "iThreadPriority", -1, INIPath);

	INIWrapper<int> logLevel("Debug", "iLogLevel", Logger::LOG_INFO, INIPath);
	INIWrapper<bool> enableDebugInfo("Debug", "bEnableDebugInfo", false, INIPath);

	void ReloadAll()
	{
		offset.reload();
		optionals.reload();
		stableMode.reload();
		stableModeMaxSwing.reload();

		decalUpdate.reload();
		priority.reload();

		logLevel.reload();
		enableDebugInfo.reload();
	}
}

void ReloadConfigs(StaticFunctionTag*)
{
	Configs::ReloadAll();
}

#define FAST_CREATE_PROPERTY( name, type, valname ) \
	type Get##name(StaticFunctionTag*){ return valname; }\
	void Set##name(StaticFunctionTag*, type val){ valname.set(val); }

FAST_CREATE_PROPERTY(GlobalOffset, float, Configs::offset);

bool GetOptionalFlgs(StaticFunctionTag*, SInt32 bit)
{
	int mask = (1 << bit);
	return mask & Configs::optionals;
}

void SetOptionalFlgs(StaticFunctionTag*, SInt32 bit, bool val)
{
	int mask = (1 << bit);
	Configs::optionals.set(~mask & Configs::optionals | (val ? mask: 0));
}

bool IsDebugInfoEnable(StaticFunctionTag*)
{
	return Configs::enableDebugInfo;
}
void SetDebugInfoEnable(StaticFunctionTag*, bool val)
{
	return Configs::enableDebugInfo.set(val);
}

FAST_CREATE_PROPERTY(StableMode, SInt32, Configs::stableMode);
FAST_CREATE_PROPERTY(StableModeMaxSwing, float, Configs::stableModeMaxSwing);

FAST_CREATE_PROPERTY(DecalUpdate, SInt32, Configs::decalUpdate);
FAST_CREATE_PROPERTY(ThreadPriority, SInt32, Configs::priority);
FAST_CREATE_PROPERTY(LogLevel, SInt32, Configs::logLevel);

bool Configs::RegisterFunctions(VMClassRegistry * registry)
{
	AutoRegisterFunction(GetOptionalFlgs, PackageName, registry);
	AutoRegisterFunction(IsDebugInfoEnable, PackageName, registry);

	AutoRegisterFunction(GetGlobalOffset, MCMPackageName, registry);
	AutoRegisterFunction(SetGlobalOffset, MCMPackageName, registry);
	AutoRegisterFunction(GetOptionalFlgs, MCMPackageName, registry);
	AutoRegisterFunction(SetOptionalFlgs, MCMPackageName, registry);
	AutoRegisterFunction(GetStableMode, MCMPackageName, registry);
	AutoRegisterFunction(SetStableMode, MCMPackageName, registry);
	AutoRegisterFunction(GetStableModeMaxSwing, MCMPackageName, registry);
	AutoRegisterFunction(SetStableModeMaxSwing, MCMPackageName, registry);


	AutoRegisterFunction(GetDecalUpdate, MCMPackageName, registry);
	AutoRegisterFunction(SetDecalUpdate, MCMPackageName, registry);
	AutoRegisterFunction(GetThreadPriority, MCMPackageName, registry);
	AutoRegisterFunction(SetThreadPriority, MCMPackageName, registry);

	AutoRegisterFunction(IsDebugInfoEnable, MCMPackageName, registry);
	AutoRegisterFunction(SetDebugInfoEnable, MCMPackageName, registry);
	AutoRegisterFunction(GetLogLevel, MCMPackageName, registry);
	AutoRegisterFunction(SetLogLevel, MCMPackageName, registry);
	
	return true;
}