#include "common.h"

const char* const INIPath = "data/skse/plugins/"PLUGIN_NAME".ini";
const char* const LogPath = "data/skse/plugins/"PLUGIN_NAME".log";
Logger _g_Log(LogPath), *g_Log = &_g_Log;

#include "Adapter.h"
#include "configs.h"
#include "CustomEnchManager.h"

const float fPluginVersion = 0.3f;

float GetCoreVersion(StaticFunctionTag*){ return fPluginVersion; }

bool RegisterFunctions(VMClassRegistry * registry)
{
	Adapter::RegisterFunctions(registry);
	Configs::RegisterFunctions(registry);
	CustomEnchManager::RegisterFunctions(registry);

	AutoRegisterFunction(GetCoreVersion, "hdtHighHeel_LoadGame", registry);

	return true;
}