#pragma once

#include <Windows.h>
#include <process.h>

class Lockable
{
public:
	Lockable(){ InitializeCriticalSectionAndSpinCount(&cs, 4000); }
	~Lockable(){ DeleteCriticalSection(&cs); }

	void lock(){ EnterCriticalSection(&cs); }
	void unlock(){ LeaveCriticalSection(&cs); }
private:

	Lockable(const Lockable&){}
	Lockable& operator =(const Lockable&){}

	CRITICAL_SECTION cs;
};

class Locker
{
public:
	Locker(Lockable& obj):object(obj){ object.lock(); }
	~Locker(){ object.unlock(); }
private:
	Lockable& object;
};

class Thread
{
public:
	Thread(void);
	~Thread(void);

	void* arglist;
	void (*func)(void*);

	int run(int priority = THREAD_PRIORITY_NORMAL);
	void wait();
	void suspend(){ SuspendThread(thread); }
	void resume(){ ResumeThread(thread); }
	HANDLE get_handle(){ return thread; }
protected:

	HANDLE thread;
	static unsigned __stdcall wapper(void*);
};

class Event
{
public:
	Event(bool state = FALSE):handle(CreateEvent(0, TRUE, state, 0)){}
	~Event(){CloseHandle(handle);}
	int wait(){ return WaitForSingleObject(handle, INFINITE); }
	void set(){ SetEvent(handle); }
	void reset(){ ResetEvent(handle); }

	HANDLE GetHandle(){ return handle; }
protected:
	HANDLE handle;
};
