#include "Thread.h"
#include "log.h"

Thread::Thread(void)
{
	func = 0;
	arglist = 0;
	thread = 0;
}


Thread::~Thread(void)
{
	wait();
}

unsigned __stdcall Thread::wapper(void* arg)
{
	Thread* t = (Thread*)arg;
	if(!t->func)
		return -1;
	t->func(t->arglist);
	return 0;
}

int Thread::run(int priority)
{
	thread = (HANDLE)_beginthreadex(0, 0, wapper, this, CREATE_SUSPENDED, 0);
	if( !(thread && SetThreadPriority(thread, priority)) )
	{
		LogError("failed to create thread.. %d", GetLastError());
		return -1;
	}

	if(ResumeThread(thread) == -1)
	{
		LogError("failed to run thread.. %d", GetLastError());
		CloseHandle(thread);
		return -1;
	}
	return 0;
}

void Thread::wait()
{
	resume();
	WaitForSingleObject(thread, INFINITE);
	CloseHandle(thread);
	thread = 0;
}
