#pragma once

#include "common.h"
#include <intrin.h>

class _CRT_ALIGN(16) Vector
{
public:

	Vector(){ dat = _mm_setzero_ps(); }
	Vector(float x, float y=0, float z=0, float w=0):dat(_mm_setr_ps(x, y, z, w)){}
	Vector(const NiPoint3& rhs):dat(_mm_setr_ps(rhs.x, rhs.y, rhs.z, 0)){}
	Vector(const __m128& rhs):dat(rhs){}

	Vector CrossProduct(const Vector& rhs) const
	{
		__m128 a = _mm_shuffle_ps(dat, dat, _MM_SHUFFLE(3, 0, 2, 1));
		__m128 b = _mm_shuffle_ps(rhs.dat, rhs.dat, _MM_SHUFFLE(3, 1, 0, 2));
		__m128 c = _mm_mul_ps(a, b);
		a = _mm_shuffle_ps(a, a, _MM_SHUFFLE(3, 0, 2, 1));
		b = _mm_shuffle_ps(b, b, _MM_SHUFFLE(3, 1, 0, 2));
		__m128 d = _mm_mul_ps(a, b);
		return _mm_sub_ps(c, d);
	}
	__m128 _DotProductV(const Vector& rhs) const
	{
		__m128 t = _mm_mul_ps(dat, rhs.dat);
		t = _mm_hadd_ps(t, t);
		return _mm_hadd_ps(t, t);
	}
	float DotProduct(const Vector& rhs) const { return _DotProductV(rhs).m128_f32[0]; }
	__m128 _MagnitudeV() const{ return _mm_sqrt_ps(_DotProductV(*this)); }
	float Magnitude() const{ return _MagnitudeV().m128_f32[0]; }
	void Normalize(){ dat = _mm_div_ps(dat, _MagnitudeV()); }

	inline Vector& operator +=(const Vector& rhs)
	{
		dat = _mm_add_ps(dat, rhs.dat);
		return *this;
	}
	
	inline Vector& operator -=(const Vector& rhs)
	{
		dat = _mm_sub_ps(dat, rhs.dat);
		return *this;
	}
	
	inline Vector& operator *=(float rhs)
	{
		dat = _mm_mul_ps(dat, _mm_set_ps1(rhs));
		return *this;
	}
	
	inline Vector& operator /=(float rhs)
	{
		dat = _mm_div_ps(dat, _mm_set_ps1(rhs));
		return *this;
	}

	Vector operator +(const Vector& rhs) const{ return _mm_add_ps(dat, rhs.dat); }
	Vector operator -(const Vector& rhs) const{ return _mm_sub_ps(dat, rhs.dat); }
	Vector operator *(float rhs) const{ return _mm_mul_ps(dat, _mm_set_ps1(rhs)); }
	Vector operator /(float rhs) const{ return _mm_div_ps(dat, _mm_set_ps1(rhs)); }

	union{
		struct
		{
			float x, y, z, w;
		};
		__m128 dat;
	};
};
