#pragma once

#include <cstdio>
#include <unordered_set>
#include <vector>
#include <string>

#include "common.h"

class CustomEnchManager
{
public:
	CustomEnchManager(void){}
	~CustomEnchManager(void){}

	struct NODE
	{
		NODE():form(0){}
		NODE(int f):form(f){}

		void Release()const;
		inline operator int()const{ return form; }

		int form;
	};

	struct CustomEnch
	{
		int enchFormID;
		std::unordered_set<NODE, std::hash<int>> forms;
	};

	void addEnchType(EnchantmentItem* item);
	void enchant(TESObjectARMO* form, int type);
	void remove(TESObjectARMO* form);
	
	void load();
	void clear();
	void save();

	static void RegisterFunctions(VMClassRegistry* registry);
private:

	FILE* file;

	std::vector<CustomEnch> enchInfo;
	std::vector<std::string> modlist;
		
	template <class T> T read();
	template <class T> void read(T& ret){ ret = read<T>(); }
	template <class T> void write(const T& a);
};
