Scriptname hdtHighHeelMCM extends SKI_ConfigBase

Enchantment Property hdtHHENCHcustom1  Auto
Enchantment Property hdtHHENCHcustom2  Auto
Enchantment Property hdtHHENCHcustom3  Auto
MagicEffect Property HighHeelEffect  Auto

float Function GetGlobalOffset() global native
Function SetGlobalOffset(float val) global native
bool Function GetOptionalFlgs(int bit) global native
Function SetOptionalFlgs(int bit, bool val) global native
int Function GetStableMode() global native
Function SetStableMode(int val) global native
float Function GetStableModeMaxSwing() global native
Function SetStableModeMaxSwing(float val) global native

int Function GetDecalUpdate() global native
Function SetDecalUpdate(int val) global native
int Function GetThreadPriority() global native
Function SetThreadPriority(int val) global native

int Function GetLogLevel() global native
Function SetLogLevel(int val) global native
bool Function IsDebugInfoEnable() global native
Function SetDebugInfoEnable(bool val) global native

Function EnchManagerClear() global native
Function EnchManagerLoad() global native
Function EnchManagerSave() global native
Function RegisterCustomEnch(Enchantment ench) global native
Function SetEnchNthMagnitude(Enchantment ench, int idx, float val) global native
Function AttachEnchantment(Armor shoes, int idx) global native
Function RemoveEnchantment(Armor shoes) global native
	
bool Property enableDebugInfo hidden
	bool Function Get()
		return IsDebugInfoEnable();
	endFunction
	Function Set(bool newValue)
		SetDebugInfoEnable(newValue)
	endFunction
endProperty

bool Property enableWhenAlchemy hidden
	bool Function Get()
		return GetOptionalFlgs(0);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(0, newVal);
	endFunction
endProperty

bool Property enableWhenSmithing hidden
	bool Function Get()
		return GetOptionalFlgs(1);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(1, newVal);
	endFunction
endProperty

bool Property enableWhenSharpeningWheel hidden
	bool Function Get()
		return GetOptionalFlgs(2);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(2, newVal);
	endFunction
endProperty

bool Property enableWhenArmorTable hidden
	bool Function Get()
		return GetOptionalFlgs(3);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(3, newVal);
	endFunction
endProperty

bool Property enableWhenEnchanting hidden
	bool Function Get()
		return GetOptionalFlgs(4);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(4, newVal);
	endFunction
endProperty

bool Property enableWhenTanningRack hidden
	bool Function Get()
		return GetOptionalFlgs(5);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(5, newVal);
	endFunction
endProperty

bool Property enableWhenCookpot hidden
	bool Function Get()
		return GetOptionalFlgs(6);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(6, newVal);
	endFunction
endProperty

bool property enableWhenSmelter hidden
	bool Function Get()
		return GetOptionalFlgs(7);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(7, newVal);
	endFunction
endProperty

bool property enableWhenFirstPerson hidden
	bool Function Get()
		return GetOptionalFlgs(8);
	endFunction
	Function Set(bool newVal)
		SetOptionalFlgs(8, newVal);
	endFunction
endProperty

int cm_offset
;int cm_resetHeight

int cm_alchemy
int cm_smithing
int cm_sharpening
int cm_armortable
int cm_enchanting
int cm_tanningrack
int cm_cookpot
int cm_smelter
int cm_firstPerson

int cm_stableMode
int cm_stableModeMaxSwing

int cm_decalUpdate
int cm_priority

int cm_debug
int cm_loglevel

int cm_bootinfo;
int cm_removeEnch
int cm_attachEnchcustom1
int cm_Enchcustomvar1
int cm_attachEnchcustom2
int cm_Enchcustomvar2
int cm_attachEnchcustom3
int cm_Enchcustomvar3

Armor wornboot

int Property attachEnchFlg hidden
	int Function Get()
		if ((wornboot != none) && !Game.GetPlayer().HasMagicEffect(HighHeelEffect))
			return OPTION_FLAG_NONE
		else
			return OPTION_FLAG_DISABLED
		endif
	endFunction
endProperty

int Property removeEnchFlg hidden
	int Function Get()
		if wornboot != none && (wornboot.GetEnchantment() == hdtHHENCHcustom1 || wornboot.GetEnchantment() == hdtHHENCHcustom2 || wornboot.GetEnchantment() == hdtHHENCHcustom3)
			return OPTION_FLAG_NONE
		else
			return OPTION_FLAG_DISABLED
		endif
	endFunction
endProperty

float Property hdtHHHcustom1 hidden
	float Function Get()
		return hdtHHENCHcustom1.GetNthEffectMagnitude(0)
	endFunction
	Function Set(float value)
		SetEnchNthMagnitude(hdtHHENCHcustom1, 0, value)
	endFunction
endProperty

float Property hdtHHHcustom2 hidden
	float Function Get()
		return hdtHHENCHcustom2.GetNthEffectMagnitude(0)
	endFunction
	Function Set(float value)
		SetEnchNthMagnitude(hdtHHENCHcustom2, 0, value)
	endFunction
endProperty

float Property hdtHHHcustom3 hidden
	float Function Get()
		return hdtHHENCHcustom3.GetNthEffectMagnitude(0)
	endFunction
	Function Set(float value)
		SetEnchNthMagnitude(hdtHHENCHcustom3, 0, value)
	endFunction
endProperty

string Property bootType
	string Function Get()
		if(wornboot == none)
			return ""
		elseif(wornboot.GetEnchantment() == hdtHHENCHcustom1)
			return "$hdtHighHeel_CustomEnchHighHeel1"
		elseif(wornboot.GetEnchantment() == hdtHHENCHcustom2)
			return "$hdtHighHeel_CustomEnchHighHeel2"
		elseif(wornboot.GetEnchantment() == hdtHHENCHcustom3)
			return "$hdtHighHeel_CustomEnchHighHeel3"
		elseif( Game.GetPlayer().HasMagicEffect(HighHeelEffect) )
			return "$hdtHighHeel_buildingHighHeel"
		else
			return "$hdtHighHeel_isNotHighHeel"
		endif
	endFunction
endProperty

;
event OnPageReset(string a_page)
	
	SetCursorFillMode(TOP_TO_BOTTOM)
	
	if(a_page == "$hdtHighHeel_config")
		
		AddHeaderOption("$hdtHighHeel_heightoffset") 	;AddHeaderOption("߶")
		cm_offset = AddSliderOption("$hdtHighHeel_Globalheightoffset", GetGlobalOffset(), "{1}")
;		cm_resetHeight = AddTextOption("$hdtHighHeel_resetHeight", "$hdtHighHeel_clicktoreset")
		
		AddEmptyOption()
		AddHeaderOption("$hdtHighHeel_debuging") 	;	AddHeaderOption("")
		cm_debug = AddToggleOption("$hdtHighHeel_showdebuginfo", enableDebugInfo)
		cm_loglevel = AddSliderOption("$hdtHighHeel_LogLevel", GetLogLevel(), "{0}");
		
		AddEmptyOption()
		AddHeaderOption("$hdtHighHeel_performance");
		cm_decalUpdate = AddSliderOption("$hdtHighHeel_decalUpdate", GetDecalUpdate(), "{0}");
		cm_priority = AddSliderOption("$hdtHighHeel_priority", GetThreadPriority(), "{0}");
		
		SetCursorPosition(1)
		AddHeaderOption("$hdtHighHeel_miscellaneous");
		cm_alchemy = AddToggleOption("$hdtHighHeel_Alchemy", enableWhenAlchemy);
		cm_smithing = AddToggleOption("$hdtHighHeel_Smithing", enableWhenSmithing);
		cm_sharpening = AddToggleOption("$hdtHighHeel_SharpeningWheel", enableWhenSharpeningWheel);
		cm_armortable = AddToggleOption("$hdtHighHeel_ArmorTable", enableWhenArmorTable);
		cm_enchanting = AddToggleOption("$hdtHighHeel_Enchanting", enableWhenEnchanting);
		cm_tanningrack = AddToggleOption("$hdtHighHeel_TanningRack", enableWhenTanningRack);
		cm_cookpot = AddToggleOption("$hdtHighHeel_Cookpot", enableWhenCookpot);
		cm_smelter = AddToggleOption("$hdtHighHeel_Smelter", enableWhenSmelter);
		;cm_firstPerson = AddToggleOption("$hdtHighHeel_FirstPerson", enableWhenFirstPerson);
		
		AddEmptyOption()
		cm_stableMode = AddSliderOption("$hdtHighHeel_StableMode", GetStableMode(), "{0}")
		cm_stableModeMaxSwing = AddSliderOption("$hdtHighHeel_StableModeMaxSwing", GetStableModeMaxSwing(), "{1}")
		
	elseif(a_page == "$hdtHighHeel_customEnch")
		
		wornboot = Game.GetPlayer().GetWornForm(0x80) as Armor
		AddHeaderOption(wornboot.getname())
		cm_bootinfo = AddTextOption("$hdtHighHeel_bootType", bootType, OPTION_FLAG_DISABLED)
		cm_attachEnchcustom1 = AddTextOption("$hdtHighHeel_attachEnchcustom1", "$hdtHighHeel_clickToAttachEnch", attachEnchFlg)
		cm_Enchcustomvar1 = AddSliderOption("$hdtHighHeel_customheight1",hdtHHHcustom1, "{1}")
		cm_attachEnchcustom2 = AddTextOption("$hdtHighHeel_attachEnchcustom2", "$hdtHighHeel_clickToAttachEnch", attachEnchFlg)
		cm_Enchcustomvar2 = AddSliderOption("$hdtHighHeel_customheight2",hdtHHHcustom2, "{1}")
		cm_attachEnchcustom3 = AddTextOption("$hdtHighHeel_attachEnchcustom3", "$hdtHighHeel_clickToAttachEnch", attachEnchFlg)
		cm_Enchcustomvar3 = AddSliderOption("$hdtHighHeel_customheight3",hdtHHHcustom3, "{1}")
		cm_removeEnch = AddTextOption("$hdtHighHeel_removeEnch", "$hdtHighHeel_clickToRemoveEnch", removeEnchFlg)
		
	else
		if(hdtHighHeel_LoadGame.IsSystemRunningNormally())
			AddHeaderOption("$hdtHighHeel_SystemRunningNormally")
		else
			AddHeaderOption("$hdtHighHeel_SystemRunningExceptively")
		endif
		
	endif
	
endevent

;ָĬֵ
event OnOptionDefault(int a_option)
	
	; main page
	if(a_option == cm_offset)
		SetGlobalOffset(0)   ;Ĭ0
		SetSliderOptionValue(a_option, GetGlobalOffset(),"{1}")   ;ˢʾ
		
	;performance
	elseif(a_option == cm_decalUpdate)
		SetDecalUpdate(20);
		SetSliderOptionValue(a_option, GetDecalUpdate(),"{0}")
	elseif(a_option == cm_priority)
		SetThreadPriority(-1);BELOW_NORMAL
		SetSliderOptionValue(a_option, GetThreadPriority(),"{0}")
		
	;debug
	elseif(a_option == cm_debug)
		enableDebugInfo = false;
		SetToggleOptionValue(cm_debug, enableDebugInfo);
	elseif(a_option == cm_loglevel)
		SetLogLevel(3)	;LOG_INFO
		SetSliderOptionValue(a_option, GetLogLevel(),"{0}")
		
	;optionals
	elseif(a_option == cm_alchemy)
		enableWhenAlchemy = true;
		SetToggleOptionValue(cm_alchemy, enableWhenAlchemy);
	elseif(a_option == cm_smithing)
		enableWhenSmithing = true;
		SetToggleOptionValue(cm_smithing, enableWhenSmithing);
	elseif(a_option == cm_sharpening)
		enableWhenSharpeningWheel = false
		SetToggleOptionValue(cm_sharpening, enableWhenSharpeningWheel);
	elseif(a_option == cm_armortable)
		enableWhenArmorTable = true;
		SetToggleOptionValue(cm_armortable, enableWhenArmorTable);
	elseif(a_option == cm_enchanting)
		enableWhenEnchanting = true;
		SetToggleOptionValue(cm_enchanting, enableWhenEnchanting);
	elseif(a_option == cm_tanningrack)
		enableWhenTanningRack = true;
		SetToggleOptionValue(cm_tanningrack, enableWhenTanningRack);
	elseif(a_option == cm_cookpot)
		enableWhenCookpot = true;
		SetToggleOptionValue(cm_cookpot, enableWhenCookpot);
	elseif(a_option == cm_smelter)
		enableWhenSmelter = true;
		SetToggleOptionValue(cm_smelter, enableWhenSmelter);
	;elseif(a_option == cm_firstPerson)
	;	enableWhenFirstPerson = false;
	;	SetToggleOptionValue(cm_firstPerson, enableWhenFirstPerson);
		
	elseif(a_option == cm_stableMode)
		SetStableMode(1);
		SetSliderOptionValue(a_option, GetStableMode(),"{0}")
	elseif(a_option == cm_stableModeMaxSwing)
		SetStableModeMaxSwing(1.0);
		SetSliderOptionValue(a_option, GetStableModeMaxSwing(),"{1}")
		
	;subpage customEnch
	elseif(a_option == cm_Enchcustomvar1)
		hdtHHHcustom1 = 8.0   ;Ĭ0
		SetSliderOptionValue(a_option, hdtHHHcustom1,"{1}")
	elseif(a_option == cm_Enchcustomvar2)
		hdtHHHcustom2 = 11.8   ;Ĭ0
		SetSliderOptionValue(a_option, hdtHHHcustom2,"{1}")	
	elseif(a_option == cm_Enchcustomvar3)
		hdtHHHcustom3 = 15   ;Ĭ0
		SetSliderOptionValue(a_option, hdtHHHcustom3,"{1}")	
	endif
	
endEvent


;¼
event OnOptionSliderOpen(int a_option)
	
	wornboot = Game.GetPlayer().GetWornForm(0x80) as Armor
	
	if(a_option ==  cm_offset)
		SetSliderDialogStartValue(GetGlobalOffset())
		SetSliderDialogDefaultValue(0)
		SetSliderDialogRange(-20.00, 20.00)
		SetSliderDialogInterval(0.10)
		
	elseif(a_option == cm_stableMode)
		SetSliderDialogStartValue(GetStableMode())
		SetSliderDialogDefaultValue(1)
		SetSliderDialogRange(0,2)
		SetSliderDialogInterval(1)
	elseif(a_option == cm_stableModeMaxSwing)
		SetSliderDialogStartValue(GetStableModeMaxSwing())
		SetSliderDialogDefaultValue(1)
		SetSliderDialogRange(0,10)
		SetSliderDialogInterval(0.1)
		
	elseif(a_option == cm_decalUpdate)
		SetSliderDialogStartValue(GetDecalUpdate())
		SetSliderDialogDefaultValue(20)
		SetSliderDialogRange(0, 100)
		SetSliderDialogInterval(1)
	elseif(a_option == cm_priority)
		SetSliderDialogStartValue(GetThreadPriority())
		SetSliderDialogDefaultValue(-1)
		SetSliderDialogRange(-2, 2); Low, Below Normal, Normal, Above Normal, High
		SetSliderDialogInterval(1)
		
	elseif(a_option == cm_logLevel)
		SetSliderDialogStartValue(GetLogLevel())
		SetSliderDialogDefaultValue(3)
		SetSliderDialogRange(0, 4); None, Error, Warning, Info, Debug
		SetSliderDialogInterval(1)
		
	elseif (a_option ==  cm_Enchcustomvar1)
		SetSliderDialogStartValue(hdtHHHcustom1)
		SetSliderDialogDefaultValue(8)
		SetSliderDialogRange(0, 30.00)
		SetSliderDialogInterval(0.10)
	elseif (a_option ==  cm_Enchcustomvar2)
		SetSliderDialogStartValue(hdtHHHcustom2)
		SetSliderDialogDefaultValue(11.8)
		SetSliderDialogRange(0, 30.00)
		SetSliderDialogInterval(0.10)
	elseif (a_option ==  cm_Enchcustomvar3)
		SetSliderDialogStartValue(hdtHHHcustom3)
		SetSliderDialogDefaultValue(15)
		SetSliderDialogRange(0, 30.00)
		SetSliderDialogInterval(0.10)
	endIf
endevent

Function UpdateBootInfo()
	Actor player = Game.GetPlayer();
	player.UnequipItem(wornboot,false,true)
	player.equipItem(wornboot,false,true)	
	SetTextOptionValue(cm_bootinfo, bootType)
	SetOptionFlags(cm_attachEnchcustom1, attachEnchFlg)
	SetOptionFlags(cm_attachEnchcustom2, attachEnchFlg)
	SetOptionFlags(cm_attachEnchcustom3, attachEnchFlg)
	SetOptionFlags(cm_removeEnch, removeEnchFlg)
endFunction

event OnOptionSelect(int a_option)
	Actor player = Game.GetPlayer();
	wornboot = player.GetWornForm(0x80) as Armor
	
	if( a_option == cm_debug )
		enableDebugInfo = !enableDebugInfo;
		SetToggleOptionValue(cm_debug, enableDebugInfo);
		
	elseif( a_option == cm_alchemy )
		enableWhenAlchemy = !enableWhenAlchemy;
		SetToggleOptionValue(cm_alchemy, enableWhenAlchemy);
	elseif( a_option == cm_smithing )
		enableWhenSmithing = !enableWhenSmithing;
		SetToggleOptionValue(cm_smithing, enableWhenSmithing);
	elseif( a_option == cm_sharpening )
		enableWhenSharpeningWheel = !enableWhenSharpeningWheel;
		SetToggleOptionValue(cm_sharpening, enableWhenSharpeningWheel);
	elseif( a_option == cm_armortable )
		enableWhenArmorTable = !enableWhenArmorTable;
		SetToggleOptionValue(cm_armortable, enableWhenArmorTable);
	elseif( a_option == cm_enchanting )
		enableWhenEnchanting = !enableWhenEnchanting;
		SetToggleOptionValue(cm_enchanting, enableWhenEnchanting);
	elseif( a_option == cm_tanningrack )
		enableWhenTanningRack = !enableWhenTanningRack;
		SetToggleOptionValue(cm_tanningrack, enableWhenTanningRack);
	elseif( a_option == cm_cookpot )
		enableWhenCookpot = !enableWhenCookpot;
		SetToggleOptionValue(cm_cookpot, enableWhenCookpot);
	elseif( a_option == cm_smelter )
		enableWhenSmelter = !enableWhenSmelter;
		SetToggleOptionValue(cm_smelter, enableWhenSmelter);
	;elseif( a_option == cm_firstPerson )
	;	enableWhenFirstPerson = !enableWhenFirstPerson;
	;	SetToggleOptionValue(cm_firstPerson, enableWhenFirstPerson);
		
;	elseif(a_option == cm_resetHeight )
;		hdtHighHeelEffect.AdapterClear();
;		SetOptionFlags(cm_resetHeight, OPTION_FLAG_DISABLED)
		
	elseif 	(a_option == cm_attachEnchcustom1)
		AttachEnchantment(wornboot, 0);
		UpdateBootInfo()
	
	elseif 	(a_option == cm_attachEnchcustom2)
		AttachEnchantment(wornboot, 1);
		UpdateBootInfo()
		
	elseif 	(a_option == cm_attachEnchcustom3)
		AttachEnchantment(wornboot, 2);
		UpdateBootInfo()
		
	elseif 	(a_option == cm_removeEnch)
		RemoveEnchantment(wornboot);
		UpdateBootInfo()
	endif
	
endevent

event OnOptionSliderAccept(int a_option, float value)
	if (a_option == cm_offset)
		SetGlobalOffset(value)
		SetSliderOptionValue(a_option, value,"{1}")
		SetOptionFlags(cm_resetHeight, OPTION_FLAG_NONE)
		
	elseif (a_option == cm_decalUpdate)
		SetDecalUpdate(Math.Ceiling(value))
		SetSliderOptionValue(a_option, value, "{0}");
	elseif(a_option == cm_priority)
		SetThreadPriority(Math.Ceiling(value))
		SetSliderOptionValue(a_option, value, "{0}");
		
	elseif(a_option == cm_stableMode)
		SetStableMode(Math.Ceiling(value));
		SetSliderOptionValue(a_option, value, "{0}")
	elseif(a_option == cm_stableModeMaxSwing)
		SetStableModeMaxSwing(value);
		SetSliderOptionValue(a_option, value, "{1}")
		
	elseif(a_option == cm_logLevel)
		SetLogLevel(Math.Ceiling(value))
		SetSliderOptionValue(a_option, value, "{0}");
		
	elseif (a_option == cm_Enchcustomvar1)
		hdtHHHcustom1 = value
		SetSliderOptionValue(a_option, hdtHHHcustom1,"{1}")
		Game.GetPlayer().UnequipItem(wornboot,false,true)
		Game.GetPlayer().equipItem(wornboot,false,true)	
	elseif (a_option == cm_Enchcustomvar2)
		hdtHHHcustom2 = value
		SetSliderOptionValue(a_option, hdtHHHcustom2,"{1}")
		Game.GetPlayer().UnequipItem(wornboot,false,true)
		Game.GetPlayer().equipItem(wornboot,false,true)	
	elseif (a_option == cm_Enchcustomvar3)
		hdtHHHcustom3 = value
		SetSliderOptionValue(a_option, hdtHHHcustom3,"{1}")
		Game.GetPlayer().UnequipItem(wornboot,false,true)
		Game.GetPlayer().equipItem(wornboot,false,true)	
	endIf
	
endEvent   

;ͣʱʾ֣˵ײ
event OnOptionHighlight(int a_option)
	if (a_option == cm_offset)
		SetInfoText("$hdtHighHeel_highlightOffset")
	elseif(a_option == cm_resetHeight)
		SetInfoText("$hdtHighHeel_highlightResetHeight")
		
	elseif(a_option == cm_stableMode)
		SetInfoText("$hdtHighHeel_highlightStableMode")
	elseif(a_option == cm_stableModeMaxSwing)
		SetInfoText("$hdtHighHeel_highlightStableModeMaxSwing")
		
	elseif (a_option == cm_decalUpdate)
		SetInfoText("$hdtHighHeel_highlightDecalUpdate")
	elseif(a_option == cm_priority)
		SetInfoText("$hdtHighHeel_highlightPriority")
		
	elseif  (a_option == cm_debug)
		SetInfoText("$hdtHighHeel_highlightDebug")
	elseif (a_option == cm_logLevel)
		SetInfoText("$hdtHighHeel_highlightLogLevel")
		
	elseif (a_option == cm_removeEnch)
			SetInfoText("$hdtHighHeel_highlightRemove")
	elseif (a_option == cm_resetHeight )
		SetInfoText("$hdtHighHeel_highlightResetHeight");
	elseif (a_option == cm_attachEnchcustom1)
		SetInfoText("$hdtHighHeel_highlightcustom1");
	elseif (a_option == cm_attachEnchcustom2 )
		SetInfoText("$hdtHighHeel_highlightcustom2");
	elseif (a_option == cm_attachEnchcustom3 )
		SetInfoText("$hdtHighHeel_highlightcustom3");
	endIf
endevent

Event OnInit()
	parent.OnInit();
	
	ModName = "$hdtHighHeel_menuname"
	
	Pages = new String[2];
	Pages[0] = "$hdtHighHeel_config";
	Pages[1] = "$hdtHighHeel_customEnch"
	
	EnchManagerClear();
	RegisterCustomEnch(hdtHHENCHcustom1);
	RegisterCustomEnch(hdtHHENCHcustom2);
	RegisterCustomEnch(hdtHHENCHcustom3);
	EnchManagerLoad();
endEvent

Event OnGameReload()
	parent.OnGameReload()
	
	ModName = "$hdtHighHeel_menuname"
	
	Pages = new String[2];
	Pages[0] = "$hdtHighHeel_config";
	Pages[1] = "$hdtHighHeel_customEnch"
	
	EnchManagerClear();
	RegisterCustomEnch(hdtHHENCHcustom1);
	RegisterCustomEnch(hdtHHENCHcustom2);
	RegisterCustomEnch(hdtHHENCHcustom3);
	EnchManagerLoad();
endEvent

Event OnConfigClose()
	EnchManagerSave();
endEvent