﻿<%@ page language="C#" autoeventwireup="true" inherits="go_Default, App_Web_mn45emcx" %>

<%@ Register Src="top.ascx" TagName="TagName" TagPrefix="MyTop" %>
<%@ Register Src="bottom.ascx" TagName="TagName" TagPrefix="MyBottom" %>
<%@ Register Src="user.ascx" TagName="TagName" TagPrefix="MyUser" %>
<MyTop:TagName ID="uc_01" runat="server" MyValue="Home" />
<style type="text/css">
    .item
    {        
      height:52rem
    }
	.year{
		height:5rem;
		line-height:5rem;
		list-style:none;
		text-align:center;
		font-size:3rem;
		color:#CF0;
		background:#fff;
		opacity:0.8
	}
	.month{
		list-style:none;
		float:left;
		width:33.33%;
		height:12rem;
		color:#6C0;
		box-sizing:border-box;
		padding:1rem;
		font-size:1.8rem;

		
	}
	
	.month_0{
		background-color: rgba(240,240,240,0.95);
	}
	.month_1{
		background-color: rgba(250,250,250,0.95);
	}
	.container{
		height:100%;
		
	}
	#list{
    
	}
	.monthname{
		height:50%;	
	}
	.totalmoney{
		width:100%;
		height:50%;
		text-align:right;
		font-size:1.8rem;
		padding-bottom:0px;
		line-height:5rem;
	}
	
	.viewed{
		color:#3a3;	
	}
	.notview{
		color:#f60;	
	}
</style>

<div class="container" style="padding:0px; margin:auto">
  <div id="list"></div>  
</div>



<div class="modal fade" tabindex="-1" role="dialog" id="modal_salarydetail">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
        <h4 class="modal-title">工资明细</h4>
      </div>
      <div class="modal-body" style="overflow:auto">
        <p>One fine body&hellip;</p>
      </div>
      <div class="modal-footer" style="text-align:center">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div><!-- /.modal-content -->
  </div><!-- /.modal-dialog -->
</div><!-- /.modal -->

<MyUser:TagName ID="user" runat="server" />
<MyBottom:TagName ID="TagName1" runat="server" />
</body> </html> 

<script>
$(document).ready(function(e) {

	$("#modal_salarydetail").find("div[class='modal-body']").css("height",$(document).height()-160);
	

	init();
	loadSalaryList();
	createMask("mymask");
	$("#list").find("li[bttype='monthbt']").bind("click",function(e){
		showSalaryDetail($(this).attr("id"))
	});
		
	$(this).bind("click",function(e){
		var t = e.target;
		var bttype = $(t).attr("bttype");
		switch(bttype){
			case "confirmsalarybt":
				confirmsalary(t);
				break;
			case "auditstatusbt":
				setauditstatus(t)
				break;
			case "opensalaryconfigbt":

				opensalaryconfig(t);
				break;
			case "sendsalaryemailbt":
				sendmysalary(t);
				break;
			case "clearmysalarybt":
				clearmysalary(t);
				break;
		}
	});
});

function clearmysalary(t){
	var o = {};

	o.id = $(t).attr("v");
	o.r = Math.random();
	if(!confirm("确定清除本月工资")){
		return;	
	}
	$.get("clearMySalary.aspx",o,function(d){
		if(d.result=="ok"){
			msgbox("清除完成","success");
			$(t).parent().html("<div class='alert alert-danger'>已经清除</div>");
		}
		else{
			msgbox("清除失败","warning");
		}
	
	},"json");
}


function sendmysalary(t){
	var o = {};
	o.email = $("#email").val();
	o.id = $(t).attr("v");
	o.r = Math.random();
	if(o.email==""){
		$("#email").focus();
		msgbox("请输入email","warning");
		return;	
	}
	
	if(!o.email._Email()){
		$("#email").focus();
		msgbox("email格式错误","warning");
		return;	
	}
	$.get("sendMySalary.aspx",o,function(d){
		if(d.result=="ok"){
			msgbox("工资发送成功","success");
		}
		else{
			msgbox("工资发送错误","warning");
		}
	
	},"json");
}
function opensalaryconfig(t){
	var tableid = $(t).attr("tableid");	
	var id = $(t).attr("data-id");
	$("#msglist"+id).html("载入中...");
	var o = {};
	o.id = id;
	o.tableid = tableid;
	$.get("salaryconfirm_load.aspx",o,function(d){
		var a = [];
		var list = d.list;
		if(list==null){
			a.push("");	
		}
		else{
		for(var i=0;i<list.length;i++){
			a.push("<li class='list-group-item' style='padding:1rem'>");
			a.push("<div class='smallico' style='margin-top:0.5rem;background-image:url(img/ico/"+list[i].icon+")'></div>");
			a.push("<div>");
			a.push(list[i].send);
			a.push("<span style='float:right'>"+list[i].createdate+"</span>");
			a.push("</div>");
			a.push("<p>"+list[i].memo+"</p>");
			a.push("</li>");	
		}
		}
		$("#msglist"+id).html(a.join(""));		
		
	},"json");
}

function setauditstatus(t){
	var v = $(t).attr("v");;

	$("#confirmcontent"+v).css("display",$(t).get(0).value=="2"?"block":"none");
}

function confirmsalary(t){
	var v= $(t).attr("v");
	var tableid = $(t).attr("tableid");
	
	var o = {};
	o.r = Math.random();
	o.tableid = tableid;
	o.id = v;
	o.audit = $("#auditstatus"+v+"_0").get(0).checked?2:($("#auditstatus"+v+"_1").get(0).checked?1:0);	
	o.msg = $("#confirmcontent"+v).val();
	if(o.audit==0){
		msgbox("请选择确认状态","warning");
		return;	
	}
	if(!confirm("确认提交吗?")){
		return;	
	}
	$.post("salary_confirm.aspx?",o,function(d){
		if(d.result=="ok"){
			msgbox("工资确认已经提交","success");				
			$("#t_audit"+tableid).find("div:first").html("<div class='alert alert-info'>工资确认已经提交</label>");
			var list = d.list;
			var a = [];
			if(list==null){
				a.push("");	
			}
			else{
			for(var i=0;i<list.length;i++){
				a.push("<li class='list-group-item' style='padding:1rem'>");
				a.push("<div class='smallico' style='margin-top:0.5rem;background-image:url(img/ico/"+list[i].icon+")'></div>");
				a.push("<div>");
				a.push(list[i].send);
				a.push("<span style='float:right'>"+list[i].createdate+"</span>");
				a.push("</div>");
				a.push("<p>"+list[i].memo+"</p>");
				a.push("</li>");	
			}
			}
			$("#msglist"+v).html(a.join(""));	
			
		}
		else{
			msgbox("工资确认错误","warning");	
		}
	},"json");
}



function init(){
	var date = new Date();
	var y0  = date.getFullYear();
	//y0 = 2018
	var y1 = 2010;
	var a = [];
	for(var i = y0;i>=y1;i--){
		a.push("<div>");
		a.push("<li class='year'>"+i+"年</li>");
		for(var j=1;j<=12;j++){
			a.push("<li class='month month_"+(j%2)+"' id='d_"+i+"_"+j+"' bttype='monthbt'><p class='monthname'>"+j+"月</p><p  id='salary_"+i+"_"+j+"' class='totalmoney'></p></li>");	
		}
		a.push("<div style='clear:both'></div>");
		a.push("</div>");
	}
	$("#list").html(a.join(""));
}






function loadSalaryList(){
	$.get("salary_load.aspx?r="+Math.random(),function(d){
		if(d.result=="ok"){
			var a = d.list;
			if(a==null){
				return;	
			}
			for(var i=0;i<a.length;i++){			
				if(a[i].viewed==1){
					$("#salary_"+a[i].year+"_"+a[i].month).html("<span class='fa fa-cny  viewed' title='已阅'>"+a[i].totalsalary+"11</span>");
				}
				else{
					$("#salary_"+a[i].year+"_"+a[i].month).html("<span class='fa fa-cny notview' title='未阅'>"+a[i].totalsalary+"11</span>");	
				}
			}
		}
	},"json");
}

function showSalaryDetail(id){
	var a = id.split("_");
	var o = {};
	o.y = a[1];
	o.m = a[2];
	$("#mymask").modal("show");
	$.get("salary_loaddetail.aspx", o, function (d) {
	    if (d.result == "bad") {
	        msgbox("系统错误", "warning");
	        return;
	    }
	    if (d.login != "yes") {
	        if (d.result == "systemclose") {
	            window.location.reload();
	        }
	        msgbox("请登录后查询", "warning");
	        $("#mymask").modal("hide");
	        $("#modal_login").modal("show");
	        return;
	    }
	    var b = d.data;
	    var c = [];
	    for (var i = 0; i < b.length; i++) {

	        c.push("<ul class='nav nav-tabs' role='tablist'>");
	        c.push("<li role='presentation' class='active'><a href='#t_info" + b[i].id + "' aria-controls='t_info" + b[i].id + "' role='tab' data-toggle='tab'>工资明细</a></li>");
	        c.push("<li role='presentation'><a href='#t_audit" + b[i].id + "' aria-controls='t_audit" + b[i].id + "' role='tab' data-toggle='tab' bttype='opensalaryconfigbt' tableid='" + b[i].tableid + "' data-id='" + b[i].id + "'>工资确认</a></li>");
	        c.push("<li role='presentation'><a href='#t_email" + b[i].id + "' aria-controls='t_email" + b[i].id + "' role='tab' data-toggle='tab'>发送Email</a></li>");
	        c.push("<li role='presentation'><a href='#t_clear" + b[i].id + "' aria-controls='t_clear" + b[i].id + "' role='tab' data-toggle='tab'>清除工资</a></li>");
	        c.push("</ul>");
	        c.push("<div class='tab-content' style='box-sizing:border-box;padding:1rem'>");
	        c.push("<div role='tabpanel' class='tab-pane active' id='t_info" + b[i].id + "'>");
	        c.push("<table class='table'>");
	        c.push("<caption><h3>" + b[i].year + "年" + b[i].month + "月工资" + (b[i].audit == 1 ? "(已确认)" : "(未确认)") + "</h1>发布日期:" + b[i].createdate + "<br />发布人:" + b[i].un + "</caption>");

	        for (var j = 0; j < b[i].tablecontent.length; j++) {
	            c.push("<tr><td>" + (b[i].tablecontent[j].field) + "</td><td>" + (b[i].tablecontent[j].value) + "</td></tr>");
	        }

	        c.push("</table>");
	        c.push("</div>");
	        c.push("<div role='tabpanel' class='tab-pane' id='t_audit" + b[i].id + "'>");
	        if (b[i].audit != 1) {
	            c.push("<div class='radio'>");
	            c.push("<label class='label label-success'><input type='radio' id='auditstatus" + b[i].id + "_1' name='auditstatus" + b[i].id + "' value='1' bttype='auditstatusbt' v='" + b[i].id + "' />工资无误</label>");
	            c.push("<label class='label label-danger'><input type='radio' id='auditstatus" + b[i].id + "_0' name='auditstatus" + b[i].id + "' value='2' bttype='auditstatusbt' v='" + b[i].id + "' />工资有问题</label>");
	            c.push("</div>");
	            c.push("<textarea class='form-control' style='display:none' id='confirmcontent" + b[i].id + "' placeholder='有问题在此反馈'></textarea>");
	            c.push("<div><button style='margin:1rem;margin-left:0px' class='btn btn-success' bttype='confirmsalarybt' tableid='" + b[i].tableid + "' v='" + b[i].id + "'>提交</button></div>");
	        }
	        else {
	            c.push("<div class='alert alert-success'>工资已经确认</div>");
	        }
	        c.push("<div id='msglist" + b[i].id + "' class='panel panel-default'></div>");
	        //c.push("</div>");
	        c.push("</div>");
	        c.push("<div role='tabpanel' class='tab-pane' id='t_email" + b[i].id + "'>");
	        c.push("<div class='input-group'><span class='input-group-addon'>email</span><input type='email' placeholder='请输入email' class='form-control' id='email' /></div>");
	        c.push("<div><button style='margin:1rem;margin-left:0px' class='btn btn-default' bttype='sendsalaryemailbt' v='" + b[i].id + "'>发送工资到我的email</button></div>");
	        c.push("</div>");
	        c.push("<div role='tabpanel' class='tab-pane' id='t_clear" + b[i].id + "'>");
	        if (b[i].userclear != 1) {
	            c.push("<button bttype='clearmysalarybt' v='" + b[i].id + "' class='btn btn-danger'>清除本月工资记录</button>");
	        }
	        else {
	            c.push("<div class='alert alert-danger'>已经清除</div>");
	        }
	        c.push("</div>");
	        c.push("</div>");

	    }
	    if (d.result == "notdata") {
	        msgbox("无本月工资记录", "warning");
	    }
	    else {
	        $("#modal_salarydetail").find("div[class='modal-body']").html(c.join(""));
	        $("#modal_salarydetail").modal("show");
	    }
	    $("#mymask").modal("hide");
	}, "json");
}
</script>